/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.mirana.bits;

import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pro.fessional.mirana.bits.Bytes;
import pro.fessional.mirana.data.Null;
import pro.fessional.mirana.io.InputStreams;

public class MdHelp {
    public final String algorithm;
    public static final int LEN_MD5_HEX = 32;
    public static final int LEN_SHA1_HEX = 40;
    public static final int LEN_SHA256_HEX = 64;
    public static final MdHelp md5 = MdHelp.of("MD5");
    public static final MdHelp sha1 = MdHelp.of("SHA-1");
    public static final MdHelp sha256 = MdHelp.of("SHA-256");

    protected MdHelp(String algorithm) {
        this.algorithm = algorithm;
    }

    @NotNull
    public String sum(@Nullable String str) {
        return this.sum(str, true);
    }

    @NotNull
    public String sum(@Nullable InputStream ins) {
        return this.sum(ins, true);
    }

    @NotNull
    public String sum(byte @Nullable [] bytes) {
        return Bytes.hex(bytes, true);
    }

    @NotNull
    public String sum(@Nullable String str, boolean upper) {
        if (str == null) {
            return "";
        }
        return this.sum(str.getBytes(StandardCharsets.UTF_8), upper);
    }

    @NotNull
    public String sum(@Nullable InputStream ins, boolean upper) {
        if (ins == null) {
            return "";
        }
        byte[] bytes = InputStreams.readBytes(ins);
        return this.sum(bytes, upper);
    }

    @NotNull
    public String sum(byte @Nullable [] bytes, boolean upper) {
        if (bytes == null) {
            return "";
        }
        byte[] hash = this.digest(bytes);
        return Bytes.hex(hash, upper);
    }

    public byte @NotNull [] digest(byte @Nullable [] bytes) {
        if (bytes == null) {
            return Null.Bytes;
        }
        MessageDigest digest = this.newOne();
        digest.update(bytes);
        return digest.digest();
    }

    @NotNull
    public MessageDigest newOne() {
        return MdHelp.newOne(this.algorithm);
    }

    public boolean check(@Nullable String sum, byte @Nullable [] bytes) {
        if (bytes == null || sum == null) {
            return false;
        }
        String md5 = this.sum(bytes);
        return sum.equalsIgnoreCase(md5);
    }

    public boolean check(@Nullable String sum, @Nullable String str) {
        if (str == null || sum == null) {
            return false;
        }
        String md5 = this.sum(str);
        return sum.equalsIgnoreCase(md5);
    }

    public boolean check(@Nullable String sum, @Nullable InputStream ins) {
        if (ins == null || sum == null) {
            return false;
        }
        String md5 = this.sum(ins);
        return sum.equalsIgnoreCase(md5);
    }

    @NotNull
    public static MdHelp of(@NotNull String algorithm) {
        return new MdHelp(algorithm);
    }

    @NotNull
    public static MessageDigest newMd5() {
        return MdHelp.newOne("MD5");
    }

    @NotNull
    public static MessageDigest newSha1() {
        return MdHelp.newOne("SHA-1");
    }

    @NotNull
    public static MessageDigest newSha256() {
        return MdHelp.newOne("SHA-256");
    }

    @NotNull
    public static MessageDigest newOne(@NotNull String algorithm) {
        try {
            return MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("can not init algorithm=" + algorithm, e);
        }
    }

    public static boolean checks(@Nullable String sum, @Nullable Object obj) {
        MdHelp help;
        if (obj == null || sum == null) {
            return false;
        }
        int len = sum.length();
        if (len == 32) {
            help = md5;
        } else if (len == 40) {
            help = sha1;
        } else if (len == 64) {
            help = sha256;
        } else {
            return false;
        }
        if (obj instanceof CharSequence) {
            return help.check(sum, obj.toString());
        }
        if (obj instanceof byte[]) {
            return help.check(sum, (byte[])obj);
        }
        if (obj instanceof InputStream) {
            return help.check(sum, (InputStream)obj);
        }
        return false;
    }
}

