/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.mirana.cast;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pro.fessional.mirana.data.Null;

public class BoxedCastUtil {
    public static boolean orTrue(@Nullable Boolean b) {
        if (b == null) {
            return true;
        }
        return b;
    }

    public static boolean orFalse(@Nullable Boolean b) {
        if (b == null) {
            return false;
        }
        return b;
    }

    public static char orZero(@Nullable Character n) {
        return BoxedCastUtil.orElse(n, '\u0000');
    }

    public static char orElse(@Nullable Character n, char o) {
        if (n == null) {
            return o;
        }
        return n.charValue();
    }

    public static byte orZero(@Nullable Byte n) {
        return BoxedCastUtil.orElse(n, (byte)0);
    }

    public static byte orElse(@Nullable Byte n, byte o) {
        if (n == null) {
            return o;
        }
        return n;
    }

    public static short orZero(@Nullable Short n) {
        return BoxedCastUtil.orElse(n, (short)0);
    }

    public static short orElse(@Nullable Short n, short o) {
        if (n == null) {
            return o;
        }
        return n;
    }

    public static int orZero(@Nullable Integer n) {
        return BoxedCastUtil.orElse(n, 0);
    }

    public static int orElse(@Nullable Integer n, int o) {
        if (n == null) {
            return o;
        }
        return n;
    }

    public static long orZero(@Nullable Long n) {
        return BoxedCastUtil.orElse(n, 0L);
    }

    public static long orElse(@Nullable Long n, long o) {
        if (n == null) {
            return o;
        }
        return n;
    }

    public static double orZero(@Nullable Double n) {
        return BoxedCastUtil.orElse(n, 0.0);
    }

    public static double orElse(@Nullable Double n, double o) {
        if (n == null) {
            return o;
        }
        return n;
    }

    public static float orZero(@Nullable Float n) {
        return BoxedCastUtil.orElse(n, 0.0f);
    }

    public static float orElse(@Nullable Float n, float o) {
        if (n == null) {
            return o;
        }
        return n.floatValue();
    }

    public static BigDecimal orZero(@Nullable BigDecimal n) {
        return BoxedCastUtil.orElse(n, BigDecimal.ZERO);
    }

    @NotNull
    public static <T> T orElse(@Nullable T n, @NotNull T o) {
        if (n == null) {
            return o;
        }
        return n;
    }

    public static boolean @NotNull [] bools(Collection<Boolean> cols) {
        if (cols == null || cols.isEmpty()) {
            return Null.Bools;
        }
        boolean[] arr = new boolean[cols.size()];
        int i = 0;
        for (Boolean v : cols) {
            arr[i++] = v != null && v != false;
        }
        return arr;
    }

    public static char @NotNull [] chars(Collection<Character> cols) {
        if (cols == null || cols.isEmpty()) {
            return Null.Chars;
        }
        char[] arr = new char[cols.size()];
        int i = 0;
        for (Character v : cols) {
            arr[i++] = v == null ? (char)'\u0000' : v.charValue();
        }
        return arr;
    }

    public static byte @NotNull [] bytes(Collection<? extends Number> cols) {
        if (cols == null || cols.isEmpty()) {
            return Null.Bytes;
        }
        byte[] arr = new byte[cols.size()];
        int i = 0;
        for (Number number : cols) {
            arr[i++] = number == null ? (byte)0 : number.byteValue();
        }
        return arr;
    }

    public static short @NotNull [] shorts(Collection<? extends Number> cols) {
        if (cols == null || cols.isEmpty()) {
            return Null.Shorts;
        }
        short[] arr = new short[cols.size()];
        int i = 0;
        for (Number number : cols) {
            arr[i++] = number == null ? (short)0 : number.shortValue();
        }
        return arr;
    }

    public static int @NotNull [] ints(Collection<? extends Number> cols) {
        if (cols == null || cols.isEmpty()) {
            return Null.Ints;
        }
        int[] arr = new int[cols.size()];
        int i = 0;
        for (Number number : cols) {
            arr[i++] = number == null ? 0 : number.intValue();
        }
        return arr;
    }

    public static long @NotNull [] longs(Collection<? extends Number> cols) {
        if (cols == null || cols.isEmpty()) {
            return Null.Longs;
        }
        long[] arr = new long[cols.size()];
        int i = 0;
        for (Number number : cols) {
            arr[i++] = number == null ? 0L : number.longValue();
        }
        return arr;
    }

    public static float @NotNull [] floats(Collection<? extends Number> cols) {
        if (cols == null || cols.isEmpty()) {
            return Null.Floats;
        }
        float[] arr = new float[cols.size()];
        int i = 0;
        for (Number number : cols) {
            arr[i++] = number == null ? 0.0f : number.floatValue();
        }
        return arr;
    }

    public static double @NotNull [] doubles(Collection<? extends Number> cols) {
        if (cols == null || cols.isEmpty()) {
            return Null.Doubles;
        }
        double[] arr = new double[cols.size()];
        int i = 0;
        for (Number number : cols) {
            arr[i++] = number == null ? 0.0 : number.doubleValue();
        }
        return arr;
    }

    @NotNull
    public static List<Boolean> list(boolean[] arr) {
        if (arr == null || arr.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<Boolean> lst = new ArrayList<Boolean>(arr.length);
        for (boolean b : arr) {
            lst.add(b);
        }
        return lst;
    }

    @NotNull
    public static List<Character> list(char[] arr) {
        if (arr == null || arr.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<Character> lst = new ArrayList<Character>(arr.length);
        for (char b : arr) {
            lst.add(Character.valueOf(b));
        }
        return lst;
    }

    @NotNull
    public static List<Byte> list(byte[] arr) {
        if (arr == null || arr.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<Byte> lst = new ArrayList<Byte>(arr.length);
        for (byte b : arr) {
            lst.add(b);
        }
        return lst;
    }

    @NotNull
    public static List<Short> list(short[] arr) {
        if (arr == null || arr.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<Short> lst = new ArrayList<Short>(arr.length);
        for (short b : arr) {
            lst.add(b);
        }
        return lst;
    }

    @NotNull
    public static List<Integer> list(int[] arr) {
        if (arr == null || arr.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<Integer> lst = new ArrayList<Integer>(arr.length);
        for (int b : arr) {
            lst.add(b);
        }
        return lst;
    }

    @NotNull
    public static List<Long> list(long[] arr) {
        if (arr == null || arr.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<Long> lst = new ArrayList<Long>(arr.length);
        for (long b : arr) {
            lst.add(b);
        }
        return lst;
    }

    @NotNull
    public static List<Float> list(float[] arr) {
        if (arr == null || arr.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<Float> lst = new ArrayList<Float>(arr.length);
        for (float b : arr) {
            lst.add(Float.valueOf(b));
        }
        return lst;
    }

    @NotNull
    public static List<Double> list(double[] arr) {
        if (arr == null || arr.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<Double> lst = new ArrayList<Double>(arr.length);
        for (double b : arr) {
            lst.add(b);
        }
        return lst;
    }

    @NotNull
    public static List<Object> list(Object obj) {
        if (obj == null) {
            return Collections.emptyList();
        }
        List<Object> vs = obj instanceof boolean[] ? BoxedCastUtil.list((boolean[])obj) : (obj instanceof byte[] ? BoxedCastUtil.list((byte[])obj) : (obj instanceof char[] ? BoxedCastUtil.list((char[])obj) : (obj instanceof int[] ? BoxedCastUtil.list((int[])obj) : (obj instanceof long[] ? BoxedCastUtil.list((long[])obj) : (obj instanceof float[] ? BoxedCastUtil.list((float[])obj) : (obj instanceof double[] ? BoxedCastUtil.list((double[])obj) : (obj instanceof Collection ? new ArrayList<Object>((Collection)obj) : (obj.getClass().isArray() ? Arrays.asList((Object[])obj) : Collections.singletonList(obj)))))))));
        return vs;
    }
}

