/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.mirana.code;

import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Supplier;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class SlotCode {
    private static final int[] mask = new int[32];
    private static final int full = -1;
    private static final int bits = 32;
    public final int size;
    private final int last;
    private final Slot[] slot;
    private final Random rand;

    public SlotCode(int size) {
        this(size, ThreadLocalRandom::current);
    }

    public SlotCode(int size, Supplier<Random> rand) {
        this(size, rand.get());
    }

    public SlotCode(int size, Random rand) {
        int page = (size - 1) / 32 + 1;
        this.size = size;
        this.last = (1 << 32 - size % 32) - 1;
        this.rand = rand;
        this.slot = new Slot[page];
        for (int i = 0; i < page; ++i) {
            this.slot[i] = new Slot();
        }
        this.slot[page - 1].value = this.last;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Slot[] slotArray = this.slot;
        synchronized (this.slot) {
            this.resetSlot();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public int next() {
        int rst = -1;
        while (true) {
            if (rst >= 0) {
                if (rst <= this.size) return rst;
            }
            Slot[] slotArray = this.slot;
            // MONITORENTER : this.slot
            int idx = this.select();
            // MONITOREXIT : slotArray
            rst = this.slot[idx].pickup(this.rand, idx);
        }
    }

    private int select() {
        int len = this.slot.length;
        int off = this.rand.nextInt(len);
        for (int i = 0; i < len; ++i) {
            int idx = (off + i) % len;
            if (this.slot[idx].value == -1) continue;
            return idx;
        }
        this.resetSlot();
        return off;
    }

    private void resetSlot() {
        int idx = this.slot.length - 1;
        for (int i = 0; i < idx; ++i) {
            this.slot[i].value = 0;
        }
        this.slot[idx].value = 0;
    }

    public static void main(String[] args) {
        int i;
        System.out.println(-1);
        System.out.println("--:" + Integer.toBinaryString(-1));
        System.out.println("===========");
        for (i = 0; i < mask.length; ++i) {
            System.out.println(String.format("%02d:%32s", i + 1, Integer.toBinaryString(mask[i])).replace(' ', '0'));
        }
        System.out.println("===========");
        for (i = 1; i <= 36; ++i) {
            SlotCode sc = new SlotCode(i);
            System.out.println(String.format("%02d:%32s", i, Integer.toBinaryString(sc.last)).replace(' ', '0'));
        }
    }

    static {
        for (int i = 0; i < mask.length; ++i) {
            SlotCode.mask[i] = 1 << 32 - i - 1;
        }
    }

    private static class Slot {
        private volatile int value = 0;

        private Slot() {
        }

        public synchronized int pickup(Random rand, int page) {
            int len = mask.length;
            int off = rand.nextInt(len);
            int cur = this.value;
            for (int i = 0; i < len; ++i) {
                int idx = (off + i) % len;
                int msk = mask[idx];
                if ((cur & msk) != 0) continue;
                this.value = cur | msk;
                return page * 32 + idx + 1;
            }
            return -1;
        }
    }
}

