/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.mirana.cond;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;

public class EqualsUtil {
    public static boolean eqVal(Number a, Number b) {
        BigDecimal y;
        if (a == null || b == null) {
            return false;
        }
        if (a instanceof Integer) {
            return a.intValue() == b.intValue();
        }
        if (a instanceof Long) {
            return a.longValue() == b.longValue();
        }
        if (a instanceof BigDecimal) {
            if (b instanceof BigDecimal) {
                return ((BigDecimal)a).compareTo((BigDecimal)b) == 0;
            }
            return ((BigDecimal)a).compareTo(new BigDecimal(b.toString())) == 0;
        }
        if (a instanceof Float) {
            return Float.compare(a.floatValue(), b.floatValue()) == 0;
        }
        if (a instanceof Double) {
            return Double.compare(a.doubleValue(), b.doubleValue()) == 0;
        }
        if (a instanceof Byte) {
            return a.byteValue() == b.byteValue();
        }
        if (a instanceof Short) {
            return a.shortValue() == b.shortValue();
        }
        if (a instanceof BigInteger) {
            if (b instanceof BigInteger) {
                return ((BigInteger)a).compareTo((BigInteger)b) == 0;
            }
            BigDecimal x = new BigDecimal((BigInteger)a);
            BigDecimal y2 = new BigDecimal(b.toString());
            return x.compareTo(y2) == 0;
        }
        BigDecimal x = new BigDecimal(a.toString());
        return x.compareTo(y = new BigDecimal(b.toString())) == 0;
    }

    public static boolean inVal(Number a, Number[] nums) {
        if (a == null || nums == null) {
            return false;
        }
        return EqualsUtil.inVal(a, Arrays.asList(nums));
    }

    public static boolean inVal(Number a, Number b, Number ... nums) {
        if (a == null || b == null || nums == null) {
            return false;
        }
        boolean e = EqualsUtil.eqVal(a, b);
        return e ? e : EqualsUtil.inVal(a, Arrays.asList(nums));
    }

    public static boolean inVal(Number a, Iterable<? extends Number> nums) {
        if (a == null || nums == null) {
            return false;
        }
        for (Number number : nums) {
            if (number == null || !EqualsUtil.eqVal(a, number)) continue;
            return true;
        }
        return false;
    }

    public static boolean inVal(Number a, int[] nums) {
        if (a == null || nums == null) {
            return false;
        }
        int v = a.intValue();
        for (int n : nums) {
            if (v != n) continue;
            return true;
        }
        return false;
    }

    public static boolean inVal(Number a, long[] nums) {
        if (a == null || nums == null) {
            return false;
        }
        long v = a.longValue();
        for (long n : nums) {
            if (v != n) continue;
            return true;
        }
        return false;
    }

    public static boolean inVal(Number a, float[] nums) {
        if (a == null || nums == null) {
            return false;
        }
        float v = a.floatValue();
        for (float n : nums) {
            if (Float.compare(v, n) != 0) continue;
            return true;
        }
        return false;
    }

    public static boolean inVal(Number a, double[] nums) {
        if (a == null || nums == null) {
            return false;
        }
        double v = a.doubleValue();
        for (double n : nums) {
            if (Double.compare(v, n) != 0) continue;
            return true;
        }
        return false;
    }

    public static boolean eqCase(String a, CharSequence b) {
        if (a == null || b == null) {
            return false;
        }
        return a.equals(b.toString());
    }

    public static boolean inCase(String a, CharSequence[] strs) {
        if (a == null || strs == null) {
            return false;
        }
        return EqualsUtil.inCase(a, Arrays.asList(strs));
    }

    public static boolean inCase(String a, CharSequence b, CharSequence ... strs) {
        if (a == null || b == null || strs == null) {
            return false;
        }
        boolean e = EqualsUtil.eqCase(a, b);
        return e ? e : EqualsUtil.inCase(a, Arrays.asList(strs));
    }

    public static boolean inCase(String a, Iterable<? extends CharSequence> strs) {
        if (a == null || strs == null) {
            return false;
        }
        for (CharSequence charSequence : strs) {
            if (charSequence == null || !a.equals(charSequence.toString())) continue;
            return true;
        }
        return false;
    }

    public static boolean eqCaseless(String a, CharSequence b) {
        if (a == null || b == null) {
            return false;
        }
        return a.equalsIgnoreCase(b.toString());
    }

    public static boolean inCaseless(String a, CharSequence[] strs) {
        if (a == null || strs == null) {
            return false;
        }
        return EqualsUtil.inCaseless(a, Arrays.asList(strs));
    }

    public static boolean inCaseless(String a, CharSequence b, CharSequence ... strs) {
        if (a == null || b == null || strs == null) {
            return false;
        }
        boolean e = EqualsUtil.eqCaseless(a, b);
        return e ? e : EqualsUtil.inCaseless(a, Arrays.asList(strs));
    }

    public static boolean inCaseless(String a, Iterable<? extends CharSequence> strs) {
        if (a == null || strs == null) {
            return false;
        }
        for (CharSequence charSequence : strs) {
            if (charSequence == null || !a.equalsIgnoreCase(charSequence.toString())) continue;
            return true;
        }
        return false;
    }
}

