/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.mirana.data;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Diff {
    @NotNull
    public static <K> LinkedHashMap<K, V<Object>> of(@Nullable Map<? extends K, ?> map1, @Nullable Map<? extends K, ?> map2) {
        if (map1 == null) {
            map1 = Collections.emptyMap();
        }
        if (map2 == null) {
            map2 = Collections.emptyMap();
        }
        LinkedHashMap result = new LinkedHashMap();
        for (Map.Entry<Object, Object> en : map1.entrySet()) {
            V v = new V();
            v.v1 = en.getValue();
            result.put(en.getKey(), v);
        }
        for (Map.Entry<Object, Object> en : map2.entrySet()) {
            Object k = en.getKey();
            V vs = (V)result.get(k);
            if (vs == null) {
                V v = new V();
                v.v2 = en.getValue();
                result.put(k, v);
                continue;
            }
            Object v2 = en.getValue();
            if (Objects.equals(vs.v1, v2)) continue;
            vs.v2 = v2;
        }
        return result;
    }

    @NotNull
    public static <E> S<E> of(@Nullable Collection<? extends E> setA, @Nullable Collection<? extends E> setB) {
        boolean hasA = Diff.has(setA);
        boolean hasB = Diff.has(setB);
        S d = new S();
        if (hasA && hasB) {
            LinkedHashSet<E> tb = new LinkedHashSet<E>(setB);
            for (E a : setA) {
                if (tb.remove(a)) {
                    d.aAndB.add(a);
                    continue;
                }
                d.aNotB.add(a);
            }
            d.bNotA.addAll(tb);
        } else {
            if (hasA) {
                d.aNotB.addAll(setA);
            }
            if (hasB) {
                d.bNotA.addAll(setB);
            }
        }
        return d;
    }

    @NotNull
    public static <E, K> D<E> of(@Nullable Collection<? extends E> setNew, @Nullable Collection<? extends E> setOld, @NotNull Function<E, K> getPk) {
        return Diff.of(setNew, setOld, getPk, Object::equals);
    }

    @NotNull
    public static <E, K> D<E> of(@Nullable Collection<? extends E> setNew, @Nullable Collection<? extends E> setOld, @NotNull Function<E, K> getPk, @NotNull BiPredicate<E, E> same) {
        boolean hasA = Diff.has(setNew);
        boolean hasB = Diff.has(setOld);
        D d = new D();
        if (hasA && hasB) {
            LinkedHashMap<K, E> tb = new LinkedHashMap<K, E>(setOld.size());
            for (E b : setOld) {
                tb.put(getPk.apply(b), b);
            }
            for (E a : setNew) {
                K k = getPk.apply(a);
                if (k == null) {
                    d.newInsert.add(a);
                    continue;
                }
                Object b = tb.remove(k);
                if (b == null) {
                    d.newInsert.add(a);
                    continue;
                }
                if (same.test(a, b)) {
                    d.oldEqsNew.add(a);
                    continue;
                }
                d.newUpdate.add(a);
                d.oldUpdate.add(b);
            }
            d.oldDelete.addAll(tb.values());
        } else {
            if (hasA) {
                d.newInsert.addAll(setNew);
            }
            if (hasB) {
                d.oldDelete.addAll(setOld);
            }
        }
        return d;
    }

    private static boolean has(Collection<?> s) {
        return s != null && !s.isEmpty();
    }

    public static class D<E> {
        public final LinkedHashSet<E> newInsert = new LinkedHashSet();
        public final LinkedHashSet<E> newUpdate = new LinkedHashSet();
        public final LinkedHashSet<E> oldUpdate = new LinkedHashSet();
        public final LinkedHashSet<E> oldDelete = new LinkedHashSet();
        public final LinkedHashSet<E> oldEqsNew = new LinkedHashSet();
    }

    public static class S<E> {
        public final LinkedHashSet<E> aNotB = new LinkedHashSet();
        public final LinkedHashSet<E> bNotA = new LinkedHashSet();
        public final LinkedHashSet<E> aAndB = new LinkedHashSet();
    }

    public static class V<E> {
        private E v1;
        private E v2;

        public V() {
        }

        public V(E v1, E v2) {
            this.v1 = v1;
            this.v2 = v2;
        }

        public E getV1() {
            return this.v1;
        }

        public void setV1(E v1) {
            this.v1 = v1;
        }

        public E getV2() {
            return this.v2;
        }

        public void setV2(E v2) {
            this.v2 = v2;
        }

        public String toString() {
            return "v1=" + this.v1 + ",v2=" + this.v2;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof V)) {
                return false;
            }
            V v = (V)o;
            return Objects.equals(this.v1, v.v1) && Objects.equals(this.v2, v.v2);
        }

        public int hashCode() {
            return Objects.hash(this.v1, this.v2);
        }

        public boolean onlyV1() {
            return this.v1 != null && this.v2 == null;
        }

        public boolean onlyV2() {
            return this.v1 == null && this.v2 != null;
        }

        public boolean v1EqV2() {
            return Objects.equals(this.v1, this.v2);
        }

        public static <T> V<T> of(T t1, T t2) {
            return new V<T>(t1, t2);
        }

        public static <K, T> void diff(Map<K, V<?>> map, K key, T t1, T t2) {
            if (!Objects.equals(t1, t2)) {
                map.put(key, new V<T>(t1, t2));
            }
        }
    }
}

