/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.mirana.data;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pro.fessional.mirana.best.DummyBlock;

public interface Z {
    @SafeVarargs
    @NotNull
    public static <T> List<T> uniq(Collection<? extends T> ts, Function<? super T, ?> ... fn) {
        if (ts == null) {
            return Collections.emptyList();
        }
        if (fn == null || fn.length == 0) {
            if (ts instanceof List) {
                return (List)ts;
            }
            return new ArrayList<T>(ts);
        }
        HashMap map = new HashMap();
        ArrayList<T> result = new ArrayList<T>(ts.size());
        for (T t : ts) {
            ArrayList ks = new ArrayList(fn.length);
            for (Function<T, ?> function : fn) {
                ks.add(function.apply(t));
            }
            Boolean o = map.putIfAbsent(ks, Boolean.TRUE);
            if (o != null) continue;
            result.add(t);
        }
        return result;
    }

    @SafeVarargs
    @Nullable
    public static <T> T find(Predicate<T> p, T ... ts) {
        if (ts == null) {
            return null;
        }
        return Z.find(p, Arrays.asList(ts));
    }

    @Nullable
    public static <T> T find(Predicate<T> p, Iterable<? extends T> ts) {
        if (ts == null) {
            return null;
        }
        for (T t : ts) {
            if (t == null || !p.test(t)) continue;
            return t;
        }
        return null;
    }

    @SafeVarargs
    @Nullable
    public static <T, R> R make(Function<T, R> f, T ... ts) {
        return Z.makeSafe(null, f, ts);
    }

    @Nullable
    public static <T, R> R make(Function<T, R> f, Iterable<? extends T> ts) {
        return Z.makeSafe(null, f, ts);
    }

    @SafeVarargs
    @Contract(value="!null,_,_ ->!null")
    public static <T, R> R makeSafe(R d, Function<T, R> f, T ... ts) {
        if (ts == null) {
            return d;
        }
        return Z.makeSafe(d, f, Arrays.asList(ts));
    }

    @Contract(value="!null,_,_ ->!null")
    public static <T, R> R makeSafe(R d, Function<T, R> f, Iterable<? extends T> ts) {
        if (ts == null) {
            return d;
        }
        for (T t : ts) {
            if (t == null) continue;
            try {
                R r = f.apply(t);
                if (r == null) continue;
                return r;
            }
            catch (Exception e) {
                DummyBlock.ignore(e);
            }
        }
        return d;
    }

    @Nullable
    public static BigDecimal decimal(CharSequence ... ts) {
        return Z.decimalSafe(null, ts);
    }

    @Nullable
    public static BigDecimal decimal(Iterable<? extends CharSequence> ts) {
        return Z.decimalSafe(null, ts);
    }

    @Contract(value="!null,_ ->!null")
    public static BigDecimal decimalSafe(BigDecimal d, CharSequence ... ts) {
        if (ts == null) {
            return d;
        }
        return Z.decimalSafe(d, Arrays.asList(ts));
    }

    @Contract(value="!null,_ ->!null")
    public static BigDecimal decimalSafe(BigDecimal d, Iterable<? extends CharSequence> ts) {
        if (ts == null) {
            return d;
        }
        for (CharSequence charSequence : ts) {
            String s;
            if (charSequence == null || charSequence.length() <= 0 || (s = charSequence.toString().trim()).length() <= 0) continue;
            try {
                return new BigDecimal(s);
            }
            catch (Exception e) {
                DummyBlock.ignore(e);
            }
        }
        return d;
    }

    @Nullable
    public static Long int64(CharSequence ... ts) {
        return Z.int64Safe(null, ts);
    }

    @Nullable
    public static Long int64(Iterable<? extends CharSequence> ts) {
        return Z.int64Safe(null, ts);
    }

    @Contract(value="!null,_ ->!null")
    public static Long int64Safe(Long d, CharSequence ... ts) {
        if (ts == null) {
            return d;
        }
        return Z.int64Safe(d, Arrays.asList(ts));
    }

    @Contract(value="!null,_ ->!null")
    public static Long int64Safe(Long d, Iterable<? extends CharSequence> ts) {
        if (ts == null) {
            return d;
        }
        for (CharSequence charSequence : ts) {
            String s;
            if (charSequence == null || charSequence.length() <= 0 || (s = charSequence.toString().trim()).length() <= 0) continue;
            try {
                return Long.valueOf(s);
            }
            catch (Exception e) {
                DummyBlock.ignore(e);
            }
        }
        return d;
    }

    @Nullable
    public static Integer int32(CharSequence ... ts) {
        return Z.int32Safe(null, ts);
    }

    @Nullable
    public static Integer int32(Iterable<? extends CharSequence> ts) {
        return Z.int32Safe(null, ts);
    }

    @Contract(value="!null,_ ->!null")
    public static Integer int32Safe(Integer d, CharSequence ... ts) {
        if (ts == null) {
            return d;
        }
        return Z.int32Safe(d, Arrays.asList(ts));
    }

    @Contract(value="!null,_ ->!null")
    public static Integer int32Safe(Integer d, Iterable<? extends CharSequence> ts) {
        if (ts == null) {
            return d;
        }
        for (CharSequence charSequence : ts) {
            String s;
            if (charSequence == null || charSequence.length() <= 0 || (s = charSequence.toString().trim()).length() <= 0) continue;
            try {
                return Integer.valueOf(s);
            }
            catch (Exception e) {
                DummyBlock.ignore(e);
            }
        }
        return d;
    }

    @SafeVarargs
    @Nullable
    public static <T> T notNull(T ... ts) {
        return Z.notNullSafe(null, ts);
    }

    @Nullable
    public static <T> T notNull(Iterable<? extends T> ts) {
        return Z.notNullSafe(null, ts);
    }

    @Contract(value="!null,_ ->!null")
    public static <T> T notNullSafe(T d, T t) {
        return t == null ? d : t;
    }

    @SafeVarargs
    @Contract(value="!null,_ ->!null")
    public static <T> T notNullSafe(T d, T ... ts) {
        return Z.notNullSafe(d, Arrays.asList(ts));
    }

    @Contract(value="!null,_ ->!null")
    public static <T> T notNullSafe(T d, Iterable<? extends T> ts) {
        if (ts == null) {
            return d;
        }
        for (T t : ts) {
            if (t == null) continue;
            return t;
        }
        return d;
    }

    @Contract(value="!null,_ ->!null")
    public static <T> T notNullSafe(Supplier<T> d, T t) {
        return t == null ? d.get() : t;
    }

    @SafeVarargs
    @Contract(value="!null,_ ->!null")
    public static <T> T notNullSafe(Supplier<T> d, T ... ts) {
        return Z.notNullSafe(d, Arrays.asList(ts));
    }

    @Contract(value="!null,_ ->!null")
    public static <T> T notNullSafe(Supplier<T> d, Iterable<? extends T> ts) {
        if (ts == null) {
            return d.get();
        }
        for (T t : ts) {
            if (t == null) continue;
            return t;
        }
        return d.get();
    }

    @SafeVarargs
    @Nullable
    public static <T extends CharSequence> T notEmpty(T ... ts) {
        return (T)Z.notEmptySafe(null, ts);
    }

    @Nullable
    public static <T extends CharSequence> T notEmpty(Iterable<? extends T> ts) {
        return Z.notEmptySafe(null, ts);
    }

    @SafeVarargs
    @Contract(value="!null,_ ->!null")
    public static <T extends CharSequence> T notEmptySafe(T d, T ... ts) {
        if (ts == null) {
            return d;
        }
        return Z.notEmptySafe(d, Arrays.asList(ts));
    }

    @Contract(value="!null,_ ->!null")
    public static <T extends CharSequence> T notEmptySafe(T d, Iterable<? extends T> ts) {
        if (ts == null) {
            return d;
        }
        for (CharSequence t : ts) {
            if (t == null || t.length() <= 0) continue;
            return (T)t;
        }
        return d;
    }

    @Nullable
    public static String notBlank(CharSequence ... ts) {
        return Z.notBlankSafe(null, ts);
    }

    @Nullable
    public static String notBlank(Iterable<? extends CharSequence> ts) {
        return Z.notBlankSafe(null, ts);
    }

    @Contract(value="!null,_ ->!null")
    public static String notBlankSafe(String d, CharSequence ... ts) {
        if (ts == null) {
            return d;
        }
        return Z.notBlankSafe(d, Arrays.asList(ts));
    }

    @Contract(value="!null,_ ->!null")
    public static String notBlankSafe(String d, Iterable<? extends CharSequence> ts) {
        if (ts == null) {
            return d;
        }
        for (CharSequence charSequence : ts) {
            String s;
            if (charSequence == null || charSequence.length() <= 0 || (s = charSequence.toString().trim()).length() <= 0) continue;
            return s;
        }
        return d;
    }
}

