/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.mirana.evil;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.jetbrains.annotations.NotNull;
import pro.fessional.mirana.evil.ThreadLocalAttention;

public class ThreadLocalProxy<T>
extends ThreadLocal<T> {
    private volatile ThreadLocal<T> backend;

    public static void tryClear(ThreadLocal<?> threadLocal) throws ThreadLocalAttention {
        if (threadLocal == null) {
            return;
        }
        try {
            Thread[] threads;
            ThreadGroup systemGroup = Thread.currentThread().getThreadGroup();
            while (systemGroup.getParent() != null) {
                systemGroup = systemGroup.getParent();
            }
            int count = systemGroup.activeCount();
            while ((count = systemGroup.enumerate(threads = new Thread[count + count / 2 + 1], true)) >= threads.length) {
            }
            Field threadLocalsField = Thread.class.getDeclaredField("threadLocals");
            threadLocalsField.setAccessible(true);
            Class<?> threadLocalMapClass = Class.forName("java.lang.ThreadLocal$ThreadLocalMap");
            Method removeMethod = threadLocalMapClass.getDeclaredMethod("remove", ThreadLocal.class);
            removeMethod.setAccessible(true);
            for (int i = 0; i < count; ++i) {
                Object threadLocalMap = threadLocalsField.get(threads[i]);
                if (threadLocalMap == null) continue;
                removeMethod.invoke(threadLocalMap, threadLocal);
            }
        }
        catch (ReflectiveOperationException e) {
            throw new ThreadLocalAttention(e);
        }
    }

    public ThreadLocalProxy() {
        this.backend = new ThreadLocal();
    }

    public ThreadLocalProxy(@NotNull ThreadLocal<T> tl) {
        this.backend = tl;
    }

    @NotNull
    public ThreadLocal<T> getBackend() {
        return this.backend;
    }

    @NotNull
    public ThreadLocal<T> replaceBackend(@NotNull ThreadLocal<T> threadLocal, boolean tryToCleanOld) throws ThreadLocalAttention {
        ThreadLocal<T> old = this.backend;
        this.backend = threadLocal;
        if (tryToCleanOld) {
            ThreadLocalProxy.tryClear(old);
        }
        return old;
    }

    @Override
    public T get() {
        return this.backend.get();
    }

    @Override
    public void set(T value) {
        this.backend.set(value);
    }

    @Override
    public void remove() {
        this.backend.remove();
    }
}

