/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.mirana.i18n;

import java.beans.Transient;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pro.fessional.mirana.i18n.I18nAware;

public class I18nString
implements I18nAware {
    private static final long serialVersionUID = 19791023L;
    private static final Object[] EMPTY_ARGS = new Object[0];
    private final String code;
    private final Object[] args;
    private final String hint;
    private transient String i18n = null;

    public I18nString(String code) {
        this(code, "", EMPTY_ARGS);
    }

    public I18nString(String code, String hint) {
        this(code, hint, EMPTY_ARGS);
    }

    public I18nString(String code, String hint, Object ... args) {
        this.code = code == null ? "" : code;
        this.args = args == null ? EMPTY_ARGS : args;
        this.hint = hint == null ? "" : hint;
    }

    @NotNull
    public String getCode() {
        return this.code;
    }

    @NotNull
    public Object[] getArgs() {
        return this.args;
    }

    @NotNull
    public String getHint() {
        return this.hint;
    }

    @Nullable
    public String getI18n() {
        return this.i18n;
    }

    @Contract(value="_ -> this")
    public I18nString setI18n(String i18n) {
        this.i18n = i18n;
        return this;
    }

    @NotNull
    public String toString(Locale locale) {
        String r = this.hint;
        if (this.args.length > 0 && locale != null) {
            r = new MessageFormat(this.hint, locale).format(this.args);
        }
        return r == null ? this.code : r;
    }

    public boolean isEmpty() {
        return this.code.isEmpty();
    }

    @Override
    @Transient
    @NotNull
    public String getI18nCode() {
        return this.code;
    }

    @Override
    @Transient
    @NotNull
    public Object[] getI18nArgs() {
        return this.args;
    }

    @Override
    @Transient
    @NotNull
    public String getI18nHint() {
        return this.hint;
    }

    public String toString() {
        if (this.i18n != null && this.i18n.length() > 0) {
            return this.i18n;
        }
        if (this.hint != null && this.hint.length() > 0) {
            return this.hint;
        }
        return this.code;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof I18nString)) {
            return false;
        }
        I18nString that = (I18nString)o;
        return Objects.equals(this.code, that.code) && Arrays.equals(this.args, that.args);
    }

    public int hashCode() {
        int result = Objects.hash(this.code);
        result = 31 * result + Arrays.hashCode(this.args);
        return result;
    }
}

