/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.mirana.id;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pro.fessional.mirana.id.LightId;

public class LightIdUtil {
    private static boolean BLOCK_FIRST = true;
    private static int BIT_BLOCK = 9;
    private static int MAX_BLOCK = 512;
    private static int BIT_SEQUENCE = 45;
    private static long MAX_SEQUENCE = 0x1FFFFFFFFFFFL;

    public static void forceBlockBit(int count) {
        if (count < 3) {
            throw new IllegalArgumentException("not enough block, count should more than 3");
        }
        if (count > 23) {
            throw new IllegalArgumentException("not enough sequence, count should less than 23");
        }
        BIT_BLOCK = count;
        MAX_BLOCK = 1 << BIT_BLOCK;
        BIT_SEQUENCE = 54 - BIT_BLOCK;
        MAX_SEQUENCE = (1L << BIT_SEQUENCE) - 1L;
    }

    public static void forceBlockFirst(boolean b) {
        BLOCK_FIRST = b;
    }

    public static boolean isBlockFirst() {
        return BLOCK_FIRST;
    }

    public static int getBlockBit() {
        return BIT_BLOCK;
    }

    public static int getBlockMax() {
        return MAX_BLOCK;
    }

    public static int getSequenceBit() {
        return BIT_SEQUENCE;
    }

    public static long getSequenceMax() {
        return MAX_SEQUENCE;
    }

    public static boolean valid(@Nullable LightId id) {
        return id != null && LightIdUtil.valid(id.getBlock(), id.getSequence());
    }

    public static boolean valid(@Nullable Integer block, @Nullable Long sequence) {
        return block != null && sequence != null && LightIdUtil.valid((int)block, (long)sequence);
    }

    public static boolean valid(int block, long sequence) {
        if (block < 0 || block > MAX_BLOCK) {
            return false;
        }
        if (block == 0) {
            return sequence >= 0L && sequence <= 0x3FFFFFFFFFFFFFL;
        }
        return sequence >= 0L && sequence <= MAX_SEQUENCE;
    }

    public static LightId toLightId(@Nullable Long lightId) {
        if (lightId == null) {
            return LightId.NONE;
        }
        return LightIdUtil.toLightId((long)lightId);
    }

    @NotNull
    public static LightId toLightId(long lightId) {
        long sequence;
        int block;
        if ((lightId & 0x40000000000000L) == 0L) {
            block = 0;
            sequence = lightId & 0x3FFFFFFFFFFFFFL;
        } else {
            int mask = MAX_BLOCK - 1;
            if (BLOCK_FIRST) {
                block = (int)(lightId >> BIT_SEQUENCE & (long)mask) + 1;
                sequence = lightId & MAX_SEQUENCE;
            } else {
                block = (int)(lightId & (long)mask) + 1;
                sequence = lightId >> BIT_BLOCK & MAX_SEQUENCE;
            }
        }
        if (LightIdUtil.valid(block, sequence)) {
            return new LightId(block, sequence);
        }
        return LightId.NONE;
    }

    public static long toId(int block, long sequence) {
        if (block <= 0) {
            return sequence;
        }
        long id = BLOCK_FIRST ? (long)block - 1L << BIT_SEQUENCE | sequence : sequence << BIT_BLOCK | (long)(block - 1);
        return id | 0x40000000000000L;
    }

    public static boolean isNone(@Nullable LightId id) {
        if (id == null) {
            return true;
        }
        return id.getBlock() < 0 || id.getSequence() < 0L;
    }

    public static boolean isZero(@Nullable LightId id) {
        if (id == null) {
            return true;
        }
        return id.getBlock() == 0 && id.getSequence() == 0L;
    }

    public static boolean isZeroSequence(@Nullable LightId id) {
        if (id == null) {
            return true;
        }
        return id.getSequence() == 0L;
    }

    public static long sequenceOrElse(@Nullable LightId lightId, long elze) {
        if (lightId == null) {
            return elze;
        }
        long sequence = lightId.getSequence();
        return LightIdUtil.valid(lightId.getBlock(), sequence) ? sequence : elze;
    }

    public static long sequenceLong(long lightId) {
        return lightId & 0x3FFFFFFFFFFFFFL;
    }

    public static int sequenceInt(long lightId) {
        return (int)(lightId & Integer.MAX_VALUE);
    }
}

