/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.mirana.page;

import java.io.Serializable;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import pro.fessional.mirana.page.PageUtil;

public class PageQuery
implements Serializable {
    private static final long serialVersionUID = 19791023L;
    protected int page = 1;
    protected int size = 1;
    protected String sort = "";

    public PageQuery() {
    }

    public PageQuery(int page, int size) {
        this.page = page;
        this.size = size;
    }

    public PageQuery(int page, int size, String sort) {
        this.page = page;
        this.size = size;
        this.sort = sort == null ? "" : sort;
    }

    public int getPage() {
        return this.page;
    }

    @Contract(value="_->this")
    public PageQuery setPage(int page) {
        this.page = Math.max(page, 1);
        return this;
    }

    public int getSize() {
        return this.size;
    }

    @Contract(value="_->this")
    public PageQuery setSize(int size) {
        this.size = Math.max(size, 1);
        return this;
    }

    @NotNull
    public String getSort() {
        return this.sort;
    }

    @Contract(value="_->this")
    public PageQuery setSort(String sort) {
        this.sort = sort == null ? "" : sort;
        return this;
    }

    public int toOffset() {
        return PageUtil.dataIndex(this.page, this.size);
    }

    public String toString() {
        return "PageQuery{page=" + this.page + ", size=" + this.size + ", sort='" + this.sort + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PageQuery pageQuery = (PageQuery)o;
        return this.page == pageQuery.page && this.size == pageQuery.size && this.sort.equals(pageQuery.sort);
    }

    public int hashCode() {
        return Objects.hash(this.page, this.size, this.sort);
    }
}

