/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.mirana.page;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import pro.fessional.mirana.text.WhiteUtil;

public class PageUtil {
    public static final char SORT_DESC = '-';
    public static final char SORT_DELI = ',';

    public static int dataIndex(int pageNumber, int pageSize) {
        if (pageNumber <= 1) {
            return 0;
        }
        if (pageSize <= 1) {
            return pageNumber - 1;
        }
        return pageNumber * pageSize - pageSize;
    }

    public static int totalPage(int totalData, int pageSize) {
        if (totalData <= 0) {
            return 0;
        }
        if (pageSize <= 1) {
            return totalData;
        }
        return (totalData - 1) / pageSize + 1;
    }

    @NotNull
    public static Sb sortBy() {
        return new Sb(new StringBuilder(32));
    }

    @NotNull
    public static List<By> sort(String sort) {
        By st;
        if (sort == null || sort.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<By> bies = new ArrayList<By>(4);
        StringBuilder buf = new StringBuilder(16);
        int len = sort.length();
        for (int i = 0; i < len; ++i) {
            char c = sort.charAt(i);
            if (c == ',') {
                By st2 = By.of(buf);
                if (st2 != null) {
                    bies.add(st2);
                }
                buf.setLength(0);
                continue;
            }
            if (!WhiteUtil.notWhiteSpace(c)) continue;
            buf.append(c);
        }
        if (buf.length() > 0 && (st = By.of(buf)) != null) {
            bies.add(st);
        }
        return bies;
    }

    public static <E> int paginate(List<E> data, int pageSize, BiConsumer<Integer, List<E>> consumer) {
        if (data == null || data.isEmpty()) {
            return 0;
        }
        if (pageSize < 1) {
            pageSize = 1;
        }
        int total = data.size();
        int count = 0;
        if (total <= pageSize) {
            consumer.accept(++count, data);
            return count;
        }
        int i = 0;
        while (i < total) {
            consumer.accept(++count, data.subList(i, Math.min(i += pageSize, total)));
        }
        return count;
    }

    @NotNull
    public static <E> List<List<E>> paginate(List<E> data, int pageSize) {
        int total;
        if (data == null || data.isEmpty()) {
            return Collections.emptyList();
        }
        if (pageSize < 1) {
            pageSize = 1;
        }
        if ((total = data.size()) <= pageSize) {
            return Collections.singletonList(data);
        }
        int count = PageUtil.totalPage(total, pageSize);
        ArrayList<List<List<E>>> result = new ArrayList<List<List<E>>>(count);
        int i = 0;
        while (i < total) {
            result.add(data.subList(i, Math.min(i += pageSize, total)));
        }
        return result;
    }

    public static class By {
        public final String key;
        public final boolean asc;

        private By(String key, boolean asc) {
            this.key = key;
            this.asc = asc;
        }

        public static By of(StringBuilder key) {
            if (key == null) {
                return null;
            }
            int len = key.length();
            if (len > 0) {
                if (key.charAt(0) == '-') {
                    if (len > 1) {
                        return new By(key.substring(1), false);
                    }
                    return null;
                }
                return new By(key.toString(), true);
            }
            return null;
        }

        public static By of(String key, boolean asc) {
            if (key == null || key.isEmpty()) {
                return null;
            }
            return new By(key, asc);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            By by = (By)o;
            return this.asc == by.asc && this.key.equals(by.key);
        }

        public int hashCode() {
            return Objects.hash(this.key, this.asc);
        }
    }

    public static class Sb {
        private final StringBuilder buf;

        public Sb(StringBuilder sb) {
            this.buf = sb == null ? new StringBuilder() : sb;
        }

        @Contract(value="_,_->this")
        public Sb by(String key, boolean asc) {
            if (key != null && key.length() > 0) {
                this.buf.append(',');
                if (!asc) {
                    this.buf.append('-');
                }
                this.buf.append(key);
            }
            return this;
        }

        @Contract(value="_->this")
        public Sb by(By by) {
            if (by != null) {
                this.by(by.key, by.asc);
            }
            return this;
        }

        @Contract(value="_->this")
        public Sb by(Iterable<By> sort) {
            if (sort != null) {
                for (By st : sort) {
                    this.by(st);
                }
            }
            return this;
        }

        @NotNull
        public String build() {
            return this.buf.length() > 0 ? this.buf.substring(1) : this.buf.toString();
        }

        public String toString() {
            return this.build();
        }
    }
}

