/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.mirana.text;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.LinkedList;
import org.jetbrains.annotations.NotNull;

public class BarString {
    public static final char SingleBar = '|';
    public static final char BrokenBar = '\u00a6';
    public static final char FullwidthBar = '\uff5c';
    public static final char DentalBar = '\u01c0';
    public static final char DividesBar = '\u2223';
    public static final char DrawingBar = '\u2502';
    public static final char DandaBar = '\u0964';
    public static final char DoubleBar = '\u2016';
    public static final char ParallelBar = '\u2225';
    public static final char LateralBar = '\u01c1';
    public static final char DoubleDandaBar = '\u0965';
    private static final char[] Bars = new char[]{'|', '\u00a6', '\uff5c', '\u01c0', '\u2223', '\u2502', '\u0964', '\u2016', '\u2225', '\u01c1', '\u0965'};
    private int index = 0;
    private boolean valid = true;
    private int count = 0;
    private final LinkedList<Ent> values = new LinkedList();
    private final boolean[] exists = new boolean[Bars.length];

    private void appendKey() {
        this.values.add(Ent.Bar);
    }

    private void appendValue(@NotNull String str, boolean check) {
        this.count += str.length();
        this.values.add(new Ent(str, check));
        if (check && this.valid && str.indexOf(Bars[this.index]) >= 0) {
            this.exists[this.index] = true;
            boolean vd = false;
            for (int i = 0; i < this.exists.length; ++i) {
                if (this.exists[i]) continue;
                for (Ent o : this.values) {
                    if (o == Ent.Bar || !o.check || o.value.indexOf(Bars[i]) < 0) continue;
                    this.exists[i] = true;
                    break;
                }
                if (this.exists[i]) continue;
                this.index = i;
                vd = true;
                break;
            }
            this.valid = vd;
        }
    }

    public void append(Object obj) {
        this.appendKey();
        if (obj != null) {
            this.appendValue(obj.toString(), true);
        }
    }

    public void append(BigDecimal num) {
        this.appendKey();
        if (num != null) {
            this.appendValue(num.toPlainString(), false);
        }
    }

    public void append(long num) {
        this.appendKey();
        this.appendValue(String.valueOf(num), false);
    }

    public void append(int num) {
        this.appendKey();
        this.appendValue(String.valueOf(num), false);
    }

    public void append(char num) {
        this.appendKey();
        this.appendValue(String.valueOf(num), true);
    }

    public void append(boolean num) {
        this.appendKey();
        this.appendValue(String.valueOf(num), false);
    }

    public void append(double num) {
        this.appendKey();
        this.appendValue(String.valueOf(num), false);
    }

    public void append(float num) {
        this.appendKey();
        this.appendValue(String.valueOf(num), false);
    }

    public boolean isValid() {
        return this.valid;
    }

    public String toString() {
        if (this.values.isEmpty()) {
            return "";
        }
        char bar = Bars[this.index];
        StringBuilder buff = new StringBuilder(this.count + this.values.size());
        for (Ent v : this.values) {
            if (v == Ent.Bar) {
                buff.append(bar);
                continue;
            }
            buff.append(v.value);
        }
        buff.append(bar);
        return buff.toString();
    }

    @NotNull
    public static ArrayList<String> split(String str) {
        return BarString.split(str, -1, false);
    }

    @NotNull
    public static ArrayList<String> split(String str, int max) {
        return BarString.split(str, max, false);
    }

    @NotNull
    public static ArrayList<String> split(String str, int max, boolean exactly) {
        ArrayList<String> list = new ArrayList<String>(max > 0 ? max : 8);
        if (str == null || max == 0) {
            return list;
        }
        int len = str.length();
        if (len <= 1) {
            return list;
        }
        char bar = str.charAt(0);
        if (bar != str.charAt(len - 1)) {
            if (exactly && max != 1) {
                list.add(str);
            }
            return list;
        }
        int off = 1;
        int pls = 1;
        int cur = str.indexOf(bar, off);
        while (cur >= off) {
            if (pls == max) {
                list.add(str.substring(off, len - 1));
                break;
            }
            ++pls;
            list.add(str.substring(off, cur));
            off = cur + 1;
            cur = str.indexOf(bar, off);
        }
        if (exactly && max != list.size()) {
            list.clear();
        }
        return list;
    }

    private static class Ent {
        public static final Ent Bar = new Ent("", false);
        @NotNull
        private final String value;
        private final boolean check;

        public Ent(@NotNull String value, boolean check) {
            this.value = value;
            this.check = check;
        }
    }
}

