/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.mirana.time;

import java.time.DayOfWeek;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import pro.fessional.mirana.time.ThreadNow;

public class DateLocaling {
    public static LocalDateTime utcLdt(long epochMilli) {
        return DateLocaling.useLdt(epochMilli, ThreadNow.utcZoneId());
    }

    public static LocalDateTime sysLdt(long epochMilli) {
        return DateLocaling.useLdt(epochMilli, ThreadNow.sysZoneId());
    }

    public static LocalDateTime useLdt(long epochMilli, ZoneId zone) {
        Instant ins = Instant.ofEpochMilli(epochMilli);
        return LocalDateTime.ofInstant(ins, zone);
    }

    public static long utcEpoch(LocalDateTime ldt) {
        return DateLocaling.useEpoch(ldt, ThreadNow.utcZoneId());
    }

    public static long sysEpoch(LocalDateTime ldt) {
        return DateLocaling.useEpoch(ldt, ThreadNow.sysZoneId());
    }

    public static long useEpoch(LocalDateTime ldt, ZoneId zone) {
        return ZonedDateTime.of(ldt, zone).toInstant().toEpochMilli();
    }

    public static LocalDateTime dateTime(ZoneId at) {
        return ZonedDateTime.now(at).toLocalDateTime();
    }

    public static LocalDate date(ZoneId at) {
        return ZonedDateTime.now(at).toLocalDate();
    }

    public static LocalTime time(ZoneId at) {
        return ZonedDateTime.now(at).toLocalTime();
    }

    public static LocalDateTime today(ZoneId at) {
        return ZonedDateTime.now(at).toLocalDate().atStartOfDay();
    }

    public static LocalDateTime month(ZoneId at) {
        return ZonedDateTime.now(at).toLocalDate().withDayOfMonth(1).atStartOfDay();
    }

    public static LocalDateTime monday(ZoneId at) {
        return DateLocaling.week(at, DayOfWeek.MONDAY);
    }

    public static LocalDateTime sunday(ZoneId at) {
        return DateLocaling.week(at, DayOfWeek.SUNDAY);
    }

    public static LocalDateTime week(ZoneId at, DayOfWeek day) {
        LocalDateTime ldt = ZonedDateTime.now(at).toLocalDate().atStartOfDay();
        int v = ldt.getDayOfWeek().getValue();
        int m = day.getValue();
        if (m > v) {
            return ldt.plusDays(m - v - 7);
        }
        if (m < v) {
            return ldt.plusDays(m - v);
        }
        return ldt;
    }

    public static ZonedDateTime sysZdt(LocalDateTime ldt) {
        if (ldt == null) {
            return null;
        }
        return ldt.atZone(ThreadNow.sysZoneId());
    }

    public static LocalDateTime sysLdt(ZonedDateTime zdt) {
        return DateLocaling.local(zdt, ThreadNow.sysZoneId());
    }

    public static ZonedDateTime sysZdt(ZonedDateTime zdt) {
        return DateLocaling.zoned(zdt, ThreadNow.sysZoneId());
    }

    public static LocalDateTime sysLdt(ZoneId viewer, LocalDateTime ldt) {
        return DateLocaling.local(viewer, ldt, ThreadNow.sysZoneId());
    }

    public static ZonedDateTime sysZdt(ZoneId viewer, LocalDateTime ldt) {
        return DateLocaling.zoned(viewer, ldt, ThreadNow.sysZoneId());
    }

    public static LocalDateTime useLdt(ZonedDateTime zdt, ZoneId viewer) {
        return DateLocaling.local(zdt, viewer);
    }

    public static ZonedDateTime useZdt(ZonedDateTime zdt, ZoneId viewer) {
        return DateLocaling.zoned(zdt, viewer);
    }

    public static LocalDateTime useLdt(LocalDateTime ldt, ZoneId viewer) {
        return DateLocaling.local(ThreadNow.sysZoneId(), ldt, viewer);
    }

    public static ZonedDateTime useZdt(LocalDateTime ldt, ZoneId viewer) {
        return DateLocaling.zoned(ThreadNow.sysZoneId(), ldt, viewer);
    }

    public static LocalDateTime local(ZoneId at, LocalDateTime ldt, ZoneId to) {
        if (ldt == null) {
            return null;
        }
        if (to == null || at.equals(to)) {
            return ldt;
        }
        return ldt.atZone(at).withZoneSameInstant(to).toLocalDateTime();
    }

    public static ZonedDateTime zoned(ZoneId at, LocalDateTime ldt, ZoneId to) {
        if (ldt == null) {
            return null;
        }
        if (to == null || at.equals(to)) {
            return ldt.atZone(at);
        }
        return ldt.atZone(at).withZoneSameInstant(to);
    }

    public static LocalDateTime local(ZonedDateTime zdt, ZoneId to) {
        if (zdt == null) {
            return null;
        }
        if (to == null) {
            return zdt.toLocalDateTime();
        }
        if (zdt.getZone().equals(to)) {
            return zdt.toLocalDateTime();
        }
        return zdt.withZoneSameInstant(to).toLocalDateTime();
    }

    public static ZonedDateTime zoned(ZonedDateTime zdt, ZoneId to) {
        if (zdt == null) {
            return null;
        }
        if (to == null) {
            return zdt;
        }
        if (zdt.getZone().equals(to)) {
            return zdt;
        }
        return zdt.withZoneSameInstant(to);
    }
}

