/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.mirana.time;

import java.time.Duration;
import org.jetbrains.annotations.NotNull;

public class Sleep {
    public static void ignoreInterrupt(@NotNull Duration time) {
        Sleep.ignoreInterrupt(time.toMillis());
    }

    public static void ignoreInterrupt(long ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void snoozeInterrupt(@NotNull Duration time) {
        Sleep.snoozeInterrupt(time.toMillis());
    }

    public static void snoozeInterrupt(long ms) {
        long wake = System.currentTimeMillis() + ms;
        while (true) {
            try {
                Thread.sleep(ms);
            }
            catch (InterruptedException e) {
                long now = System.currentTimeMillis();
                if (now >= wake) break;
                ms = wake - now;
                continue;
            }
            break;
        }
    }

    public static void throwsInterrupt(@NotNull Duration time, boolean keep) {
        Sleep.throwsInterrupt(time.toMillis(), keep);
    }

    public static void throwsInterrupt(long ms, boolean keep) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException e) {
            if (keep) {
                Thread.currentThread().interrupt();
            }
            throw new IllegalStateException(e);
        }
    }
}

