/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.mirana.bits;

import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pro.fessional.mirana.bits.Aes;

public class Aes256
extends Aes {
    public Aes256(@NotNull String secKey) {
        this(secKey, null);
    }

    public Aes256(@NotNull String secKey, @Nullable String salt) {
        super(Aes256.key(secKey, salt));
    }

    public static byte[] key(@NotNull String secKey, @Nullable String salt) {
        try {
            byte[] bs = salt == null ? secKey.getBytes() : salt.getBytes();
            PBEKeySpec spec = new PBEKeySpec(secKey.toCharArray(), bs, 256, 256);
            SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA256");
            return factory.generateSecret(spec).getEncoded();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    @NotNull
    public static Aes256 of(@NotNull String secKey) {
        return new Aes256(secKey, null);
    }

    @NotNull
    public static Aes256 of(@NotNull String secKey, @Nullable String slat) {
        return new Aes256(secKey, slat);
    }
}

