/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.mirana.evil;

import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import pro.fessional.mirana.evil.ThreadLocalAttention;
import pro.fessional.mirana.evil.ThreadLocalProxy;

public class TweakingContext<T> {
    private final AtomicReference<Supplier<T>> defaultValue = new AtomicReference();
    private final AtomicReference<Supplier<T>> globalValue = new AtomicReference();
    private final ThreadLocalProxy<Supplier<T>> threadValue = new ThreadLocalProxy();

    public TweakingContext() {
    }

    public TweakingContext(T initDefault) {
        this.initDefault(initDefault);
    }

    public TweakingContext(Supplier<T> initDefault) {
        this.initDefault(initDefault);
    }

    public void initDefault(T value) {
        this.defaultValue.set(() -> value);
    }

    public void initDefault(Supplier<T> value) {
        this.defaultValue.set(value);
    }

    public void initGlobal(T value) {
        this.tweakGlobal(value);
    }

    public void initGlobal(Supplier<T> value) {
        this.tweakGlobal(value);
    }

    public void initThread(@NotNull ThreadLocal<Supplier<T>> threadLocal, boolean tryToCleanOld) throws ThreadLocalAttention {
        this.threadValue.replaceBackend(threadLocal, tryToCleanOld);
    }

    public void tweakGlobal(T stack) {
        this.globalValue.set(() -> stack);
    }

    public void tweakGlobal(Supplier<T> stack) {
        this.globalValue.set(stack);
    }

    public void resetGlobal() {
        this.globalValue.set(null);
    }

    public void tweakThread(T stack) {
        if (stack == null) {
            this.threadValue.remove();
        } else {
            this.threadValue.set(() -> stack);
        }
    }

    public void tweakThread(Supplier<T> stack) {
        if (stack == null) {
            this.threadValue.remove();
        } else {
            this.threadValue.set(stack);
        }
    }

    public void resetThread() {
        this.threadValue.remove();
    }

    @Contract(value="true->!null")
    public T globalValue(boolean notnull) {
        T t;
        Supplier<T> s = this.globalValue.get();
        T t2 = t = s == null ? null : (T)s.get();
        if (t == null && notnull) {
            throw new IllegalStateException("global value is null");
        }
        return t;
    }

    @Contract(value="true->!null")
    public T threadValue(boolean notnull) {
        T t;
        Supplier<T> s = this.threadValue.get();
        T t2 = t = s == null ? null : (T)s.get();
        if (t == null && notnull) {
            throw new IllegalStateException("thread value is null");
        }
        return t;
    }

    @Contract(value="true->!null")
    public T defaultValue(boolean notnull) {
        T t;
        Supplier<T> s = this.defaultValue.get();
        T t2 = t = s == null ? null : (T)s.get();
        if (t == null && notnull) {
            throw new IllegalStateException("default value is null");
        }
        return t;
    }

    @Contract(value="true->!null")
    public T current(boolean notnull) {
        T t = this.threadValue(false);
        if (t != null) {
            return t;
        }
        T g = this.globalValue(false);
        if (g != null) {
            return g;
        }
        return this.defaultValue(notnull);
    }
}

