/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.mirana.io;

import java.io.File;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;

public class DirHasher {
    public static final int MAX_FILE = 30000;
    private static final AtomicLong SEQ = new AtomicLong(System.currentTimeMillis());

    @NotNull
    public static File mkdirs(File root) {
        long fileId = SEQ.incrementAndGet();
        return DirHasher.mkdirs(root, fileId);
    }

    @NotNull
    public static File mkdirs(File root, long fileId) {
        String sub = DirHasher.mkdirs(fileId);
        File dir = new File(root, sub);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return dir;
    }

    @NotNull
    public static String mkdirs(long fileId) {
        StringBuilder sb = new StringBuilder("/");
        while (fileId > 30000L) {
            sb.append(fileId % 30000L).append("/");
            fileId /= 30000L;
        }
        return sb.toString();
    }
}

