/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.mirana.math;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;

public class AverageDecimal
implements Iterable<BigDecimal> {
    private final int size;
    private final int scale;
    private final BigDecimal total;
    private final BigDecimal precision;
    private final BigDecimal avgValue;
    private final BigDecimal fixValue;
    private final int fixCount;

    public static AverageDecimal of(BigDecimal total, int count) {
        return new AverageDecimal(total, count, 2);
    }

    public static AverageDecimal of(BigDecimal total, int count, int scale) {
        return new AverageDecimal(total, count, scale);
    }

    private AverageDecimal(BigDecimal total, int size, int scale) {
        this.size = size;
        this.scale = scale;
        this.total = total;
        BigDecimal itemSize = new BigDecimal(size);
        this.precision = BigDecimal.ONE.divide(BigDecimal.TEN.pow(scale), scale, RoundingMode.FLOOR);
        this.avgValue = total.divide(itemSize, scale, RoundingMode.FLOOR);
        this.fixValue = this.avgValue.add(this.precision);
        BigDecimal remaining = total.subtract(this.avgValue.multiply(itemSize));
        this.fixCount = remaining.divide(this.precision, 0, RoundingMode.FLOOR).intValue();
    }

    @Override
    @NotNull
    public Iterator<BigDecimal> iterator() {
        return new Iterator<BigDecimal>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < AverageDecimal.this.size;
            }

            @Override
            public BigDecimal next() {
                return AverageDecimal.this.get(this.index++);
            }
        };
    }

    public BigDecimal get(int i) {
        return i < this.fixCount ? this.fixValue : this.avgValue;
    }

    public int size() {
        return this.size;
    }

    public BigDecimal total() {
        return this.total;
    }

    public int scale() {
        return this.scale;
    }

    public BigDecimal getPrecision() {
        return this.precision;
    }

    public BigDecimal getAvgValue() {
        return this.avgValue;
    }

    public BigDecimal getFixValue() {
        return this.fixValue;
    }

    public int getFixCount() {
        return this.fixCount;
    }

    public String toString() {
        return "AverageDecimal{size=" + this.size + ", scale=" + this.scale + ", total=" + this.total + ", avgValue=" + this.avgValue + ", fixValue=" + this.fixValue + ", fixCount=" + this.fixCount + '}';
    }
}

