/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.mirana.pain;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import pro.fessional.mirana.best.Param;
import pro.fessional.mirana.pain.IORuntimeException;

public class ThrowableUtil {
    public static void print(@Param.Out Appendable buffer, Throwable t) {
        ThrowableUtil.print(buffer, t, true, true, 5, Integer.MAX_VALUE, 1);
    }

    public static void print(@Param.Out Appendable buffer, Throwable t, boolean reverse, boolean shorten) {
        ThrowableUtil.print(buffer, t, reverse, shorten, Integer.MAX_VALUE, Integer.MAX_VALUE, 1);
    }

    public static void print(@Param.Out Appendable buffer, Throwable t, boolean reverse, boolean shorten, int maxStack, int maxCause) {
        ThrowableUtil.print(buffer, t, reverse, shorten, maxStack, maxCause, 1);
    }

    private static void print(@Param.Out Appendable buffer, Throwable t, boolean reverse, boolean shorten, int stack, int max, int cur) {
        if (t == null || max < cur) {
            return;
        }
        Throwable c = t.getCause();
        int nextDepth = cur + 1;
        boolean caused = c != null;
        try {
            if (reverse) {
                if (caused) {
                    ThrowableUtil.print(buffer, c, reverse, shorten, stack, max, nextDepth);
                }
                ThrowableUtil.doPrint(buffer, t, reverse, shorten, !caused, caused ? stack : Integer.MAX_VALUE, cur);
            } else {
                ThrowableUtil.doPrint(buffer, t, reverse, shorten, !caused, caused ? stack : Integer.MAX_VALUE, cur);
                if (caused) {
                    ThrowableUtil.print(buffer, c, reverse, shorten, stack, max, nextDepth);
                }
            }
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    private static void doPrint(@Param.Out Appendable buffer, Throwable t, boolean reverse, boolean shorten, boolean root, int stk, int cur) throws IOException {
        if (reverse) {
            if (!root) {
                buffer.append("Causes to: ");
            }
        } else if (cur > 1) {
            buffer.append("Caused by: ");
        }
        if (root) {
            buffer.append("(RootCause) ");
        }
        buffer.append(t.getClass().getName()).append(": ").append(t.getMessage()).append('\n');
        int i = 0;
        boolean nfn = true;
        StringBuilder sb = buffer instanceof StringBuilder ? (StringBuilder)buffer : new StringBuilder();
        for (StackTraceElement el : t.getStackTrace()) {
            if (++i > stk) break;
            buffer.append("\tat ");
            String cn = el.getClassName();
            if (shorten) {
                int cl = sb.length();
                int ln = cn.length();
                for (int j = 0; j < ln; ++j) {
                    char c = cn.charAt(j);
                    if (c == '.') {
                        sb.setLength(cl + 1);
                        cl += 2;
                    }
                    buffer.append(c);
                }
                if (sb != buffer) {
                    buffer.append(sb.toString());
                    sb.setLength(0);
                }
            } else {
                buffer.append(cn);
            }
            buffer.append('.').append(el.getMethodName()).append('(');
            if (el.isNativeMethod()) {
                buffer.append("Native");
            } else {
                String fn = el.getFileName();
                if (fn == null) {
                    buffer.append("Unknown");
                } else {
                    if (nfn) {
                        buffer.append(fn);
                        nfn = false;
                    }
                    buffer.append(":").append(String.valueOf(el.getLineNumber()));
                }
            }
            buffer.append(")\n");
        }
    }

    @NotNull
    public static String toString(Throwable t) {
        if (t == null) {
            return "";
        }
        StringWriter sw = new StringWriter();
        try (PrintWriter pw = new PrintWriter(sw);){
            t.printStackTrace(pw);
            String string = sw.toString();
            return string;
        }
    }

    @NotNull
    public static String rootString(Throwable t) {
        Throwable r = ThrowableUtil.root(t);
        return ThrowableUtil.toString(r);
    }

    @Contract(value="!null->!null")
    public static Throwable root(Throwable t) {
        while (t != null) {
            Throwable x = t.getCause();
            if (x == null) {
                return t;
            }
            t = x;
        }
        return t;
    }

    public static boolean contains(Throwable t, Class<? extends Throwable> e) {
        if (e == null) {
            return false;
        }
        while (t != null) {
            if (e.isInstance(t)) {
                return true;
            }
            t = t.getCause();
        }
        return false;
    }

    public static <T extends Throwable> T firstCause(Throwable t, Class<T> e) {
        if (e == null) {
            return null;
        }
        Throwable f = null;
        while (t != null) {
            if (e.isInstance(t)) {
                f = t;
            }
            t = t.getCause();
        }
        return (T)f;
    }

    public static <T extends Throwable> T lastCause(Throwable t, Class<T> e) {
        if (e == null) {
            return null;
        }
        while (t != null) {
            if (e.isInstance(t)) {
                return (T)t;
            }
            t = t.getCause();
        }
        return null;
    }

    @SafeVarargs
    public static void throwMatch(Throwable t, Class<? extends RuntimeException> ... runtime) {
        if (runtime != null) {
            for (Class<? extends RuntimeException> re : runtime) {
                if (!re.isInstance(t)) continue;
                throw (RuntimeException)t;
            }
        }
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        throw new RuntimeException(t);
    }

    @SafeVarargs
    public static void throwCause(Throwable t, Class<? extends RuntimeException> ... runtime) {
        if (runtime != null && runtime.length > 0) {
            while (t != null) {
                for (Class<? extends RuntimeException> e : runtime) {
                    if (!e.isInstance(t)) continue;
                    throw (RuntimeException)t;
                }
                t = t.getCause();
            }
        }
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        throw new RuntimeException(t);
    }
}

