/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.mirana.stat;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jetbrains.annotations.NotNull;

public class JvmStat {
    private static int pid = -1;
    private static String name = null;

    public static String jvmName() {
        if (name == null) {
            Stat st = new Stat();
            JvmStat.buildRuntime(st);
            pid = st.pid;
            name = st.name;
        }
        return name;
    }

    public static int jvmPid() {
        if (pid < 0) {
            Stat st = new Stat();
            JvmStat.buildRuntime(st);
            pid = st.pid;
            name = st.name;
        }
        return pid;
    }

    @NotNull
    public static Stat stat() {
        long bgn = System.currentTimeMillis();
        Stat stat = new Stat();
        JvmStat.buildRuntime(stat);
        JvmStat.buildCpuLoad(stat);
        JvmStat.buildThread(stat);
        JvmStat.buildMemory(stat);
        stat.timeDone = System.currentTimeMillis();
        stat.timeCost = stat.timeDone - bgn;
        return stat;
    }

    public static void buildRuntime(Stat stat) {
        try {
            RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
            String name = runtimeMXBean.getName();
            stat.name = name;
            stat.pid = Integer.parseInt(name.split("@")[0]);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void buildCpuLoad(Stat stat) {
        try {
            OperatingSystemMXBean mxBean = ManagementFactory.getOperatingSystemMXBean();
            stat.processor = mxBean.getAvailableProcessors();
            double load = mxBean.getSystemLoadAverage();
            if (load >= 0.0) {
                stat.systemLoad = (int)(load * 100.0);
            }
        }
        catch (Throwable mxBean) {
            // empty catch block
        }
        try {
            Attribute att;
            Double value;
            AttributeList scl;
            Attribute att2;
            Double value2;
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName name = ObjectName.getInstance("java.lang:type=OperatingSystem");
            AttributeList pcl = mbs.getAttributes(name, new String[]{"ProcessCpuLoad"});
            if (!pcl.isEmpty() && (value2 = (Double)(att2 = (Attribute)pcl.get(0)).getValue()) != null && value2 >= 0.0) {
                stat.processLoad = (int)(value2 * 100.0 * (double)stat.processor);
            }
            if (!(scl = mbs.getAttributes(name, new String[]{"SystemCpuLoad"})).isEmpty() && (value = (Double)(att = (Attribute)scl.get(0)).getValue()) != null && value >= 0.0) {
                stat.systemLoad = (int)(value * 100.0 * (double)stat.processor);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void buildThread(Stat stat) {
        try {
            ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
            stat.threadCount = threadMXBean.getThreadCount();
            stat.daemonCount = threadMXBean.getDaemonThreadCount();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void buildMemory(Stat stat) {
        try {
            MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
            MemoryUsage usage = memoryMXBean.getHeapMemoryUsage();
            long size = usage.getMax();
            long comm = usage.getCommitted();
            stat.memorySize = size;
            stat.memoryFree = size - comm;
            stat.memoryLoad = (int)(comm * 100L / size);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void main(String[] args) {
        System.out.println(JvmStat.stat());
    }

    public static class Stat {
        private int pid = -1;
        private String name = null;
        private long timeDone = -1L;
        private long timeCost = -1L;
        private int processor = -1;
        private int systemLoad = -1;
        private int processLoad = -1;
        private int threadCount = -1;
        private int daemonCount = -1;
        private long memorySize = -1L;
        private long memoryFree = -1L;
        private int memoryLoad = -1;

        public long getTimeDone() {
            return this.timeDone;
        }

        public long getTimeCost() {
            return this.timeCost;
        }

        public int getPid() {
            return this.pid;
        }

        public String getName() {
            return this.name;
        }

        public int getProcessor() {
            return this.processor;
        }

        public int getSystemLoad() {
            return this.systemLoad;
        }

        public int getProcessLoad() {
            return this.processLoad;
        }

        public int getThreadCount() {
            return this.threadCount;
        }

        public int getDaemonCount() {
            return this.daemonCount;
        }

        public long getMemorySize() {
            return this.memorySize;
        }

        public long getMemoryFree() {
            return this.memoryFree;
        }

        public int getMemoryLoad() {
            return this.memoryLoad;
        }

        public int getMemoryCent() {
            return this.memoryLoad;
        }

        public int getProcessCent() {
            return this.processLoad < 0 ? -1 : this.processLoad / this.processor;
        }

        public int getSystemCent() {
            return this.systemLoad < 0 ? -1 : this.systemLoad / this.processor;
        }

        public int getThreadLoad() {
            return this.threadCount * 100 / this.processor;
        }

        public String toString() {
            return "Stat{pid=" + this.pid + ", name=" + this.name + ", timeDone=" + this.timeDone + ", timeCost=" + this.timeCost + ", processor=" + this.processor + ", systemLoad=" + this.systemLoad + ", processLoad=" + this.processLoad + ", threadCount=" + this.threadCount + ", daemonCount=" + this.daemonCount + ", memorySize=" + this.memorySize + ", memoryFree=" + this.memoryFree + ", memoryLoad=" + this.memoryLoad + '}';
        }
    }
}

