/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.mirana.stat;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class WordStat {
    public void printJavax(@NotNull Path path) {
        Map<String, Integer> map = this.statJavaxUtf8(path);
        this.printWord(map, new PrintWriter(System.out), en -> ((String)en.getKey()).length() <= 10 || (Integer)en.getValue() >= 2);
    }

    public void printWord(Map<String, Integer> stats, Writer writer, Predicate<Map.Entry<String, Integer>> filter) {
        String wd;
        ArrayList<AbstractMap.SimpleEntry<Integer, String>> list = new ArrayList<AbstractMap.SimpleEntry<Integer, String>>(stats.size());
        int maxLen = 0;
        for (Map.Entry<String, Integer> entry : stats.entrySet()) {
            if (!filter.test(entry)) continue;
            wd = entry.getKey();
            if (wd.length() > maxLen) {
                maxLen = wd.length();
            }
            list.add(new AbstractMap.SimpleEntry<Integer, String>(entry.getValue(), wd));
        }
        list.sort((o1, o2) -> {
            int cmp = ((Integer)o1.getKey()).compareTo((Integer)o2.getKey());
            return cmp != 0 ? -cmp : ((String)o2.getValue()).compareTo((String)o1.getValue());
        });
        try {
            for (Map.Entry<String, Integer> entry : list) {
                wd = (String)((Object)entry.getValue());
                int len = wd.length();
                writer.write(wd);
                for (int i = len - 2; i < maxLen; ++i) {
                    writer.write(32);
                }
                writer.write(String.valueOf(entry.getKey()));
                writer.write(10);
                writer.flush();
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public Map<String, Integer> statJavaxUtf8(@NotNull Path path) {
        Pattern ptn = Pattern.compile("\\.java$|\\.kt$|\\.js$|\\.ts$", 2);
        return this.statPath(path, StandardCharsets.UTF_8, ptn, this::statWord);
    }

    public Map<String, Integer> statPath(@NotNull Path path, final Charset encoding, final @NotNull Pattern regexp, final @NotNull Function<BufferedReader, Map<String, Integer>> counter) {
        final HashMap<String, Integer> map = new HashMap<String, Integer>();
        try {
            Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    String fp = file.toString();
                    if (regexp.matcher(fp).find()) {
                        try (BufferedReader br = Files.newBufferedReader(file, encoding);){
                            Map wd = (Map)counter.apply(br);
                            for (Map.Entry en : wd.entrySet()) {
                                map.compute(en.getKey(), (k, v) -> v == null ? (Integer)en.getValue() : Integer.valueOf(v + (Integer)en.getValue()));
                            }
                            wd.clear();
                        }
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return map;
    }

    public Map<String, Integer> statWord(@NotNull BufferedReader br) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        try {
            String ln = br.readLine();
            while (ln != null) {
                this.statWord(map, ln);
                ln = br.readLine();
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return map;
    }

    public void statWord(Map<String, Integer> map, String line) {
        StringBuilder sb = new StringBuilder();
        boolean upper = false;
        int ln = line.length();
        for (int i = 0; i < ln; ++i) {
            char c = line.charAt(i);
            if (c >= 'a' && c <= 'z') {
                sb.append(c);
                upper = false;
                continue;
            }
            if (c >= 'A' && c <= 'Z') {
                if (!upper) {
                    this.capture(map, sb);
                }
                char cl = (char)(c + 32);
                sb.append(cl);
                upper = true;
                continue;
            }
            this.capture(map, sb);
            upper = false;
        }
    }

    private void capture(Map<String, Integer> map, StringBuilder sb) {
        String k = sb.toString().trim();
        int len = k.length();
        if (len > 1 && len <= 20) {
            map.compute(k, (s, v) -> v == null ? 1 : v + 1);
        }
        sb.setLength(0);
    }

    public static void main(String[] args) {
        WordStat ws = new WordStat();
        if (args.length > 0) {
            ws.printJavax(Paths.get(args[0], new String[0]));
        } else {
            ws.printJavax(Paths.get(".", new String[0]));
        }
    }
}

