/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.mirana.tk;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import pro.fessional.mirana.data.Null;
import pro.fessional.mirana.tk.Ticket;

public class AnyTicket
implements Ticket.Mutable {
    private static final long serialVersionUID = 19791023L;
    private String pubMod = "";
    private long pubExp = 0L;
    private int pubSeq = 0;
    private String bizPart = "";
    private String sigPart = "";

    public AnyTicket() {
    }

    public AnyTicket(String pubMod) {
        this.pubMod = Null.notNull(pubMod);
    }

    public AnyTicket(String pubMod, long pubExp, int pubSeq, String bizPart, String sigPart) {
        this.pubMod = Null.notNull(pubMod);
        this.pubExp = Math.max(0L, pubExp);
        this.pubSeq = Math.max(0, pubSeq);
        this.bizPart = Null.notNull(bizPart);
        this.sigPart = Null.notNull(sigPart);
    }

    @Override
    @NotNull
    public String getPubMod() {
        return this.pubMod;
    }

    @Override
    public void setPubMod(String pubMod) {
        this.pubMod = Null.notNull(pubMod);
    }

    @Override
    public long getPubDue() {
        return this.pubExp;
    }

    @Override
    public void setPubDue(long pubExp) {
        this.pubExp = Math.max(0L, pubExp);
    }

    @Override
    public int getPubSeq() {
        return this.pubSeq;
    }

    @Override
    public void setPubSeq(int pubSeq) {
        this.pubSeq = Math.max(0, pubSeq);
    }

    @Override
    @NotNull
    public String getBizPart() {
        return this.bizPart;
    }

    @Override
    public void setBizPart(String bizPart) {
        this.bizPart = Null.notNull(bizPart);
    }

    @Override
    @NotNull
    public String getSigPart() {
        return this.sigPart;
    }

    @Override
    public void setSigPart(String sigPart) {
        this.sigPart = Null.notNull(sigPart);
    }

    @Override
    @NotNull
    public String serialize() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.pubMod);
        sb.append('-').append(this.pubExp);
        sb.append('-').append(this.pubSeq);
        if (!this.bizPart.isEmpty()) {
            sb.append('.').append(this.bizPart);
        }
        sb.append('.').append(this.sigPart);
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnyTicket anyTicket = (AnyTicket)o;
        return this.pubExp == anyTicket.pubExp && this.pubSeq == anyTicket.pubSeq && this.pubMod.equals(anyTicket.pubMod) && this.bizPart.equals(anyTicket.bizPart) && this.sigPart.equals(anyTicket.sigPart);
    }

    public int hashCode() {
        return Objects.hash(this.pubMod, this.pubExp, this.pubSeq, this.bizPart, this.sigPart);
    }

    public String toString() {
        return "AnyTicket{pubMod='" + this.pubMod + '\'' + ", pubExp=" + this.pubExp + ", pubSeq=" + this.pubSeq + ", bizPart='" + this.bizPart + '\'' + ", sigPart='" + this.sigPart + '\'' + '}';
    }
}

