/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.mirana.bits;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pro.fessional.mirana.best.Param;
import pro.fessional.mirana.data.Null;

public class Bytes {
    private static final char[] HEX_UPPER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final char[] HEX_LOWER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final byte[] HEX_BYTE = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};

    public static byte[] hex(@Nullable String hex) {
        if (hex == null || hex.isEmpty()) {
            return Null.Bytes;
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream(hex.length() / 2);
        Bytes.hex(bos, hex);
        return bos.toByteArray();
    }

    public static int hex(@Param.Out OutputStream os, @Nullable String hex) {
        if (hex == null || hex.isEmpty()) {
            return 0;
        }
        int cnt = 0;
        int c1 = -1;
        int c2 = -1;
        int len = hex.length();
        for (int i = 0; i < len; ++i) {
            char c = hex.charAt(i);
            if (c >= '0' && c <= '9') {
                c2 = c - 48;
            } else if (c >= 'A' && c <= 'F') {
                c2 = c - 65 + 10;
            } else if (c >= 'a' && c <= 'f') {
                c2 = c - 97 + 10;
            } else {
                if (c == ' ' || c == '\t' || c == '\r' || c == '\n') continue;
                throw new IllegalArgumentException("not hex char " + c);
            }
            if (c1 == -1) {
                c1 = c2;
                continue;
            }
            try {
                os.write(c1 << 4 | c2);
                ++cnt;
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
            c1 = -1;
        }
        return cnt;
    }

    @NotNull
    public static String hex(byte[] bytes) {
        return Bytes.hex(bytes, true);
    }

    @NotNull
    public static String hex(byte[] bytes, boolean upper) {
        if (bytes == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder(bytes.length * 2);
        char[] table = upper ? HEX_UPPER : HEX_LOWER;
        for (byte b : bytes) {
            Bytes.hex(sb, b, table);
        }
        return sb.toString();
    }

    public static void hex(@NotNull StringBuilder sb, byte b, char[] table) {
        sb.append(table[b >>> 4 & 0xF]);
        sb.append(table[b & 0xF]);
    }

    public static int unicode(char c, byte[] ob) {
        if (ob == null) {
            return 0;
        }
        if (c > '\u007f') {
            char i = c;
            ob[0] = 92;
            ob[1] = 117;
            ob[2] = HEX_BYTE[i >>> 12 & 0xF];
            ob[3] = HEX_BYTE[i >>> 8 & 0xF];
            ob[4] = HEX_BYTE[i >>> 4 & 0xF];
            ob[5] = HEX_BYTE[i & 0xF];
            return 6;
        }
        ob[0] = (byte)c;
        return 1;
    }
}

