/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.mirana.cast;

import java.math.BigDecimal;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringCastUtil {
    public static boolean asTrue(@Nullable String str) {
        if (str == null) {
            return false;
        }
        return "true".equalsIgnoreCase(str) || "t".equalsIgnoreCase(str) || "yes".equalsIgnoreCase(str) || "y".equalsIgnoreCase(str);
    }

    public static boolean asFalse(@Nullable String str) {
        if (str == null) {
            return true;
        }
        return "false".equalsIgnoreCase(str) || "f".equalsIgnoreCase(str) || "no".equalsIgnoreCase(str) || "n".equalsIgnoreCase(str) || str.isEmpty() || str.trim().isEmpty();
    }

    public static long asLong(@Nullable String str, long elz) {
        if (str == null) {
            return elz;
        }
        try {
            return Long.parseLong(str);
        }
        catch (NumberFormatException e) {
            return elz;
        }
    }

    public static int asInt(@Nullable String str, int elz) {
        if (str == null) {
            return elz;
        }
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            return elz;
        }
    }

    public static float asFloat(@Nullable String str, float elz) {
        if (str == null) {
            return elz;
        }
        try {
            return Float.parseFloat(str);
        }
        catch (NumberFormatException e) {
            return elz;
        }
    }

    public static double asDouble(@Nullable String str, double elz) {
        if (str == null) {
            return elz;
        }
        try {
            return Double.parseDouble(str);
        }
        catch (NumberFormatException e) {
            return elz;
        }
    }

    @NotNull
    public static BigDecimal asDecimal(String str, @NotNull BigDecimal elz) {
        if (str == null) {
            return elz;
        }
        try {
            return new BigDecimal(str);
        }
        catch (Exception e) {
            return elz;
        }
    }

    @NotNull
    public static String string(BigDecimal v) {
        return v == null ? "" : v.toPlainString();
    }

    @NotNull
    public static String string(Object v) {
        return v == null ? "" : String.valueOf(v);
    }

    @Contract(value="_,!null -> !null")
    public static String string(BigDecimal v, String elz) {
        return v == null ? elz : v.toPlainString();
    }

    @Contract(value="_,!null -> !null")
    public static String string(Object v, String elz) {
        return v == null ? elz : String.valueOf(v);
    }
}

