/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.mirana.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class CompatibleObjectStream
extends ObjectInputStream {
    private static final ConcurrentMap<Key, Object> CompatibleClass = new ConcurrentHashMap<Key, Object>();
    private static final Object Same = CompatibleObjectStream.class;

    public CompatibleObjectStream(InputStream in) throws IOException {
        super(in);
    }

    @Override
    protected ObjectStreamClass readClassDescriptor() throws IOException, ClassNotFoundException {
        ObjectStreamClass remote = super.readClassDescriptor();
        Key key = new Key(remote);
        ObjectStreamClass local = this.checkCompatible(key);
        return local == null ? remote : local;
    }

    private ObjectStreamClass checkCompatible(Key key) {
        Object local = CompatibleClass.get(key);
        if (local == Same) {
            return null;
        }
        if (local != null) {
            return (ObjectStreamClass)local;
        }
        try {
            Class<?> lc = Class.forName(key.name);
            ObjectStreamClass ld = ObjectStreamClass.lookup(lc);
            if (ld != null && ld.getSerialVersionUID() != key.suid) {
                CompatibleClass.put(key, ld);
                return ld;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        CompatibleClass.put(key, Same);
        return null;
    }

    private static class Key {
        private final String name;
        private final long suid;

        public Key(ObjectStreamClass clz) {
            this.name = clz.getName();
            this.suid = clz.getSerialVersionUID();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Key)) {
                return false;
            }
            Key key = (Key)o;
            return this.suid == key.suid && this.name.equals(key.name);
        }

        public int hashCode() {
            int h = this.name.hashCode();
            return (int)((long)h ^ this.suid >>> 32);
        }
    }
}

