/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.mirana.time;

import java.time.Duration;
import java.util.concurrent.ThreadLocalRandom;
import org.jetbrains.annotations.NotNull;

public class Sleep {
    public static void ignoreInterrupt(@NotNull Duration time) {
        Sleep.ignoreInterrupt(time.toMillis());
    }

    public static void ignoreInterrupt(long ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public static long ignoreInterrupt(long min, long max) {
        long ms = ThreadLocalRandom.current().nextLong(min, max);
        long now = System.currentTimeMillis();
        Sleep.ignoreInterrupt(ms);
        return System.currentTimeMillis() - now;
    }

    public static void snoozeInterrupt(@NotNull Duration time) {
        Sleep.snoozeInterrupt(time.toMillis());
    }

    public static void snoozeInterrupt(long ms) {
        long wake = System.currentTimeMillis() + ms;
        boolean rup = false;
        while (true) {
            try {
                Thread.sleep(ms);
            }
            catch (InterruptedException e) {
                rup = true;
                long now = System.currentTimeMillis();
                if (now >= wake) break;
                ms = wake - now;
                continue;
            }
            break;
        }
        if (rup) {
            Thread.currentThread().interrupt();
        }
    }

    public static long snoozeInterrupt(long min, long max) {
        long ms = ThreadLocalRandom.current().nextLong(min, max);
        Sleep.snoozeInterrupt(ms);
        return ms;
    }

    public static void throwsInterrupt(@NotNull Duration time, boolean keep) {
        Sleep.throwsInterrupt(time.toMillis(), keep);
    }

    public static void throwsInterrupt(long ms, boolean keep) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException e) {
            if (keep) {
                Thread.currentThread().interrupt();
            }
            throw new IllegalStateException(e);
        }
    }

    public static void throwsInterrupt(long min, long max, boolean keep) {
        long ms = ThreadLocalRandom.current().nextLong(min, max);
        Sleep.throwsInterrupt(ms, keep);
    }
}

