/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.mirana.bits;

import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pro.fessional.mirana.bits.Bytes;
import pro.fessional.mirana.data.Null;
import pro.fessional.mirana.io.InputStreams;

public class HmacHelp {
    public final String algorithm;
    public final byte @NotNull [] key;

    protected HmacHelp(String algorithm, byte @NotNull [] key) {
        this.algorithm = algorithm;
        this.key = key;
    }

    @NotNull
    public String sum(@Nullable String str) {
        return this.sum(str, true);
    }

    @NotNull
    public String sum(@Nullable InputStream ins) {
        return this.sum(ins, true);
    }

    @NotNull
    public String sum(byte @Nullable [] bytes) {
        return this.sum(bytes, true);
    }

    @NotNull
    public String sum(@Nullable String str, boolean upper) {
        if (str == null) {
            return "";
        }
        return this.sum(str.getBytes(StandardCharsets.UTF_8), upper);
    }

    @NotNull
    public String sum(@Nullable InputStream ins, boolean upper) {
        if (ins == null) {
            return "";
        }
        byte @NotNull [] bytes = InputStreams.readBytes(ins);
        return this.sum(bytes, upper);
    }

    @NotNull
    public String sum(byte @Nullable [] bytes, boolean upper) {
        if (bytes == null) {
            return "";
        }
        byte @NotNull [] hash = this.digest(bytes);
        return Bytes.hex(hash, upper);
    }

    public byte @NotNull [] digest(byte @Nullable [] bytes) {
        if (bytes == null) {
            return Null.Bytes;
        }
        Mac mac = this.newOne();
        return mac.doFinal(bytes);
    }

    @NotNull
    public Mac newOne() {
        return HmacHelp.newOne(this.algorithm, this.key);
    }

    public boolean check(@Nullable String sum, byte @Nullable [] bytes) {
        if (bytes == null || sum == null) {
            return false;
        }
        String md5 = this.sum(bytes);
        return sum.equalsIgnoreCase(md5);
    }

    public boolean check(@Nullable String sum, @Nullable String str) {
        if (str == null || sum == null) {
            return false;
        }
        String md5 = this.sum(str);
        return sum.equalsIgnoreCase(md5);
    }

    public boolean check(@Nullable String sum, @Nullable InputStream ins) {
        if (ins == null || sum == null) {
            return false;
        }
        String md5 = this.sum(ins);
        return sum.equalsIgnoreCase(md5);
    }

    @NotNull
    public static Mac newOne(@NotNull String algorithm, byte @NotNull [] key) {
        try {
            SecretKeySpec sks = new SecretKeySpec(key, algorithm);
            Mac mac = Mac.getInstance(algorithm);
            mac.init(sks);
            return mac;
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new IllegalStateException("can not init algorithm=" + algorithm, e);
        }
    }

    @NotNull
    public static HmacHelp md5(byte @NotNull [] key) {
        return HmacHelp.of("HmacMD5", key);
    }

    @NotNull
    public static HmacHelp sha1(byte @NotNull [] key) {
        return HmacHelp.of("HmacSHA1", key);
    }

    @NotNull
    public static HmacHelp sha256(byte @NotNull [] key) {
        return HmacHelp.of("HmacSHA256", key);
    }

    @NotNull
    public static HmacHelp of(@NotNull String algorithm, byte @NotNull [] key) {
        return new HmacHelp(algorithm, key);
    }

    @NotNull
    public static Mac newMd5(byte @NotNull [] key) {
        return HmacHelp.newOne("HmacMD5", key);
    }

    @NotNull
    public static Mac newSha1(byte @NotNull [] key) {
        return HmacHelp.newOne("HmacSHA1", key);
    }

    @NotNull
    public static Mac newSha256(byte @NotNull [] key) {
        return HmacHelp.newOne("HmacSHA256", key);
    }
}

