/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.mirana.cast;

import java.util.function.Function;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pro.fessional.mirana.cast.BoxedTypeUtil;

public interface BiConvertor<S, T> {
    @NotNull
    public Class<S> sourceType();

    @NotNull
    public Class<T> targetType();

    @Nullable
    @Contract(value="null->null;!null->!null")
    public T toTarget(S var1);

    @Nullable
    @Contract(value="null->null;!null->!null")
    public S toSource(T var1);

    @Nullable
    default public T tryToTarget(Object source) {
        T t = null;
        if (this.canToTarget(source)) {
            try {
                t = this.toTarget(source);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return t;
    }

    @Nullable
    default public S tryToSource(Object target) {
        S s = null;
        if (this.canToSource(target)) {
            try {
                s = this.toSource(target);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return s;
    }

    @Nullable
    default public T tryToTarget(Class<?> target, Object source) {
        T t = null;
        if (this.canToTarget(target, source)) {
            try {
                t = this.toTarget(source);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return t;
    }

    @Nullable
    default public S tryToSource(Class<?> source, Object target) {
        S s = null;
        if (this.canToSource(source, target)) {
            try {
                s = this.toSource(target);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return s;
    }

    default public boolean canToSource(Class<?> source, Object target) {
        return BoxedTypeUtil.isAssignable(source, this.sourceType()) && BoxedTypeUtil.isInstance(this.targetType(), target);
    }

    default public boolean canToTarget(Class<?> target, Object source) {
        return BoxedTypeUtil.isAssignable(this.targetType(), target) && BoxedTypeUtil.isInstance(this.sourceType(), source);
    }

    default public boolean canToSource(Object target) {
        return BoxedTypeUtil.isInstance(this.targetType(), target);
    }

    default public boolean canToTarget(Object source) {
        return BoxedTypeUtil.isInstance(this.sourceType(), source);
    }

    default public BiConvertor<T, S> reverseBiConvertor() {
        final BiConvertor thiz = this;
        return new BiConvertor<T, S>(){

            @Override
            @NotNull
            public Class<T> sourceType() {
                return thiz.targetType();
            }

            @Override
            @NotNull
            public Class<S> targetType() {
                return thiz.sourceType();
            }

            @Override
            @Nullable
            public S toTarget(T t) {
                return thiz.toSource(t);
            }

            @Override
            @Nullable
            public T toSource(S s) {
                return thiz.toTarget(s);
            }

            @Override
            public BiConvertor<S, T> reverseBiConvertor() {
                return thiz;
            }
        };
    }

    default public <R> BiConvertor<S, R> compose(final BiConvertor<T, R> that) {
        final BiConvertor thiz = this;
        return new BiConvertor<S, R>(){

            @Override
            @NotNull
            public Class<S> sourceType() {
                return thiz.sourceType();
            }

            @Override
            @NotNull
            public Class<R> targetType() {
                return that.targetType();
            }

            @Override
            @Nullable
            public R toTarget(S s) {
                Object t = thiz.toTarget(s);
                return t == null ? null : (Object)that.toTarget(t);
            }

            @Override
            @Nullable
            public S toSource(R r) {
                Object t = that.toSource(r);
                return t == null ? null : (Object)thiz.toSource(t);
            }
        };
    }

    public static <A, B> BiConvertor<A, B> of(final Class<A> ca, final Class<B> cb, final Function<? super A, ? extends B> a2b, final Function<? super B, ? extends A> b2a) {
        return new BiConvertor<A, B>(){

            @Override
            @NotNull
            public Class<A> sourceType() {
                return ca;
            }

            @Override
            @NotNull
            public Class<B> targetType() {
                return cb;
            }

            @Override
            @Nullable
            public B toTarget(A a) {
                return a == null ? null : (Object)a2b.apply(a);
            }

            @Override
            @Nullable
            public A toSource(B b) {
                return b == null ? null : (Object)b2a.apply(b);
            }
        };
    }
}

