/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.mirana.code;

import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Supplier;
import net.jcip.annotations.ThreadSafe;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ThreadSafe
public class LeapCode {
    public static final long MAX_NUMBER = Long.MAX_VALUE;
    public static final long MIN_NUMBER = 0L;
    private static final int A9 = 9;
    private final char[] dict22 = new char[22];
    private final char[] dict26 = new char[26];
    private final char[] dict32 = new char[32];
    private final Supplier<Random> random;

    public LeapCode() {
        this("BY2AH0IC9SX4UTV7GP5LNR6FK1WOE8ZQD3JM");
    }

    public LeapCode(@NotNull String seed) {
        this(seed, ThreadLocalRandom::current);
    }

    public LeapCode(@NotNull String seed, Random rand) {
        this(seed, () -> rand);
    }

    public LeapCode(@NotNull String seed, Supplier<Random> rand) {
        int max = 32;
        int idx32 = 0;
        int idx26 = 0;
        int idx24 = 0;
        int len = seed.length();
        for (int i = 0; i < len && idx32 < max; ++i) {
            char c = seed.charAt(i);
            if (c >= 'a' && c <= 'z') {
                c = (char)(c - 32);
            }
            if (this.find(this.dict32, idx32, c) >= 0) continue;
            if (c >= '0' && c <= '9') {
                this.dict32[idx32++] = c;
                continue;
            }
            if (c < 'A' || c > 'Z') continue;
            this.dict26[idx26++] = c;
            if (c == 'U' || c == 'O' || c == 'I' || c == 'L') continue;
            this.dict32[idx32++] = c;
            this.dict22[idx24++] = c;
        }
        if (idx32 != max) {
            throw new IllegalArgumentException("seed=" + seed + " need " + max + " chars, [0-9A-Z]");
        }
        this.random = rand;
    }

    @NotNull
    public String encode26(long number) {
        return this.encode(26, number, -1);
    }

    @NotNull
    public String encode32(long number) {
        return this.encode(32, number, -1);
    }

    @NotNull
    public String encode26(long number, int len) {
        return this.encode(26, number, len);
    }

    @NotNull
    public String encode32(long number, int len) {
        return this.encode(32, number, len);
    }

    @NotNull
    public String encode(int base, long number, int len) {
        int off1;
        char[] dict;
        StringBuilder buff = new StringBuilder(Math.max(len, 16));
        if (base == 26) {
            dict = this.dict26;
            off1 = (int)(number % 9L);
            buff.append(this.dict22[off1]);
            number /= 9L;
        } else if (base == 32) {
            int mod = this.dict22.length - 9;
            dict = this.dict32;
            off1 = (int)(number % (long)mod);
            buff.append(this.dict22[off1 + 9]);
            number /= (long)mod;
        } else {
            throw new IllegalArgumentException("base must one of (26,32)");
        }
        while (number > 0L) {
            int idx = (int)(number & 0xFL);
            number >>>= 4;
            buff.append(dict[off1 + idx]);
        }
        int bln = buff.length();
        if (bln >= len) {
            return buff.toString();
        }
        int off2 = off1 + 16;
        int ln = dict.length - 16;
        int[] uq = new int[ln / 2];
        Random rand = this.random.get();
        int pt = 0;
        int rnd = rand.nextInt() & Integer.MAX_VALUE;
        while (bln < len) {
            int p;
            int idx = -1;
            block2: while (idx < 0) {
                idx = rnd % ln;
                if ((rnd /= ln) <= 0) {
                    rnd = rand.nextInt() & Integer.MAX_VALUE;
                }
                for (int i : uq) {
                    if (idx != i) continue;
                    idx = -1;
                    continue block2;
                }
            }
            uq[pt % uq.length] = idx;
            if (idx >= off1 && (idx = off2 + idx) >= dict.length) {
                idx %= dict.length;
            }
            if ((p = rnd % (bln = buff.length())) > 0) {
                buff.insert(p, dict[idx]);
            } else {
                buff.append(dict[idx]);
            }
            ++pt;
        }
        return buff.toString();
    }

    public long decode(@Nullable String value) {
        if (value == null) {
            return Long.MIN_VALUE;
        }
        return this.decode(value, 0, value.length());
    }

    public long decode(@Nullable CharSequence value, int off, int len) {
        int off1;
        boolean b32;
        char[] dict;
        if (value == null || len <= 1 || off < 0 || value.length() < len) {
            return Long.MIN_VALUE;
        }
        char f = value.charAt(off);
        int f1 = this.find(this.dict22, this.dict22.length, f >= 'a' && f <= 'z' ? (char)(f - 32) : f);
        if (f1 < 0) {
            return Long.MIN_VALUE;
        }
        if (f1 < 9) {
            dict = this.dict26;
            b32 = false;
            off1 = f1;
        } else {
            dict = this.dict32;
            b32 = true;
            off1 = f1 - 9;
        }
        int off2 = off1 + 16;
        long number = 0L;
        int pos = 0;
        for (int i = off + 1; i < len; ++i) {
            long v;
            int c = value.charAt(i);
            if (c >= 97 && c <= 122) {
                c = (char)(c - 32);
            } else if (c < 48 || c > 57 && c < 65 || c > 90) continue;
            if (b32) {
                if (c == 79) {
                    c = 48;
                } else if (c == 73 || c == 76) {
                    c = 49;
                }
            }
            if ((v = (long)this.find(dict, dict.length, (char)c)) < (long)off1 || v >= (long)off2) continue;
            number |= v - (long)off1 << pos;
            pos += 4;
        }
        number = dict == this.dict32 ? number * (long)(this.dict22.length - 9) + (long)off1 : number * 9L + (long)off1;
        return number;
    }

    private int find(char[] dict, int max, char c) {
        for (int j = 0; j < max; ++j) {
            if (dict[j] != c) continue;
            return j;
        }
        return -1;
    }
}

