/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.mirana.img;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import pro.fessional.mirana.img.ImageIoFix;

public class ZoomRotateCrop {
    public static BufferedImage exec(InputStream photo, Para para) throws IOException {
        if (photo == null) {
            throw new NullPointerException("photo is null");
        }
        if (para == null) {
            throw new NullPointerException("para is null");
        }
        BufferedImage photoImg = ImageIoFix.read(photo);
        if (para.flipX && !para.flipY) {
            photoImg = ZoomRotateCrop.flip(photoImg, true);
        }
        if (!para.flipX && para.flipY) {
            photoImg = ZoomRotateCrop.flip(photoImg, false);
        }
        if (para.rotate % 360 != 0) {
            photoImg = ZoomRotateCrop.rotate(photoImg, para.rotate);
        }
        photoImg = ZoomRotateCrop.cropZoom(photoImg, para);
        return photoImg;
    }

    public static BufferedImage cropZoom(BufferedImage image, Para para) {
        BufferedImage result = new BufferedImage(para.viewW, para.viewH, image.getType());
        Graphics2D g = result.createGraphics();
        BufferedImage subImg = image;
        if (para.cropW > 0 && para.cropH > 0) {
            subImg = image.getSubimage(para.cropX, para.cropY, para.cropW, para.cropH);
        }
        g.drawImage(subImg.getScaledInstance(para.viewW, para.viewH, 4), 0, 0, null);
        g.dispose();
        return result;
    }

    public static BufferedImage flip(BufferedImage image, boolean isFlipX) {
        int width = image.getWidth();
        int height = image.getHeight();
        BufferedImage result = new BufferedImage(width, height, image.getType());
        Graphics2D g = result.createGraphics();
        if (isFlipX) {
            g.drawImage(image, 0, 0, width, height, 0, height, width, 0, null);
        } else {
            g.drawImage(image, 0, 0, width, height, width, 0, 0, height, null);
        }
        g.dispose();
        return result;
    }

    public static BufferedImage rotate(BufferedImage image, int degree) {
        if ((degree %= 360) < 0) {
            degree = 360 + degree;
        }
        double angle = Math.toRadians(degree);
        double sin = Math.abs(Math.sin(angle));
        double cos = Math.abs(Math.cos(angle));
        int oldW = image.getWidth();
        int oldH = image.getHeight();
        int newW = (int)Math.floor((double)oldW * cos + (double)oldH * sin);
        int newH = (int)Math.floor((double)oldH * cos + (double)oldW * sin);
        BufferedImage result = new BufferedImage(newW, newH, image.getType());
        Graphics2D g = result.createGraphics();
        g.translate((newW - oldW) / 2, (newH - oldH) / 2);
        g.rotate(angle, (double)oldW / 2.0, (double)oldH / 2.0);
        g.drawRenderedImage(image, null);
        g.dispose();
        return result;
    }

    public static class Para {
        public boolean flipX;
        public boolean flipY;
        public int rotate;
        public int cropX;
        public int cropY;
        public int cropW;
        public int cropH;
        public int viewW;
        public int viewH;
    }
}

