/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.mirana.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;

public class Exec {
    public static int run(File workDir, StringBuilder out, List<String> cmd) {
        BiConsumer<Std, String> handler = (std, s) -> {
            if (std == Std.OUT) {
                if (out.length() > 0) {
                    out.append('\n');
                }
                out.append((String)s);
            }
        };
        return Exec.run(workDir, handler, cmd);
    }

    public static int run(File workDir, StringBuilder out, String ... cmd) {
        BiConsumer<Std, String> handler = (std, s) -> {
            if (std == Std.OUT) {
                if (out.length() > 0) {
                    out.append('\n');
                }
                out.append((String)s);
            }
        };
        return Exec.run(workDir, handler, cmd);
    }

    public static int run(File workDir, List<String> out, List<String> cmd) {
        BiConsumer<Std, String> handler = (std, s) -> {
            if (std == Std.OUT) {
                out.add((String)s);
            }
        };
        return Exec.run(workDir, handler, cmd);
    }

    public static int run(File workDir, List<String> out, String ... cmd) {
        BiConsumer<Std, String> handler = (std, s) -> {
            if (std == Std.OUT) {
                out.add((String)s);
            }
        };
        return Exec.run(workDir, handler, cmd);
    }

    public static int run(File workDir, BiConsumer<Std, String> handler, List<String> cmd) {
        ProcessBuilder builder = new ProcessBuilder(cmd).directory(workDir);
        return Exec.run(builder, handler);
    }

    public static int run(File workDir, BiConsumer<Std, String> handler, String ... cmd) {
        ProcessBuilder builder = new ProcessBuilder(cmd).directory(workDir);
        return Exec.run(builder, handler);
    }

    public static int run(ProcessBuilder builder, BiConsumer<Std, String> handler) {
        Process p = null;
        try {
            p = builder.start();
            if (handler != null) {
                String ln;
                InputStream out = p.getInputStream();
                InputStream err = p.getErrorStream();
                BufferedReader ord = new BufferedReader(new InputStreamReader(out, StandardCharsets.UTF_8));
                BufferedReader erd = new BufferedReader(new InputStreamReader(err, StandardCharsets.UTF_8));
                while (p.isAlive()) {
                    if (err.available() > 0 && (ln = erd.readLine()) != null) {
                        handler.accept(Std.ERR, ln);
                    }
                    if (out.available() <= 0 || (ln = ord.readLine()) == null) continue;
                    handler.accept(Std.OUT, ln);
                }
                while ((ln = erd.readLine()) != null) {
                    handler.accept(Std.ERR, ln);
                }
                while ((ln = ord.readLine()) != null) {
                    handler.accept(Std.OUT, ln);
                }
            }
            int out = p.waitFor();
            return out;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        finally {
            if (p != null) {
                p.destroy();
            }
        }
    }

    public static List<String> arg(String line) {
        if (line == null || line.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> args = new ArrayList<String>();
        int len = line.length();
        StringBuilder buf = new StringBuilder(len);
        char qto = '\u0000';
        boolean esc = false;
        for (int i = 0; i < len; ++i) {
            char c = line.charAt(i);
            if (c == '\\') {
                if (esc) {
                    buf.append(c);
                    esc = false;
                    continue;
                }
                esc = true;
                continue;
            }
            if (c == '\"' || c == '\'') {
                if (esc) {
                    buf.append(c);
                    esc = false;
                    continue;
                }
                if (qto == '\u0000') {
                    qto = c;
                    continue;
                }
                if (qto == c) {
                    args.add(buf.toString());
                    buf.setLength(0);
                    qto = '\u0000';
                    continue;
                }
                buf.append(c);
                continue;
            }
            if (c == ' ' || c == '\t') {
                if (qto > '\u0000') {
                    buf.append(c);
                    continue;
                }
                if (buf.length() <= 0) continue;
                args.add(buf.toString());
                buf.setLength(0);
                continue;
            }
            if (esc) {
                buf.append('\\');
                esc = false;
            }
            buf.append(c);
        }
        if (buf.length() > 0) {
            if (esc) {
                buf.append('\\');
            }
            args.add(buf.toString());
        }
        return args;
    }

    public static enum Std {
        OUT,
        ERR;

    }
}

