/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.mirana.page;

import java.beans.Transient;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pro.fessional.mirana.data.CodeEnum;
import pro.fessional.mirana.data.R;
import pro.fessional.mirana.i18n.I18nAware;
import pro.fessional.mirana.page.PageQuery;
import pro.fessional.mirana.page.PageUtil;

public class PageResult<E>
extends R<Collection<E>>
implements Iterable<E> {
    private static final long serialVersionUID = 19791023L;
    private final List<E> empty = Collections.emptyList();
    private int page = 1;
    private int size = 1;
    private String sort = "";
    private int totalPage = 0;
    private int totalData = 0;
    private Map<String, Object> meta = null;

    public PageResult() {
        this.setData(this.empty);
    }

    public int getPage() {
        return this.page;
    }

    @Contract(value="_->this")
    public PageResult<E> setPage(int page) {
        this.page = Math.max(page, 1);
        return this;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    @Nullable
    public String getSort() {
        return this.sort;
    }

    @Contract(value="_->this")
    public PageResult<E> setSort(String sort) {
        this.sort = sort;
        return this;
    }

    public int getTotalPage() {
        return this.totalPage;
    }

    public void setTotalPage(int totalPage) {
        this.totalPage = totalPage;
    }

    public int getTotalData() {
        return this.totalData;
    }

    public void setTotalData(int totalData) {
        this.totalData = totalData;
    }

    @Transient
    @NotNull
    public List<E> toList() {
        Object data = this.getData();
        if (data instanceof List) {
            return (List)data;
        }
        return new ArrayList(data);
    }

    @Contract(value="_,_->this")
    public PageResult<E> setTotalInfo(int totalData, int pageSize) {
        this.size = Math.max(pageSize, 1);
        this.totalData = Math.max(totalData, 0);
        this.totalPage = PageUtil.totalPage(totalData, pageSize);
        return this;
    }

    @Override
    @Contract(value="_->this")
    public PageResult<E> setData(Collection<E> ds) {
        if (ds == null || ds.isEmpty()) {
            super.setData(this.empty);
        } else {
            super.setData(ds);
        }
        return this;
    }

    @Override
    @NotNull
    public Collection<E> getData() {
        List<E> data = (List<E>)super.getData();
        return data == null ? this.empty : data;
    }

    @Override
    @Contract(value="_->this")
    public PageResult<E> setSuccess(boolean success) {
        super.setSuccess(success);
        return this;
    }

    @Override
    @Contract(value="_->this")
    public PageResult<E> setMessage(String message) {
        super.setMessage(message);
        return this;
    }

    @Override
    @Contract(value="_,_->this")
    public PageResult<E> setI18nMessage(CodeEnum ce, Object ... arg) {
        super.setI18nMessage(ce, arg);
        return this;
    }

    @Override
    @Contract(value="_->this")
    public PageResult<E> setI18nMessage(I18nAware message) {
        super.setI18nMessage(message);
        return this;
    }

    @Override
    @Contract(value="_,_->this")
    public PageResult<E> setI18nMessage(String i18nCode, Object ... args) {
        super.setI18nMessage(i18nCode, args);
        return this;
    }

    @Override
    @Contract(value="_->this")
    public PageResult<E> setCode(String code) {
        super.setCode(code);
        return this;
    }

    @Override
    @Contract(value="_->this")
    public R<Collection<E>> setCode(CodeEnum code) {
        super.setCode(code);
        return this;
    }

    @Override
    @Contract(value="_->this")
    public PageResult<E> setCause(Object cause) {
        super.setCause(cause);
        return this;
    }

    @Contract(value="_->this")
    public PageResult<E> addData(E e) {
        if (e != null) {
            ArrayList<E> data = this.getData();
            if (data == this.empty) {
                data = new ArrayList<E>(this.size > 0 ? this.size : 20);
            }
            data.add(e);
        }
        return this;
    }

    @Contract(value="_->this")
    public PageResult<E> addData(Collection<E> ds) {
        if (ds != null && !ds.isEmpty()) {
            ArrayList<E> data = this.getData();
            if (data == this.empty) {
                data = new ArrayList<E>(this.size > 0 ? this.size : 20);
            }
            data.addAll(ds);
        }
        return this;
    }

    @Override
    public boolean hasData() {
        Object data = this.getData();
        return !data.isEmpty();
    }

    @Override
    @NotNull
    public Iterator<E> iterator() {
        Object data = this.getData();
        return data.iterator();
    }

    public Map<String, ?> getMeta() {
        return this.meta;
    }

    @Contract(value="_->this")
    public PageResult<E> setMeta(Map<String, Object> meta) {
        this.meta = meta;
        return this;
    }

    @Contract(value="_,_->this")
    public PageResult<E> addMeta(String key, Object value) {
        if (this.meta == null) {
            this.meta = new HashMap<String, Object>();
        }
        this.meta.put(key, value);
        return this;
    }

    @Transient
    public <T> T getMeta(String key) {
        return (T)(this.meta == null ? null : this.meta.get(key));
    }

    public <T> PageResult<T> into(Function<E, T> fun) {
        List<E> es = this.toList();
        ArrayList<T> dd = new ArrayList<T>(es.size());
        for (E e : es) {
            dd.add(fun.apply(e));
        }
        return new PageResult<E>().setPage(this.page).setTotalInfo(this.totalData, this.size).setData(dd).setSuccess(this.success);
    }

    @Override
    public String toString() {
        return "PageResult{success=" + this.success + ", message='" + this.message + '\'' + ", code='" + this.code + '\'' + ", data=" + this.data + ", page=" + this.page + ", size=" + this.size + ", sort='" + this.sort + '\'' + ", totalPage=" + this.totalPage + ", totalData=" + this.totalData + ", meta=" + this.meta + '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PageResult)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PageResult that = (PageResult)o;
        return this.page == that.page && this.size == that.size && this.totalPage == that.totalPage && this.totalData == that.totalData && Objects.equals(this.empty, that.empty) && Objects.equals(this.sort, that.sort) && Objects.equals(this.meta, that.meta);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.empty, this.page, this.size, this.sort, this.totalPage, this.totalData, this.meta);
    }

    public static <T> PageResult<T> ok(int total, Collection<T> data, PageQuery pg) {
        return new PageResult().setPage(pg.getPage()).setTotalInfo(total, pg.getSize()).setSort(pg.getSort()).setData(data).setSuccess(true);
    }

    public static <T> PageResult<T> ok(int total, Collection<T> data, int page, int size) {
        return new PageResult().setPage(page).setTotalInfo(total, size).setData(data).setSuccess(true);
    }

    public static <T> PageResult<T> empty() {
        return new PageResult().setPage(1).setTotalInfo(0, 1).setSuccess(true);
    }
}

