/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.mirana.stat;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import javax.sql.DataSource;
import pro.fessional.mirana.best.Param;
import pro.fessional.mirana.cast.StringCastUtil;
import pro.fessional.mirana.io.Exec;

public class GitStat {
    private static final List<String> LOG_PARA = Arrays.asList("--all", "--pretty=##%H,%an,%ai,%s", "--numstat");
    public static final String STAT_WEEK_YEAR = "YYYY ww";
    public static final String STAT_WEEK = "e EEE";
    public static final String STAT_MONTH_YEAR = "yyyy-MM";
    public static final String STAT_MONTH = "MM";
    public static final String STAT_DATE_FULL = "yyyy-MM-dd";
    public static final String STAT_DATE = "dd";
    public static final String STAT_HOUR = "HH";

    public static List<S> logAll(File workDir, String since, String until) {
        ArrayList<String> para = new ArrayList<String>(2);
        if (since != null && !since.isEmpty()) {
            para.add("--since=" + since);
        }
        if (until != null && !until.isEmpty()) {
            para.add("--until=" + until);
        }
        return GitStat.logAll(workDir, para);
    }

    public static List<S> logAll(File workDir, List<String> para) {
        String s2;
        String[] pts;
        StringBuilder sb = new StringBuilder();
        Exec.run(workDir, sb, "git", "rev-parse", "--show-toplevel");
        String repo = sb.length() > 0 ? ((pts = (s2 = sb.toString().trim()).split("[/\\\\]+")).length > 0 ? pts[pts.length - 1].trim() : s2) : "";
        ArrayList<String> cmd = new ArrayList<String>(16);
        cmd.add("git");
        cmd.add("log");
        cmd.addAll(LOG_PARA);
        if (para != null) {
            cmd.addAll(para);
        }
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss Z");
        ArrayList<S> result = new ArrayList<S>();
        AtomicReference root = new AtomicReference();
        BiConsumer<Exec.Std, String> handler = (std, s) -> {
            if (std == Exec.Std.ERR) {
                throw new IllegalStateException((String)s);
            }
            if (s.startsWith("##")) {
                String[] pt = s.split(",", 4);
                S f = new S();
                f.originRepo = repo;
                f.commitHash = pt[0].substring(2);
                f.authorName = pt[1];
                f.authorDate = LocalDateTime.parse(pt[2], dtf);
                f.commitInfo = pt[3];
                root.set(f);
            } else {
                String[] pt = s.split("\t", 3);
                if (pt.length != 3) {
                    return;
                }
                S r = (S)root.get();
                S f = new S();
                f.originRepo = r.originRepo;
                f.commitHash = r.commitHash;
                f.authorName = r.authorName;
                f.authorDate = r.authorDate;
                f.commitInfo = r.commitInfo;
                result.add(f);
                f.linenumAdd = StringCastUtil.asInt(pt[0], 0);
                f.linenumDel = StringCastUtil.asInt(pt[1], 0);
                String fl = pt[2];
                int no = fl.indexOf("=>");
                if (no > 0) {
                    int p1 = fl.indexOf("{");
                    if (p1 < 0) {
                        f.commitFile = GitStat.trimFile(fl.substring(0, no).trim());
                        f.renameFile = GitStat.trimFile(fl.substring(no + 2).trim());
                    } else {
                        int p2 = fl.indexOf("}", no);
                        String s1 = fl.substring(0, p1);
                        String s2 = fl.substring(p1 + 1, no).trim();
                        String s3 = fl.substring(no + 2, p2).trim();
                        String s4 = fl.substring(p2 + 1);
                        f.commitFile = GitStat.trimFile(s1, s3, s4);
                        f.renameFile = GitStat.trimFile(s1, s2, s4);
                    }
                } else {
                    f.commitFile = GitStat.trimFile(fl);
                }
            }
        };
        Exec.run(workDir, handler, cmd);
        return result;
    }

    public static String trimFile(String ... str) {
        StringBuilder out = new StringBuilder();
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        for (String s : str) {
            if (s == null || s.isEmpty()) continue;
            int len = s.length();
            for (int i = 0; i < len; ++i) {
                char c = s.charAt(i);
                if (c == '\\') {
                    if (i + 3 < len) {
                        char c1 = s.charAt(i + 1);
                        char c2 = s.charAt(i + 2);
                        char c3 = s.charAt(i + 3);
                        if (!Character.isDigit(c1) || !Character.isDigit(c2) || !Character.isDigit(c3)) continue;
                        int octal = (c1 - 48) * 64 + (c2 - 48) * 8 + (c3 - 48);
                        buf.write(octal - 256);
                        i += 3;
                        continue;
                    }
                    out.append(c);
                    continue;
                }
                if (buf.size() > 0) {
                    try {
                        out.append(buf.toString("UTF8"));
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        // empty catch block
                    }
                    buf.reset();
                }
                if (i == 0 && c == '/' && out.length() > 0 && out.charAt(out.length() - 1) == '/') continue;
                out.append(c);
            }
            if (buf.size() <= 0) continue;
            try {
                out.append(buf.toString("UTF8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            buf.reset();
        }
        if (out.length() > 2 && out.charAt(0) == '\"' && out.charAt(out.length() - 1) == '\"') {
            return out.substring(1, out.length() - 1);
        }
        return out.toString();
    }

    public static void saveMysql(List<S> infos, String table, DataSource dataSource) {
        if (infos.isEmpty()) {
            return;
        }
        if (table == null) {
            table = "git_log_mirana";
        }
        try (Connection conn = dataSource.getConnection();){
            Statement stm = conn.createStatement();
            boolean not = true;
            try (ResultSet rs = stm.executeQuery("SHOW TABLES LIKE '" + table + "'");){
                if (rs.next()) {
                    not = false;
                }
            }
            if (not) {
                stm.execute("CREATE TABLE `" + table + "` (\n  `id` int(11) NOT NULL AUTO_INCREMENT,\n  `origin_repo` varchar(100) NOT NULL DEFAULT '' COMMENT 'repo name',\n  `commit_hash` varchar(40) NOT NULL DEFAULT '' COMMENT 'commit hash',\n  `author_name` varchar(50) NOT NULL DEFAULT '' COMMENT 'commiter',\n  `author_date` datetime NOT NULL DEFAULT '1000-01-01' COMMENT 'commit date',\n  `commit_info` varchar(200) NOT NULL DEFAULT '' COMMENT 'commit message',\n  `linenum_add` int(11) NOT NULL DEFAULT 0 COMMENT 'lines of add',\n  `linenum_del` int(11) NOT NULL DEFAULT 0 COMMENT 'lines of del',\n  `commit_file` varchar(200) NOT NULL DEFAULT '' COMMENT 'commit file',\n  `rename_file` varchar(200) NOT NULL DEFAULT '' COMMENT 'rename file',\n  PRIMARY KEY (`id`),\n  UNIQUE KEY `uq_repo_hash_file` (`origin_repo`,`commit_hash`,`commit_file`)\n) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4");
                stm.close();
            }
            PreparedStatement pstm = conn.prepareStatement("INSERT IGNORE INTO " + table + "(origin_repo,commit_hash,author_name,author_date,commit_info,linenum_add,linenum_del,commit_file,rename_file) VALUES(?,?,?,?,?,?,?,?,?)");
            infos.sort(Comparator.comparing(o -> o.authorDate));
            int count = 1;
            for (S s : infos) {
                pstm.setString(1, s.originRepo);
                pstm.setString(2, s.commitHash);
                pstm.setString(3, s.authorName);
                pstm.setObject(4, s.authorDate);
                pstm.setString(5, s.commitInfo);
                pstm.setInt(6, s.linenumAdd);
                pstm.setInt(7, s.linenumDel);
                pstm.setString(8, s.commitFile);
                pstm.setString(9, s.renameFile);
                pstm.addBatch();
                if (count++ % 2000 != 0) continue;
                pstm.executeBatch();
            }
            pstm.executeBatch();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static void stat(List<S> infos, String pattern, Map<String, String> alias) {
        GitStat.stat(infos, pattern, alias, false);
    }

    public static void stat(List<S> infos, String pattern, Map<String, String> alias, boolean han2) {
        GitStat.stat(new PrintWriter(System.out), infos, pattern, alias, han2);
    }

    /*
     * Exception decompiling
     */
    public static void stat(@Param.Out PrintWriter out, List<S> infos, String pattern, Map<String, String> alias, boolean han2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void main(String[] args) {
        System.out.println("usage: [git-dir:File] [git-args:String]");
        File dir = new File(args.length > 0 ? args[0] : ".");
        ArrayList<String> para = null;
        if (args.length > 1) {
            para = new ArrayList<String>(args.length);
            para.addAll(Arrays.asList(args).subList(1, args.length));
        }
        List<S> infos = GitStat.logAll(dir, para);
        GitStat.stat(infos, STAT_WEEK_YEAR, null, false);
    }

    private static /* synthetic */ C lambda$stat$6(String s1) {
        return new C();
    }

    private static class C {
        private final HashSet<String> commits = new HashSet();
        private final HashSet<String> cofiles = new HashSet();
        private int linenumAdd = 0;
        private int linenumDel = 0;

        private C() {
        }

        static /* synthetic */ HashSet access$100(C x0) {
            return x0.commits;
        }

        static /* synthetic */ HashSet access$200(C x0) {
            return x0.cofiles;
        }

        static /* synthetic */ int access$300(C x0) {
            return x0.linenumAdd;
        }

        static /* synthetic */ int access$302(C x0, int x1) {
            x0.linenumAdd = x1;
            return x0.linenumAdd;
        }

        static /* synthetic */ int access$400(C x0) {
            return x0.linenumDel;
        }

        static /* synthetic */ int access$402(C x0, int x1) {
            x0.linenumDel = x1;
            return x0.linenumDel;
        }
    }

    public static class S {
        public String originRepo = "";
        public String commitHash = "";
        public String commitFile = "";
        public String authorName = "";
        public LocalDateTime authorDate;
        public String commitInfo = "";
        public String renameFile = "";
        public int linenumAdd = 0;
        public int linenumDel = 0;

        public String toString() {
            return "{originRepo='" + this.originRepo + '\'' + ", commitHash='" + this.commitHash + '\'' + ", authorName='" + this.authorName + '\'' + ", authorDate=" + this.authorDate + ", commitInfo='" + this.commitInfo + '\'' + ", linenumAdd=" + this.linenumAdd + ", linenumDel=" + this.linenumDel + ", commitFile='" + this.commitFile + '\'' + ", renameFile='" + this.renameFile + '\'' + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            S s = (S)o;
            return this.originRepo.equals(s.originRepo) && this.commitHash.equals(s.commitHash) && this.commitFile.equals(s.commitFile);
        }

        public int hashCode() {
            return Objects.hash(this.originRepo, this.commitHash, this.commitFile);
        }
    }
}

