/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.mirana.text;

import org.jetbrains.annotations.NotNull;
import pro.fessional.mirana.data.Null;

public class CaseSwitcher {
    @NotNull
    public static String toCase(Case cas, CharSequence str) {
        if (cas == null) {
            return Null.notNull(str);
        }
        int len = str.length();
        boolean isWeak = true;
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            if (c != '.' && c != '_' && c != '-') continue;
            isWeak = false;
            break;
        }
        StringBuilder sb = new StringBuilder(len + 10);
        if (isWeak) {
            int up = 0;
            for (int i = 0; i < len; ++i) {
                char c = str.charAt(i);
                if (c >= 'A' && c <= 'Z') {
                    if (++up == 1 && i > 0) {
                        if (cas == Case.Dot) {
                            sb.append('.');
                        } else if (cas == Case.Kebab) {
                            sb.append('-');
                        } else if (cas == Case.Snake || cas == Case.Scream) {
                            sb.append('_');
                        }
                    }
                    if (cas == Case.Scream || cas == Case.Pascal && up == 1 || cas == Case.Camel && i > 0 && up == 1) {
                        sb.append(c);
                        continue;
                    }
                    sb.append(Character.toLowerCase(c));
                    continue;
                }
                up = 0;
                if (cas == Case.Scream || cas == Case.Pascal && i == 0) {
                    sb.append(Character.toUpperCase(c));
                    continue;
                }
                sb.append(c);
            }
        } else {
            boolean ed = false;
            for (int i = 0; i < len; ++i) {
                char c = str.charAt(i);
                if (c == '.' || c == '_' || c == '-') {
                    ed = true;
                    continue;
                }
                boolean up = false;
                if (ed) {
                    if (cas == Case.Dot) {
                        sb.append('.');
                    } else if (cas == Case.Kebab) {
                        sb.append('-');
                    } else if (cas == Case.Snake || cas == Case.Scream) {
                        sb.append('_');
                    } else if (cas == Case.Camel || cas == Case.Pascal) {
                        up = true;
                    }
                    ed = false;
                }
                if (up || cas == Case.Scream || cas == Case.Pascal && i == 0) {
                    sb.append(Character.toUpperCase(c));
                    continue;
                }
                sb.append(Character.toLowerCase(c));
            }
        }
        return sb.toString();
    }

    @NotNull
    public static String kebab(CharSequence str) {
        return CaseSwitcher.toCase(Case.Kebab, str);
    }

    @NotNull
    public static String snake(CharSequence str) {
        return CaseSwitcher.toCase(Case.Snake, str);
    }

    @NotNull
    public static String camel(CharSequence str) {
        return CaseSwitcher.toCase(Case.Camel, str);
    }

    @NotNull
    public static String pascal(CharSequence str) {
        return CaseSwitcher.toCase(Case.Pascal, str);
    }

    @NotNull
    public static String dot(CharSequence str) {
        return CaseSwitcher.toCase(Case.Dot, str);
    }

    @NotNull
    public static String scream(CharSequence str) {
        return CaseSwitcher.toCase(Case.Scream, str);
    }

    public static enum Case {
        Snake("snake_case"),
        Camel("camelCase"),
        Kebab("kebab-case"),
        Pascal("PascalCase"),
        Dot("dot.case"),
        Scream("SCREAMING_CASE");

        public final String example;

        private Case(String eg) {
            this.example = eg;
        }
    }
}

