/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.mirana.time;

import java.time.Clock;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.TimeZone;
import org.jetbrains.annotations.NotNull;
import pro.fessional.mirana.evil.TweakingContext;

public class ThreadNow {
    public static final TimeZone UtcTimeZone = TimeZone.getTimeZone("UTC");
    public static final ZoneId UtcZoneId = UtcTimeZone.toZoneId();
    public static final TweakingContext<TimeZone> TweakZone = new TweakingContext<TimeZone>(TimeZone.getDefault());
    public static final TweakingContext<Clock> TweakClock = new TweakingContext<Clock>(Clock.systemDefaultZone());

    public static TimeZone sysTimeZone() {
        return TweakZone.current(true);
    }

    public static ZoneId sysZoneId() {
        return TweakZone.current(true).toZoneId();
    }

    public static TimeZone utcTimeZone() {
        return UtcTimeZone;
    }

    public static ZoneId utcZoneId() {
        return UtcZoneId;
    }

    @NotNull
    public static Clock clock() {
        return TweakClock.current(true);
    }

    public static long millis() {
        return ThreadNow.clock().millis();
    }

    @NotNull
    public static Instant instant() {
        return ThreadNow.clock().instant();
    }

    @NotNull
    public static LocalDate localDate() {
        return LocalDate.now(ThreadNow.clock());
    }

    @NotNull
    public static LocalTime localTime() {
        return LocalTime.now(ThreadNow.clock());
    }

    @NotNull
    public static LocalDateTime localDateTime() {
        return LocalDateTime.now(ThreadNow.clock());
    }

    @NotNull
    public static ZonedDateTime zonedDateTime() {
        return ZonedDateTime.now(ThreadNow.clock());
    }

    @NotNull
    public static OffsetDateTime offsetDateTime() {
        return OffsetDateTime.now(ThreadNow.clock());
    }

    @NotNull
    public static Date utilDate() {
        return new Date(ThreadNow.millis());
    }

    @NotNull
    public static Clock clock(ZoneId zid) {
        return ThreadNow.clock().withZone(zid);
    }

    @NotNull
    public static Instant instant(ZoneId zid) {
        return ThreadNow.clock(zid).instant();
    }

    @NotNull
    public static LocalDate localDate(ZoneId zid) {
        return LocalDate.now(ThreadNow.clock(zid));
    }

    @NotNull
    public static LocalTime localTime(ZoneId zid) {
        return LocalTime.now(ThreadNow.clock(zid));
    }

    @NotNull
    public static LocalDateTime localDateTime(ZoneId zid) {
        return LocalDateTime.now(ThreadNow.clock(zid));
    }

    @NotNull
    public static ZonedDateTime zonedDateTime(ZoneId zid) {
        return ZonedDateTime.now(ThreadNow.clock(zid));
    }

    @NotNull
    public static OffsetDateTime offsetDateTime(ZoneId zid) {
        return OffsetDateTime.now(ThreadNow.clock(zid));
    }

    @NotNull
    public static Date utilDate(ZoneId zid) {
        return Date.from(ThreadNow.instant(zid));
    }
}

