/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.mirana.tk;

import java.security.MessageDigest;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.crypto.Mac;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pro.fessional.mirana.bits.Aes;
import pro.fessional.mirana.bits.Aes256;
import pro.fessional.mirana.bits.Base64;
import pro.fessional.mirana.bits.HmacHelp;
import pro.fessional.mirana.bits.MdHelp;
import pro.fessional.mirana.data.Null;
import pro.fessional.mirana.time.ThreadNow;
import pro.fessional.mirana.tk.AnyTicket;
import pro.fessional.mirana.tk.Ticket;

public class TicketHelp {
    public static SigFun sig(MdHelp help) {
        return new SigFun(help, null);
    }

    public static SigFun sig(MdHelp help, byte[] salt) {
        return new SigFun(help, salt);
    }

    public static SigHmac sig(HmacHelp help) {
        return new SigHmac(help);
    }

    @SafeVarargs
    @Nullable
    public static Ticket parse(String tk, BiFunction<String, String, Ticket.Mutable> ... accept) {
        BiFunction<String, String, Ticket.Mutable> vf;
        if (tk == null) {
            return null;
        }
        int[] pos = new int[]{-1, -1, -1, -1};
        char[] tkn = new char[]{'-', '-', '.', '.'};
        int off = 0;
        int x = tkn.length - 1;
        for (int i = 0; i <= x; ++i) {
            int j = tk.indexOf(tkn[i], off);
            if (j > off) {
                pos[i] = j;
                off = j + 1;
                continue;
            }
            if (i >= x) continue;
            return null;
        }
        if (pos[0] < 0 || pos[1] < pos[0] || pos[2] < pos[1] || pos[3] < pos[2] && pos[3] > 0) {
            return null;
        }
        int pl = pos[3] > 0 ? pos[3] : pos[2];
        String sigData = tk.substring(0, pl);
        String sigPart = tk.substring(pl + 1);
        Ticket.Mutable ticket = null;
        BiFunction<String, String, Ticket.Mutable>[] biFunctionArray = accept;
        int n = biFunctionArray.length;
        for (int i = 0; i < n && (ticket = (vf = biFunctionArray[i]).apply(sigData, sigPart)) == null; ++i) {
        }
        if (ticket == null) {
            return null;
        }
        try {
            ticket.setPubMod(tk.substring(0, pos[0]));
            ticket.setPubDue(Long.parseLong(tk.substring(pos[0] + 1, pos[1])));
            ticket.setPubSeq(Integer.parseInt(tk.substring(pos[1] + 1, pos[2])));
            if (pos[3] > 0) {
                ticket.setBizPart(tk.substring(pos[2] + 1, pos[3]));
            }
            ticket.setSigPart(sigPart);
            return ticket;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static interface Helper<T> {
        @NotNull
        public Ticket encode(int var1, long var2, T var4);

        public T decode(Ticket var1);

        public Ticket.Mutable accept(@NotNull String var1, @NotNull String var2);

        public boolean verify(Ticket var1);
    }

    public static class Builder<T extends Ticket.Mutable> {
        private final T ticket;

        public Builder(T ticket) {
            this.ticket = ticket;
        }

        @Contract(value="_->this")
        public Builder<T> mod(String mod) {
            this.ticket.setPubMod(mod);
            return this;
        }

        @Contract(value="_->this")
        public Builder<T> exp(long exp) {
            this.ticket.setPubDue(exp);
            return this;
        }

        @Contract(value="_,_->this")
        public Builder<T> expAfterNow(long num, TimeUnit unit) {
            this.ticket.setPubDue(unit.toSeconds(num) + ThreadNow.millis() / 1000L);
            return this;
        }

        @Contract(value="_,_->this")
        public Builder<T> expAfter(long num, TimeUnit unit) {
            this.ticket.setPubDue(unit.toSeconds(num) + this.ticket.getPubDue());
            return this;
        }

        @Contract(value="_->this")
        public Builder<T> seq(int seq) {
            this.ticket.setPubSeq(seq);
            return this;
        }

        @Contract(value="->this")
        public Builder<T> seqIncrease() {
            this.ticket.setPubSeq(this.ticket.getPubSeq() + 1);
            return this;
        }

        @Contract(value="_->this")
        public Builder<T> seqAdd(int step) {
            this.ticket.setPubSeq(this.ticket.getPubSeq() + step);
            return this;
        }

        @Contract(value="_->this")
        public Builder<T> biz(String biz) {
            this.ticket.setBizPart(biz);
            return this;
        }

        @Contract(value="->this")
        public Builder<T> bizEmpty() {
            this.ticket.setBizPart("");
            return this;
        }

        @Contract(value="_->this")
        public Builder<T> bizB64(byte[] biz) {
            this.ticket.setBizPart(Base64.encode(biz));
            return this;
        }

        @Contract(value="_->this")
        public Builder<T> bizB64(String biz) {
            this.ticket.setBizPart(Base64.encode(biz));
            return this;
        }

        public Builder<T> bizAes(String biz, String key) {
            return this.bizAes(biz, Aes256.of(key));
        }

        @Contract(value="_,_->this")
        public Builder<T> bizAes(String biz, Aes aes) {
            this.ticket.setBizPart(aes.encode64(biz));
            return this;
        }

        T sig(String sig) {
            this.ticket.setSigPart(sig);
            return this.ticket;
        }

        T sig(Function<String, String> sig) {
            if (this.ticket.getPubMod().isEmpty()) {
                throw new IllegalArgumentException("mod is null");
            }
            if (this.ticket.getSigPart().isEmpty() && sig != null) {
                this.ticket.setSigPart(sig.apply(this.ticket.getSigData()));
            }
            if (this.ticket.getSigPart().isEmpty()) {
                throw new IllegalArgumentException("sig is null");
            }
            return this.ticket;
        }

        T sig(MdHelp help) {
            return this.sig(TicketHelp.sig(help));
        }

        T sig(MdHelp help, byte[] salt) {
            return this.sig(TicketHelp.sig(help, salt));
        }

        T sig(HmacHelp help) {
            return this.sig(TicketHelp.sig(help));
        }
    }

    public static class AnyHelp
    implements Helper<String> {
        public final String pubMod;
        public final Aes aes256;
        public final Function<String, String> sigFun;

        public AnyHelp(String mod, Aes256 aes, Function<String, String> sig) {
            this.pubMod = mod;
            this.aes256 = aes;
            this.sigFun = sig;
        }

        @Override
        @NotNull
        public Ticket encode(int pubSeq, long pubDue, String bizData) {
            AnyTicket tk = new AnyTicket();
            tk.setPubMod(this.pubMod);
            tk.setPubSeq(pubSeq);
            tk.setPubDue(pubDue);
            tk.setBizPart(this.aes256.encode64(bizData));
            tk.setSigPart(this.sigFun.apply(tk.getSigData()));
            return tk;
        }

        @Override
        public String decode(Ticket tk) {
            return tk == null ? null : this.aes256.decode64(tk.getBizPart());
        }

        @Override
        public boolean verify(Ticket tk) {
            if (tk == null) {
                return false;
            }
            String sig = this.sigFun.apply(tk.getSigData());
            return Objects.equals(tk.getSigPart(), sig);
        }

        @Override
        public Ticket.Mutable accept(@NotNull String sigData, @NotNull String sigPart) {
            if (!sigData.startsWith(this.pubMod)) {
                return null;
            }
            String sig = this.sigFun.apply(sigData);
            return sig.equals(sigPart) ? new AnyTicket() : null;
        }
    }

    public static class Ah2Help
    extends AnyHelp {
        public Ah2Help(@NotNull String mod, @NotNull String salt) {
            super(mod, Aes256.of(salt), TicketHelp.sig(HmacHelp.sha256(salt.getBytes())));
        }

        public Ah2Help(@NotNull String salt) {
            this("ah2", salt);
        }
    }

    public static class Ah1Help
    extends AnyHelp {
        public Ah1Help(@NotNull String mod, @NotNull String salt) {
            super(mod, Aes256.of(salt), TicketHelp.sig(HmacHelp.sha1(salt.getBytes())));
        }

        public Ah1Help(@NotNull String salt) {
            this("ah1", salt);
        }
    }

    public static class Am1Help
    extends AnyHelp {
        public Am1Help(@NotNull String mod, @NotNull String salt) {
            super(mod, Aes256.of(salt), TicketHelp.sig(MdHelp.md5, salt.getBytes()));
        }

        public Am1Help(@NotNull String salt) {
            this("am1", salt);
        }
    }

    public static class Am0Help
    extends AnyHelp {
        public Am0Help(@NotNull String mod, @NotNull String salt) {
            super(mod, Aes256.of(salt), TicketHelp.sig(MdHelp.md5));
        }

        public Am0Help(@NotNull String salt) {
            this("am0", salt);
        }
    }

    public static class SigHmac
    implements Function<String, String> {
        private final Supplier<Mac> help;

        public SigHmac(Supplier<Mac> help) {
            this.help = help;
        }

        public SigHmac(HmacHelp help) {
            this.help = help::newOne;
        }

        @Override
        public String apply(String s) {
            Mac md = this.help.get();
            md.update(s.getBytes());
            byte[] digest = md.doFinal();
            return Base64.encode(digest);
        }
    }

    public static class SigFun
    implements Function<String, String> {
        private final Supplier<MessageDigest> supplier;
        private final byte[] salt;

        public SigFun(Supplier<MessageDigest> help, byte[] salt) {
            this.supplier = help;
            this.salt = Null.notNull(salt);
        }

        public SigFun(MdHelp help, byte[] salt) {
            this.supplier = help::newOne;
            this.salt = Null.notNull(salt);
        }

        @Override
        public String apply(String s) {
            MessageDigest md = this.supplier.get();
            md.update(s.getBytes());
            if (this.salt.length > 0) {
                md.update(this.salt);
            }
            byte[] digest = md.digest();
            return Base64.encode(digest);
        }
    }
}

