/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.mirana.cast;

import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pro.fessional.mirana.cast.BiConvertor;

public class EnumConvertor<E extends Enum<E>>
implements BiConvertor<String, E> {
    private final Class<E> targetType;
    private final String splitToken;
    public static final String SPLIT = "#";

    public EnumConvertor(Class<E> targetType) {
        this(targetType, null);
    }

    public EnumConvertor(Class<E> targetType, String token) {
        this.targetType = targetType;
        this.splitToken = token;
    }

    @Override
    @NotNull
    public Class<String> sourceType() {
        return String.class;
    }

    @Override
    @NotNull
    public Class<E> targetType() {
        return this.targetType;
    }

    @Override
    @Nullable
    public E toTarget(String s) {
        return EnumConvertor.str2Enum(this.targetType, s, this.splitToken);
    }

    @Override
    @Nullable
    public String toSource(E e) {
        return EnumConvertor.enum2Str(e, this.splitToken);
    }

    @Contract(value="null->null;!null->!null")
    public static String enum2Str(Enum<?> e) {
        return EnumConvertor.enum2Str(e, null);
    }

    @Contract(value="null,_->null;!null,_->!null")
    public static String enum2Str(Enum<?> e, String spt) {
        if (e == null) {
            return null;
        }
        if (spt == null || spt.isEmpty()) {
            spt = SPLIT;
        }
        return e.getDeclaringClass().getName() + spt + e.name();
    }

    public static <T extends Enum<T>> T str2Enum(Class<T> enu, String str) {
        return EnumConvertor.str2Enum(enu, str, null);
    }

    public static <T extends Enum<T>> T str2Enum(Class<T> enu, String str, String spt) {
        T en = EnumConvertor.str2Enum(str, spt);
        return en == null ? EnumConvertor.parseEnum(enu, str) : en;
    }

    public static Enum<?> str2Enum(String str) {
        return EnumConvertor.str2Enum(str, SPLIT);
    }

    public static <T extends Enum<T>> T str2Enum(String str, String spt) {
        if (str == null) {
            return null;
        }
        int p = spt == null || spt.isEmpty() ? str.lastIndexOf(SPLIT) : str.lastIndexOf(spt);
        return p <= 0 ? null : (T)EnumConvertor.parseEnum(str.substring(0, p), str.substring(p + 1));
    }

    public static <T extends Enum<T>> T parseEnum(String clz, String key) {
        if (clz == null || key == null || clz.isEmpty() || key.isEmpty()) {
            return null;
        }
        try {
            Class<?> enu = Class.forName(clz);
            return (T)Enum.valueOf(enu, key);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("failed to parse enum class=" + clz + ", key=" + key);
        }
    }

    public static <T extends Enum<T>> T parseEnum(Class<T> clz, String key) {
        if (clz == null || key == null || key.isEmpty()) {
            return null;
        }
        return Enum.valueOf(clz, key);
    }
}

