/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.mirana.id;

import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import net.jcip.annotations.ThreadSafe;
import org.jetbrains.annotations.NotNull;
import pro.fessional.mirana.id.LightIdProvider;
import pro.fessional.mirana.id.LightIdUtil;
import pro.fessional.mirana.pain.TimeoutRuntimeException;

@ThreadSafe
public class LightIdBufferedProvider
implements LightIdProvider {
    public static final int MAX_COUNT = 10000;
    public static final int MIN_COUNT = 100;
    public static final int FIX_COUNT = 0;
    public static final int MAX_ERROR = 5;
    public static final long ERR_ALIVE = 120000L;
    public static final long TIME_OUT = 1000L;
    public static final LightIdProvider.Generator GENERATOR = (name, block, timeout) -> LightIdUtil.toId(block, timeout);
    private final ExecutorService executor;
    private final LightIdProvider.Loader loader;
    private final ConcurrentHashMap<String, SegmentBuffer> cache = new ConcurrentHashMap();
    private volatile long loadTimeout = 1000L;
    private volatile int loadMaxError = 5;
    private volatile int loadMaxCount = 10000;
    private volatile int loadMinCount = 100;
    private volatile int loadFixCount = 0;
    private volatile long loadErrAlive = 120000L;
    private volatile LightIdProvider.Generator generator = GENERATOR;

    public LightIdBufferedProvider(@NotNull LightIdProvider.Loader loader) {
        this(loader, new ThreadPoolExecutor(3, 64, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new ThreadFactory(){
            private final AtomicInteger counter = new AtomicInteger(1);

            @Override
            public Thread newThread(@NotNull Runnable r) {
                return new Thread(r, "light-id-buffered-provider-" + this.counter.getAndIncrement());
            }
        }));
    }

    public LightIdBufferedProvider(@NotNull LightIdProvider.Loader loader, @NotNull ExecutorService executor) {
        this.loader = loader;
        this.executor = executor;
    }

    public long getErrAlive() {
        return this.loadErrAlive;
    }

    public long getTimeout() {
        return this.loadTimeout;
    }

    public int getMaxError() {
        return this.loadMaxError;
    }

    public int getMaxCount() {
        return this.loadMaxCount;
    }

    public int getMinCount() {
        return this.loadMinCount;
    }

    public int getFixCount() {
        return this.loadFixCount;
    }

    public LightIdProvider.Generator getGenerator() {
        return this.generator;
    }

    public void setErrAlive(long t) {
        this.loadErrAlive = t;
    }

    public boolean setTimeout(long t) {
        if (t > 0L) {
            this.loadTimeout = t;
            return true;
        }
        return false;
    }

    public boolean setMaxError(int n) {
        if (n >= 0) {
            this.loadMaxError = n;
            return true;
        }
        return false;
    }

    public boolean setMaxCount(int n) {
        if (n >= 0) {
            this.loadMaxCount = n;
            return true;
        }
        return false;
    }

    public boolean setMinCount(int n) {
        if (n >= 0) {
            this.loadMinCount = n;
            return true;
        }
        return false;
    }

    public boolean setFixCount(int n) {
        if (n < 0) {
            return false;
        }
        this.loadFixCount = n;
        return true;
    }

    public void setGenerator(@NotNull LightIdProvider.Generator generator) {
        this.generator = generator;
    }

    public void preload(int block) {
        List<LightIdProvider.Segment> segments = this.loader.preload(block);
        for (LightIdProvider.Segment seg : segments) {
            SegmentBuffer buff = this.load(seg.getBlock(), seg.getName());
            buff.fillSegment(seg);
        }
    }

    public void cleanError(@NotNull String name, int block) {
        this.load(block, name).handleError(null);
    }

    @Override
    public long next(@NotNull String name, int block) {
        return this.load(block, name).nextId(this.loadTimeout);
    }

    @Override
    public long next(@NotNull String name, int block, long timeout) {
        if (timeout <= 0L) {
            timeout = this.loadTimeout;
        }
        return this.load(block, name).nextId(timeout);
    }

    private SegmentBuffer load(int block, String name) {
        return this.cache.computeIfAbsent(name + "@" + block, k -> new SegmentBuffer(name, block));
    }

    private class SegmentBuffer {
        private final String name;
        private final int block;
        private final LinkedList<LightIdProvider.Segment> segmentPool = new LinkedList();
        private final AtomicReference<SegmentStatus> segmentSlot = new AtomicReference<SegmentStatus>(new SegmentStatus());
        private final AtomicBoolean loaderIdle = new AtomicBoolean(true);
        private final AtomicBoolean switchIdle = new AtomicBoolean(true);
        private final AtomicInteger awaitCount = new AtomicInteger(0);
        private final AtomicInteger errorCount = new AtomicInteger(0);
        private final AtomicReference<RuntimeException> errorNewer = new AtomicReference();
        private final AtomicLong errorEpoch = new AtomicLong(0L);

        public SegmentBuffer(String name, int block) {
            this.name = name;
            this.block = block;
        }

        public long nextId(long timeout) {
            this.checkError();
            SegmentStatus slot = this.segmentSlot.get();
            long seq = slot.sequence.getAndIncrement();
            if (seq > slot.footSeq) {
                this.pollSegment(timeout);
                return this.nextId(timeout);
            }
            if (seq > slot.kneeSeq) {
                this.loadSegment(slot.count60s(0), true);
            }
            return LightIdBufferedProvider.this.generator.gen(this.name, this.block, seq);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fillSegment(LightIdProvider.Segment seg) {
            if (seg == null) {
                return;
            }
            String err = null;
            if (seg.getBlock() != this.block) {
                err = "difference block, name=" + this.name + ", block=" + this.block + ",seg.block=" + seg.getBlock();
            } else if (!this.name.equalsIgnoreCase(seg.getName())) {
                err = "difference name, name=" + this.name + ", block=" + this.block + ",seg.name=" + seg.getName();
            } else {
                LinkedList<LightIdProvider.Segment> linkedList = this.segmentPool;
                synchronized (linkedList) {
                    if (!this.segmentPool.isEmpty() && seg.getHead() <= this.segmentPool.getLast().getFoot()) {
                        err = "seg.start must bigger than last.endin, name=" + this.name + ",block=" + this.block;
                    } else {
                        this.segmentPool.addLast(seg);
                    }
                }
            }
            this.handleError(err == null ? null : new IllegalStateException(err));
        }

        public void handleError(RuntimeException e) {
            if (e == null) {
                this.errorCount.set(0);
                this.errorNewer.set(null);
                this.errorEpoch.set(0L);
            } else {
                this.errorCount.incrementAndGet();
                this.errorNewer.set(e);
                this.errorEpoch.set(System.currentTimeMillis());
            }
        }

        private void loadSegment(int count, boolean async) {
            if (this.loaderIdle.compareAndSet(true, false)) {
                if (async) {
                    LightIdBufferedProvider.this.executor.submit(() -> this.loadSegment(count));
                } else {
                    this.loadSegment(count);
                }
            }
        }

        private void loadSegment(int count) {
            try {
                LightIdProvider.Segment seg = LightIdBufferedProvider.this.loader.require(this.name, this.block, count, false);
                this.handleError(null);
                this.fillSegment(seg);
            }
            catch (RuntimeException e) {
                this.handleError(e);
            }
            finally {
                this.loaderIdle.set(true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void pollSegment(long timeout) {
            block25: {
                long throwMs = System.currentTimeMillis() + timeout;
                if (!this.switchIdle.compareAndSet(true, false)) {
                    try {
                        AtomicBoolean atomicBoolean = this.switchIdle;
                        synchronized (atomicBoolean) {
                            if (this.switchIdle.get()) {
                                return;
                            }
                            this.awaitCount.incrementAndGet();
                            this.switchIdle.wait(timeout);
                        }
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new IllegalStateException("dont interrupt me", e);
                    }
                    long now = System.currentTimeMillis();
                    if (now > throwMs) {
                        throw new TimeoutRuntimeException("waiting segment pollTimeout=" + (now - throwMs + timeout));
                    }
                    return;
                }
                try {
                    long now;
                    do {
                        SegmentStatus status;
                        this.checkError();
                        LinkedList<LightIdProvider.Segment> linkedList = this.segmentPool;
                        synchronized (linkedList) {
                            LightIdProvider.Segment seg = this.segmentPool.poll();
                            if (seg == null) {
                                status = this.segmentSlot.get();
                            } else {
                                this.segmentSlot.set(new SegmentStatus(seg));
                                status = null;
                            }
                        }
                        if (status == null) {
                            break block25;
                        }
                        this.loadSegment(status.count60s(this.awaitCount.get()), false);
                    } while ((now = System.currentTimeMillis()) <= throwMs);
                    throw new TimeoutRuntimeException("switching segment loadTimeout=" + (now - throwMs + timeout));
                }
                finally {
                    AtomicBoolean atomicBoolean = this.switchIdle;
                    synchronized (atomicBoolean) {
                        this.switchIdle.set(true);
                        this.awaitCount.set(0);
                        this.switchIdle.notifyAll();
                    }
                }
            }
        }

        private void checkError() {
            long lf = LightIdBufferedProvider.this.loadErrAlive;
            long ep = this.errorEpoch.get();
            if (lf > 0L && ep > 0L && System.currentTimeMillis() - ep > lf) {
                this.errorCount.set(0);
                this.errorNewer.set(null);
                this.errorEpoch.set(0L);
                return;
            }
            RuntimeException err = this.errorNewer.get();
            if (err == null) {
                return;
            }
            if (err instanceof NoSuchElementException) {
                throw err;
            }
            if (this.errorCount.get() > LightIdBufferedProvider.this.loadMaxError) {
                throw err;
            }
        }
    }

    private class SegmentStatus {
        private final long headSeq;
        private final long kneeSeq;
        private final long footSeq;
        private final long startMs;
        private final AtomicLong sequence;

        private SegmentStatus() {
            this.headSeq = -1L;
            this.kneeSeq = -1L;
            this.footSeq = -1L;
            this.startMs = System.currentTimeMillis();
            this.sequence = new AtomicLong(0L);
        }

        private SegmentStatus(LightIdProvider.Segment seg) {
            this.headSeq = seg.getHead();
            this.footSeq = seg.getFoot();
            this.kneeSeq = this.footSeq - (this.footSeq - this.headSeq) * 2L / 10L;
            this.startMs = System.currentTimeMillis();
            this.sequence = new AtomicLong(seg.getHead());
        }

        public int count60s(int mul) {
            int fix = LightIdBufferedProvider.this.loadFixCount;
            if (fix > 0) {
                return fix;
            }
            long ms = System.currentTimeMillis() - this.startMs;
            long count = this.footSeq - this.headSeq + 1L;
            if (ms > 0L) {
                count = count * 60000L / ms;
            }
            if (mul > 1) {
                count *= (long)mul;
            }
            int max = LightIdBufferedProvider.this.loadMaxCount;
            int min = LightIdBufferedProvider.this.loadMinCount;
            if (count < 0L || count > (long)max) {
                return max;
            }
            if (count < (long)min) {
                return min;
            }
            return (int)count;
        }
    }
}

