/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.mirana.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import org.jetbrains.annotations.NotNull;
import pro.fessional.mirana.best.DummyBlock;

public class CircleInputStream
extends InputStream {
    @NotNull
    protected InputStream backend;
    protected ByteArrayOutputStream caching = null;
    protected File file = null;
    protected byte[] content = null;
    protected int offset = 0;
    protected int length = 0;
    private boolean finished = false;
    private byte[] markBytes = null;
    private static final Field FileInputStreamPath = CircleInputStream.reflectField(FileInputStream.class, "path");
    private static final Field ByteArrayInputStreamBuf = CircleInputStream.reflectField(ByteArrayInputStream.class, "buf");
    private static final Field ByteArrayInputStreamPos = CircleInputStream.reflectField(ByteArrayInputStream.class, "pos");
    private static final Field ByteArrayInputStreamCount = CircleInputStream.reflectField(ByteArrayInputStream.class, "count");

    public CircleInputStream(@NotNull InputStream backend) {
        if (backend instanceof CircleInputStream) {
            CircleInputStream cis = (CircleInputStream)backend;
            this.backend = cis.backend;
            this.caching = cis.caching;
            this.file = cis.file;
            this.content = cis.content;
            this.offset = cis.offset;
            this.length = cis.length;
            this.finished = cis.finished;
            return;
        }
        if (backend instanceof FileInputStream && FileInputStreamPath != null) {
            try {
                String path = (String)FileInputStreamPath.get(backend);
                if (path != null) {
                    this.file = new File(path);
                    this.backend = backend;
                    return;
                }
            }
            catch (Exception e) {
                DummyBlock.ignore(e);
            }
        } else if (backend instanceof ByteArrayInputStream && ByteArrayInputStreamBuf != null && ByteArrayInputStreamPos != null && ByteArrayInputStreamCount != null) {
            try {
                byte[] buf = (byte[])ByteArrayInputStreamBuf.get(backend);
                int pos = ByteArrayInputStreamPos.getInt(backend);
                int cnt = ByteArrayInputStreamCount.getInt(backend);
                this.content = buf;
                this.offset = pos;
                this.length = cnt;
                this.backend = backend;
                return;
            }
            catch (Exception e) {
                DummyBlock.ignore(e);
            }
        }
        this.backend = backend;
        this.caching = new ByteArrayOutputStream();
    }

    public CircleInputStream(@NotNull File file) {
        this.backend = this.initByFile(file);
    }

    public CircleInputStream(@NotNull ByteArrayOutputStream cache) {
        this.backend = this.initByByte(cache.toByteArray());
    }

    public CircleInputStream(byte @NotNull [] cache) {
        this.backend = this.initByByte(cache);
    }

    public CircleInputStream(byte @NotNull [] cache, int offset, int length) {
        this.backend = this.initByByte(cache, offset, length);
    }

    public boolean isFinished() {
        return this.finished;
    }

    private InputStream initByFile(@NotNull File file) {
        try {
            this.file = file;
            return new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private InputStream initByByte(byte @NotNull [] bytes) {
        return this.initByByte(bytes, 0, bytes.length);
    }

    private InputStream initByByte(byte @NotNull [] bytes, int off, int len) {
        this.content = bytes;
        this.offset = off;
        this.length = len;
        return new ByteArrayInputStream(this.content, this.offset, this.length);
    }

    private void renewBackend() {
        if (this.content == null && this.caching != null) {
            this.content = this.caching.toByteArray();
            this.caching = null;
            this.offset = 0;
            this.length = this.content.length;
        }
        try {
            this.backend.close();
        }
        catch (IOException e) {
            DummyBlock.ignore(e);
        }
        if (this.content != null) {
            this.backend = new ByteArrayInputStream(this.content, this.offset, this.length);
        } else {
            try {
                this.backend = new FileInputStream(this.file);
            }
            catch (FileNotFoundException e) {
                throw new IllegalStateException(e);
            }
        }
        this.finished = false;
    }

    @Override
    public int read() throws IOException {
        int c;
        if (this.finished) {
            this.renewBackend();
        }
        if ((c = this.backend.read()) < 0) {
            this.finished = true;
        } else if (this.caching != null) {
            this.caching.write(c);
        }
        return c;
    }

    @Override
    public int read(byte @NotNull [] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte @NotNull [] b, int off, int len) throws IOException {
        int c;
        if (this.finished) {
            this.renewBackend();
        }
        if ((c = this.backend.read(b, off, len)) < 0) {
            this.finished = true;
        } else if (this.caching != null) {
            this.caching.write(b, off, c);
        }
        return c;
    }

    @Override
    public long skip(long n) throws IOException {
        if (this.caching != null) {
            long r;
            for (r = n; r > 0L; --r) {
                int c = this.backend.read();
                if (c < 0) {
                    this.finished = true;
                    continue;
                }
                this.caching.write(c);
            }
            return n - r;
        }
        return this.backend.skip(n);
    }

    @Override
    public int available() throws IOException {
        if (this.finished) {
            if (this.file != null) {
                return (int)this.file.length();
            }
            if (this.content != null) {
                return this.content.length;
            }
            if (this.caching != null) {
                return this.caching.size();
            }
        }
        return this.backend.available();
    }

    @Override
    public void close() throws IOException {
        this.finished = true;
        this.backend.close();
    }

    @Override
    public void mark(int readlimit) {
        if (this.caching != null) {
            this.markBytes = this.caching.toByteArray();
        }
        this.backend.mark(readlimit);
    }

    @Override
    public void reset() throws IOException {
        this.backend.reset();
        if (this.caching != null && this.markBytes != null) {
            this.caching.reset();
            this.caching.write(this.markBytes);
            this.markBytes = null;
        }
    }

    @Override
    public boolean markSupported() {
        return this.backend.markSupported();
    }

    public byte[] getContent() {
        return this.content;
    }

    public File getFile() {
        return this.file;
    }

    private static Field reflectField(Class<?> clz, String fld) {
        try {
            Field fd = clz.getDeclaredField(fld);
            fd.setAccessible(true);
            return fd;
        }
        catch (NoSuchFieldException e) {
            return null;
        }
    }
}

