/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.mirana.anti;

import java.beans.Transient;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BeanVisitor {
    private static final ConcurrentHashMap<Class<?>, List<Fd>> ClassFields = new ConcurrentHashMap();

    public static void visit(@Nullable Object bean, Vzt ... vzts) {
        BeanVisitor.visit(Opt.Default, bean, vzts);
    }

    public static void visit(@Nullable Object bean, @Nullable Collection<Vzt> visitors) {
        BeanVisitor.visit(Opt.Default, bean, visitors);
    }

    public static void visit(@Nullable Opt opt, @Nullable Object bean, Vzt ... vzts) {
        BeanVisitor.visit(opt, bean, Arrays.asList(vzts));
    }

    public static void visit(@Nullable Opt opt, @Nullable Object bean, @Nullable Collection<Vzt> visitors) {
        if (bean == null || visitors == null || visitors.isEmpty()) {
            return;
        }
        BeanVisitor.vztStack(bean, visitors, new ArrayList<Object>(), opt == null ? Opt.Default : opt, 1);
    }

    private static void vztStack(@NotNull Object bean, @NotNull Collection<Vzt> visitors, @NotNull ArrayList<Object> stack, @NotNull Opt opt, int depth) {
        if (depth > opt.walkDepth) {
            return;
        }
        for (Object o : stack) {
            if (o != bean) continue;
            return;
        }
        stack.add(bean);
        if (bean instanceof Object[]) {
            for (Object v : (Object[])bean) {
                BeanVisitor.vztStack(v, visitors, stack, opt, depth);
            }
        } else if (bean instanceof Iterable) {
            for (Object v : (Iterable)bean) {
                BeanVisitor.vztStack(v, visitors, stack, opt, depth);
            }
        } else if (bean instanceof Map) {
            for (Object v : ((Map)bean).values()) {
                BeanVisitor.vztStack(v, visitors, stack, opt, depth);
            }
        } else {
            BeanVisitor.vztBean(bean, visitors, stack, opt, depth);
        }
    }

    private static void vztBean(@NotNull Object bean, @NotNull Collection<Vzt> visitors, @NotNull ArrayList<Object> stack, @NotNull Opt opt, int depth) {
        block2: for (Fd fd : BeanVisitor.genFields(bean.getClass(), opt)) {
            for (Vzt vz : visitors) {
                Annotation[] n;
                Field f;
                if (!vz.cares(f = fd.field, n = fd.annos)) continue;
                try {
                    Object r;
                    Object o = f.get(bean);
                    boolean m = fd.amend(bean, o, r = vz.amend(f, n, o));
                    if (m && opt.amendOnce) continue block2;
                    if (r == null) continue;
                    BeanVisitor.vztStack(r, visitors, stack, opt, depth + 1);
                }
                catch (IllegalAccessException e) {
                    if (!opt.throwOnError) continue;
                    throw new IllegalStateException(e);
                }
            }
        }
    }

    private static List<Fd> genFields(@NotNull Class<?> clz, @NotNull Opt opt) {
        return ClassFields.computeIfAbsent(clz, cz -> {
            ArrayList<Fd> ds = new ArrayList<Fd>();
            for (Class uz = cz; uz != Object.class; uz = uz.getSuperclass()) {
                for (Field f : uz.getDeclaredFields()) {
                    int md = f.getModifiers();
                    if (f.isSynthetic() || opt.skipTransient && Modifier.isTransient(md) || opt.skipFinal && Modifier.isFinal(md) || BeanVisitor.notGetter(opt.tryRawGetter, f, uz)) continue;
                    ds.add(new Fd(f));
                }
            }
            return ds;
        });
    }

    private static boolean notGetter(boolean raw, @NotNull Field fld, @NotNull Class<?> clz) {
        int h2;
        Class<?> ft = fld.getType();
        String nm = fld.getName();
        String up = Character.toUpperCase(nm.charAt(0)) + nm.substring(1);
        if (Boolean.class.equals(ft) || Boolean.TYPE.equals(ft)) {
            int h1 = BeanVisitor.hasGetter(clz, "is" + up);
            if (h1 == 1) {
                return false;
            }
            if (h1 == 0) {
                return true;
            }
        }
        if ((h2 = BeanVisitor.hasGetter(clz, "get" + up)) == 1) {
            return false;
        }
        if (h2 == 0) {
            return true;
        }
        return raw && BeanVisitor.hasGetter(clz, nm) != 1;
    }

    private static int hasGetter(@NotNull Class<?> clz, @NotNull String name) {
        try {
            Method md = clz.getMethod(name, new Class[0]);
            Transient an = md.getAnnotation(Transient.class);
            return an != null && an.value() ? 0 : 1;
        }
        catch (NoSuchMethodException e) {
            return -1;
        }
    }

    public static abstract class ContainerVisitor
    implements Vzt {
        @Override
        public Object amend(@NotNull Field field, @NotNull Annotation[] annos, Object obj) {
            if (obj instanceof Map) {
                return this.amendMap(field, annos, (Map)obj);
            }
            if (obj instanceof Set) {
                return this.amendSet(field, annos, (Set)obj);
            }
            if (obj instanceof List) {
                return this.amendList(field, annos, (List)obj);
            }
            if (obj instanceof Object[]) {
                return this.amendArr(field, annos, (Object[])obj);
            }
            return this.amendValue(field, annos, obj);
        }

        protected Map<?, ?> amendMap(@NotNull Field field, @NotNull Annotation[] annos, @NotNull Map<?, ?> map) {
            int size = map.size();
            if (size == 0) {
                return map;
            }
            ArrayList hs = new ArrayList(size);
            Map nm = null;
            for (Map.Entry<?, ?> en : map.entrySet()) {
                Object r;
                Object v = en.getValue();
                if (v != (r = this.amend(field, annos, v))) {
                    if (nm == null) {
                        nm = (Map)this.newContainer(map.getClass(), size);
                    }
                    if (hs != null) {
                        for (Map.Entry entry : hs) {
                            nm.put(entry.getKey(), entry.getValue());
                        }
                        hs = null;
                    }
                    nm.put(en.getKey(), r);
                    continue;
                }
                if (hs != null) {
                    hs.add(en);
                    continue;
                }
                nm.put(en.getKey(), v);
            }
            return nm == null ? map : nm;
        }

        protected Set<?> amendSet(@NotNull Field field, @NotNull Annotation[] annos, @NotNull Set<?> set) {
            int size = set.size();
            if (size == 0) {
                return set;
            }
            ArrayList hs = new ArrayList(size);
            Set nm = null;
            for (Object v : set) {
                Object r;
                if (v != (r = this.amend(field, annos, v))) {
                    if (nm == null) {
                        nm = (Set)this.newContainer(set.getClass(), size);
                    }
                    if (hs != null) {
                        nm.addAll(hs);
                        hs = null;
                    }
                    nm.add(r);
                    continue;
                }
                if (hs != null) {
                    hs.add(v);
                    continue;
                }
                nm.add(v);
            }
            return nm == null ? set : nm;
        }

        protected List<?> amendList(@NotNull Field field, @NotNull Annotation[] annos, @NotNull List<?> lst) {
            int size = lst.size();
            if (size == 0) {
                return lst;
            }
            ArrayList hs = new ArrayList(size);
            List nm = null;
            for (Object v : lst) {
                Object r;
                if (v != (r = this.amend(field, annos, v))) {
                    if (nm == null) {
                        nm = (List)this.newContainer(lst.getClass(), size);
                    }
                    if (hs != null) {
                        nm.addAll(hs);
                        hs = null;
                    }
                    nm.add(r);
                    continue;
                }
                if (hs != null) {
                    hs.add(v);
                    continue;
                }
                nm.add(v);
            }
            return nm == null ? lst : nm;
        }

        protected Object[] amendArr(@NotNull Field field, @NotNull Annotation[] annos, @NotNull Object[] arr) {
            if (arr.length == 0) {
                return arr;
            }
            Object[] hs = new Object[arr.length];
            Object[] nm = null;
            for (int i = 0; i < arr.length; ++i) {
                Object v = arr[i];
                Object r = this.amend(field, annos, v);
                if (v != r) {
                    if (nm == null) {
                        nm = (Object[])this.newContainer(arr.getClass(), arr.length);
                    }
                    if (hs != null) {
                        for (int j = 0; j < i; ++j) {
                            nm[j] = hs[j];
                        }
                        hs = null;
                    }
                    nm[i] = r;
                    continue;
                }
                if (hs != null) {
                    hs[i] = v;
                    continue;
                }
                nm[i] = v;
            }
            return nm == null ? arr : nm;
        }

        @NotNull
        protected <T> T newContainer(@NotNull Class<?> claz, int size) {
            try {
                Object r;
                if (claz.isArray()) {
                    r = Array.newInstance(claz.getComponentType(), size);
                } else {
                    Constructor<?> ci = claz.getConstructor(Integer.TYPE);
                    r = ci.newInstance(size);
                }
                return (T)r;
            }
            catch (ReflectiveOperationException e) {
                throw new IllegalStateException(e);
            }
        }

        @Nullable
        protected abstract Object amendValue(@NotNull Field var1, @NotNull Annotation[] var2, @Nullable Object var3);
    }

    public static interface Vzt {
        public boolean cares(@NotNull Field var1, @NotNull Annotation[] var2);

        public Object amend(@NotNull Field var1, @NotNull Annotation[] var2, Object var3);
    }

    public static class Fd {
        private final Field field;
        private final Annotation[] annos;

        private Fd(Field fd) {
            this.field = fd;
            this.annos = fd.getDeclaredAnnotations();
            this.field.setAccessible(true);
        }

        private boolean amend(Object bean, Object ori, Object upd) throws IllegalAccessException {
            if (this.field.getType().isPrimitive()) {
                if (upd != null && upd != ori) {
                    if (upd instanceof Boolean) {
                        this.field.setBoolean(bean, (Boolean)upd);
                    } else if (upd instanceof Byte) {
                        this.field.setByte(bean, (Byte)upd);
                    } else if (upd instanceof Character) {
                        this.field.setChar(bean, ((Character)upd).charValue());
                    } else if (upd instanceof Double) {
                        this.field.setDouble(bean, (Double)upd);
                    } else if (upd instanceof Float) {
                        this.field.setFloat(bean, ((Float)upd).floatValue());
                    } else if (upd instanceof Integer) {
                        this.field.setInt(bean, (Integer)upd);
                    } else if (upd instanceof Long) {
                        this.field.setLong(bean, (Long)upd);
                    } else if (upd instanceof Short) {
                        this.field.setShort(bean, (Short)upd);
                    }
                    return true;
                }
            } else if (ori != upd) {
                this.field.set(bean, upd);
                return true;
            }
            return false;
        }
    }

    public static class Opt {
        public static final Opt Default = new Opt();
        private boolean amendOnce = true;
        private boolean skipFinal = true;
        private boolean skipTransient = true;
        private boolean tryRawGetter = true;
        private boolean throwOnError = true;
        private int walkDepth = Integer.MAX_VALUE;

        public boolean isAmendOnce() {
            return this.amendOnce;
        }

        public boolean isSkipFinal() {
            return this.skipFinal;
        }

        public boolean isSkipTransient() {
            return this.skipTransient;
        }

        public boolean isTryRawGetter() {
            return this.tryRawGetter;
        }

        public boolean isThrowOnError() {
            return this.throwOnError;
        }

        public int getWalkDepth() {
            return this.walkDepth;
        }

        @Contract(value="_->this")
        public Opt amendOnce(boolean b) {
            this.amendOnce = b;
            return this;
        }

        @Contract(value="_->this")
        public Opt skipFinal(boolean b) {
            this.skipFinal = b;
            return this;
        }

        @Contract(value="_->this")
        public Opt skipTransient(boolean b) {
            this.skipTransient = b;
            return this;
        }

        @Contract(value="_->this")
        public Opt tryRawGetter(boolean b) {
            this.tryRawGetter = b;
            return this;
        }

        @Contract(value="_->this")
        public Opt throwOnError(boolean b) {
            this.throwOnError = b;
            return this;
        }

        @Contract(value="_->this")
        public Opt walkDepth(int depth) {
            this.walkDepth = depth;
            return this;
        }
    }
}

