/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.mirana.bits;

import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pro.fessional.mirana.bits.Base64;
import pro.fessional.mirana.bits.Bytes;
import pro.fessional.mirana.data.Null;
import pro.fessional.mirana.io.InputStreams;

public abstract class Aes {
    private final SecretKeySpec keySpec;
    private final IvParameterSpec algSpec;
    private final String cipherName;

    public Aes(byte[] key) {
        this(new SecretKeySpec(key, "AES"), new IvParameterSpec(key, 0, 16));
    }

    public Aes(SecretKeySpec keySpec, IvParameterSpec algSpec) {
        this(keySpec, algSpec, "AES/CBC/PKCS5Padding");
    }

    public Aes(SecretKeySpec keySpec, IvParameterSpec algSpec, String cipherName) {
        this.keySpec = keySpec;
        this.algSpec = algSpec;
        this.cipherName = cipherName;
    }

    public byte @NotNull [] encode(@Nullable String plain) {
        if (plain == null) {
            return Null.Bytes;
        }
        byte[] bytes = plain.getBytes(StandardCharsets.UTF_8);
        return this.encode(bytes);
    }

    public byte @NotNull [] encode(@Nullable InputStream plain) {
        if (plain == null) {
            return Null.Bytes;
        }
        byte[] bytes = InputStreams.readBytes(plain);
        return this.encode(bytes);
    }

    public byte @NotNull [] encode(byte[] plain) {
        if (plain == null) {
            return Null.Bytes;
        }
        try {
            Cipher ins = Cipher.getInstance(this.cipherName);
            ins.init(1, (Key)this.keySpec, this.algSpec);
            return ins.doFinal(plain);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public byte @NotNull [] decode(byte[] cipher) {
        if (cipher == null || cipher.length == 0) {
            return Null.Bytes;
        }
        try {
            Cipher ins = Cipher.getInstance(this.cipherName);
            ins.init(2, (Key)this.keySpec, this.algSpec);
            return ins.doFinal(cipher);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public byte @NotNull [] decode(@Nullable InputStream cipher) {
        if (cipher == null) {
            return Null.Bytes;
        }
        byte[] bytes = InputStreams.readBytes(cipher);
        return this.decode(bytes);
    }

    @NotNull
    public String encode16(@Nullable String plain) {
        if (plain == null) {
            return "";
        }
        byte[] pb = plain.getBytes(StandardCharsets.UTF_8);
        byte[] cb = this.encode(pb);
        return Bytes.hex(cb);
    }

    @NotNull
    public String decode16(@Nullable String cipher) {
        if (cipher == null || cipher.isEmpty()) {
            return "";
        }
        byte[] cb = Bytes.hex(cipher);
        byte[] pb = this.decode(cb);
        return new String(pb, StandardCharsets.UTF_8);
    }

    @NotNull
    public String encode64(@Nullable String plain) {
        if (plain == null) {
            return "";
        }
        byte[] pb = plain.getBytes(StandardCharsets.UTF_8);
        byte[] cb = this.encode(pb);
        return Base64.encode(cb);
    }

    @NotNull
    public String decode64(@Nullable String cipher) {
        if (cipher == null || cipher.isEmpty()) {
            return "";
        }
        byte[] cb = Base64.decode(cipher);
        byte[] pb = this.decode(cb);
        return new String(pb, StandardCharsets.UTF_8);
    }
}

