/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.mirana.bits;

import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pro.fessional.mirana.bits.Bytes;
import pro.fessional.mirana.data.Null;
import pro.fessional.mirana.io.InputStreams;

public class MdHelp {
    public final String algorithm;
    public final int hexLength;
    public static final int LEN_MD5_HEX = 32;
    public static final int LEN_SHA1_HEX = 40;
    public static final int LEN_SHA256_HEX = 64;
    public static final String MD_MD5 = "MD5";
    public static final String MD_SHA1 = "SHA-1";
    public static final String MD_SHA256 = "SHA-256";
    public static final MdHelp md5 = MdHelp.of("MD5", 32);
    public static final MdHelp sha1 = MdHelp.of("SHA-1", 40);
    public static final MdHelp sha256 = MdHelp.of("SHA-256", 64);

    protected MdHelp(String algorithm) {
        this.algorithm = algorithm;
        this.hexLength = MdHelp.guessHexLength(algorithm);
    }

    protected MdHelp(String algorithm, int hexLen) {
        this.algorithm = algorithm;
        this.hexLength = hexLen;
    }

    public boolean isSum(@Nullable String str) {
        return Bytes.isHex(str, this.hexLength);
    }

    public boolean asSum(@Nullable String str) {
        return Bytes.asHex(str, this.hexLength);
    }

    @NotNull
    public String getAlgorithm() {
        return this.algorithm;
    }

    public int getHexLength() {
        return this.hexLength;
    }

    @NotNull
    public String sum(@Nullable String str) {
        return this.sum(str, true);
    }

    @NotNull
    public String sum(@Nullable InputStream ins) {
        return this.sum(ins, true);
    }

    @NotNull
    public String sum(byte @Nullable [] bytes) {
        return Bytes.hex(bytes, true);
    }

    @NotNull
    public String sum(@Nullable String str, boolean upper) {
        if (str == null) {
            return "";
        }
        return this.sum(str.getBytes(StandardCharsets.UTF_8), upper);
    }

    @NotNull
    public String sum(@Nullable InputStream ins, boolean upper) {
        if (ins == null) {
            return "";
        }
        byte[] bytes = InputStreams.readBytes(ins);
        return this.sum(bytes, upper);
    }

    @NotNull
    public String sum(byte @Nullable [] bytes, boolean upper) {
        if (bytes == null) {
            return "";
        }
        byte[] hash = this.digest(bytes);
        return Bytes.hex(hash, upper);
    }

    public byte @NotNull [] digest(byte @Nullable [] bytes) {
        if (bytes == null) {
            return Null.Bytes;
        }
        MessageDigest digest = this.newOne();
        digest.update(bytes);
        return digest.digest();
    }

    @NotNull
    public MessageDigest newOne() {
        return MdHelp.newOne(this.algorithm);
    }

    public boolean check(@Nullable String sum, byte @Nullable [] bytes) {
        if (bytes == null || sum == null) {
            return false;
        }
        String md5 = this.sum(bytes);
        return sum.equalsIgnoreCase(md5);
    }

    public boolean check(@Nullable String sum, @Nullable String str) {
        if (str == null || sum == null) {
            return false;
        }
        String md5 = this.sum(str);
        return sum.equalsIgnoreCase(md5);
    }

    public boolean check(@Nullable String sum, @Nullable InputStream ins) {
        if (ins == null || sum == null) {
            return false;
        }
        String md5 = this.sum(ins);
        return sum.equalsIgnoreCase(md5);
    }

    public static int guessHexLength(@NotNull String algorithm) {
        if (MD_MD5.equalsIgnoreCase(algorithm)) {
            return 32;
        }
        if (MD_SHA1.equalsIgnoreCase(algorithm)) {
            return 40;
        }
        if (MD_SHA256.equalsIgnoreCase(algorithm)) {
            return 64;
        }
        return 0;
    }

    @NotNull
    public static MdHelp of(@NotNull String algorithm) {
        return new MdHelp(algorithm);
    }

    @NotNull
    public static MdHelp of(@NotNull String algorithm, int hexLen) {
        return new MdHelp(algorithm, hexLen);
    }

    @NotNull
    public static MessageDigest newMd5() {
        return MdHelp.newOne(MD_MD5);
    }

    @NotNull
    public static MessageDigest newSha1() {
        return MdHelp.newOne(MD_SHA1);
    }

    @NotNull
    public static MessageDigest newSha256() {
        return MdHelp.newOne(MD_SHA256);
    }

    @NotNull
    public static MessageDigest newOne(@NotNull String algorithm) {
        try {
            return MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("can not init algorithm=" + algorithm, e);
        }
    }

    public static boolean checks(@Nullable String sum, @Nullable Object obj) {
        MdHelp help;
        if (obj == null || sum == null) {
            return false;
        }
        int len = sum.length();
        if (len == 32) {
            help = md5;
        } else if (len == 40) {
            help = sha1;
        } else if (len == 64) {
            help = sha256;
        } else {
            return false;
        }
        if (obj instanceof CharSequence) {
            return help.check(sum, obj.toString());
        }
        if (obj instanceof byte[]) {
            return help.check(sum, (byte[])obj);
        }
        if (obj instanceof InputStream) {
            return help.check(sum, (InputStream)obj);
        }
        return false;
    }
}

