/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.mirana.cast;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypedCastUtil {
    @Contract(value="!null->!null")
    public static <T> T castObject(Object obj) {
        return (T)obj;
    }

    @Nullable
    public static <T> T castObject(Object obj, Class<T> claz) {
        if (claz == null || claz.isInstance(obj)) {
            return (T)obj;
        }
        return null;
    }

    @NotNull
    public static <T> Collection<T> castCollection(Collection<?> obj) {
        return TypedCastUtil.castCollection(obj, null);
    }

    @NotNull
    public static <T> Collection<T> castCollection(Collection<?> obj, Class<T> claz) {
        if (obj == null) {
            return Collections.emptyList();
        }
        if (claz == null) {
            return obj;
        }
        ArrayList arr = new ArrayList(obj.size());
        for (Object t : obj) {
            if (!claz.isInstance(t)) continue;
            arr.add(t);
        }
        return arr;
    }

    @NotNull
    public static <T> List<T> castList(Collection<?> obj) {
        return TypedCastUtil.castList(obj, null);
    }

    @NotNull
    public static <T> List<T> castList(Collection<?> obj, Class<T> claz) {
        if (obj == null) {
            return Collections.emptyList();
        }
        if (claz == null && obj instanceof List) {
            return (List)obj;
        }
        ArrayList arr = new ArrayList(obj.size());
        for (Object t : obj) {
            if (claz != null && !claz.isInstance(t)) continue;
            arr.add(t);
        }
        return arr;
    }

    @NotNull
    public static <T> Set<T> castSet(Collection<?> obj) {
        return TypedCastUtil.castSet(obj, null);
    }

    @NotNull
    public static <T> Set<T> castSet(Collection<?> obj, Class<T> claz) {
        if (obj == null) {
            return Collections.emptySet();
        }
        if (claz == null && obj instanceof Set) {
            return (Set)obj;
        }
        HashSet arr = new HashSet(obj.size());
        for (Object t : obj) {
            if (claz != null && !claz.isInstance(t)) continue;
            arr.add(t);
        }
        return arr;
    }
}

