/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.mirana.cond;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StaticFlag {
    private static final Map<Enum<?>, Boolean> JvmFlags = new ConcurrentHashMap();
    private static final Map<Object, Map<Enum<?>, Boolean>> KeyFlags = new ConcurrentHashMap();
    private static final Pattern ListSplit = Pattern.compile("[\r\n\t ,]+");

    public static void setFlag(@NotNull Enum<?> flag) {
        JvmFlags.put(flag, Boolean.TRUE);
    }

    public static void delFlag(@NotNull Enum<?> flag) {
        JvmFlags.remove(flag);
    }

    public static boolean hasFlag(@NotNull Enum<?> flag) {
        Boolean bol = JvmFlags.get(flag);
        return bol != null;
    }

    public static boolean anyFlag(Enum<?> ... flags) {
        for (Enum<?> flag : flags) {
            if (!StaticFlag.hasFlag(flag)) continue;
            return true;
        }
        return false;
    }

    public static boolean notFlag(@NotNull Enum<?> flag) {
        Boolean bol = JvmFlags.get(flag);
        return bol == null;
    }

    public static void setFlag(@NotNull Object key, @NotNull Enum<?> flag) {
        KeyFlags.computeIfAbsent(key, k -> {
            ConcurrentHashMap<Enum, Boolean> map = new ConcurrentHashMap<Enum, Boolean>();
            map.put(flag, Boolean.TRUE);
            return map;
        });
    }

    public static void delFlag(@NotNull Object key, @NotNull Enum<?> flag) {
        Map<Enum<?>, Boolean> map = KeyFlags.get(key);
        if (map != null) {
            map.remove(flag);
        }
    }

    public static boolean hasFlag(@NotNull Object key, @NotNull Enum<?> flag) {
        Map<Enum<?>, Boolean> map = KeyFlags.get(key);
        return map != null && map.get(flag) != null;
    }

    public static boolean anyFlag(@NotNull Object key, Enum<?> ... flags) {
        Map<Enum<?>, Boolean> map = KeyFlags.get(key);
        if (map == null) {
            return false;
        }
        for (Enum<?> flag : flags) {
            if (map.get(flag) == null) continue;
            return true;
        }
        return false;
    }

    public static boolean notFlag(@NotNull Object key, @NotNull Enum<?> flag) {
        Map<Enum<?>, Boolean> map = KeyFlags.get(key);
        return map == null || map.get(flag) == null;
    }

    public static int vote(@NotNull String flag, @NotNull String vote) {
        int ln;
        char c;
        int vln = vote.length();
        int fln = flag.length();
        int not = 0;
        int off = 0;
        for (int i = 0; i < vln; ++i) {
            c = vote.charAt(i);
            if (c == '-' || c == '!') {
                not = 1;
                off = i + 1;
                break;
            }
            if (c != ' ' && c != '\t' && c != '\r' && c != '\n') break;
            off = i + 1;
        }
        if ((ln = vln - off) < fln) {
            return not;
        }
        if (ln > fln && (c = vote.charAt(off + fln)) != ' ' && c != '\t' && c != '\r' && c != '\n' && c != ',') {
            return not;
        }
        boolean fnd = flag.regionMatches(true, 0, vote, off, fln);
        return fnd ? (not == 0 ? 2 : -2) : not;
    }

    public static boolean hasVote(@Nullable String flag, String ... votes) {
        if (flag == null || flag.isEmpty() || votes == null) {
            return false;
        }
        boolean voted = false;
        for (String vt : votes) {
            if (vt == null || vt.isEmpty()) continue;
            int vr = StaticFlag.vote(flag, vt);
            if (vr > 0) {
                voted = true;
                continue;
            }
            if (vr >= 0) continue;
            return false;
        }
        return voted;
    }

    public static boolean hasVote(@Nullable String flag, @Nullable String votes) {
        if (votes == null || votes.isEmpty()) {
            return false;
        }
        return StaticFlag.hasVote(flag, ListSplit.split(votes));
    }

    public static boolean notVote(@Nullable String flag, @Nullable String votes) {
        return !StaticFlag.hasVote(flag, votes);
    }

    public static boolean notVote(@Nullable String flag, String ... votes) {
        return !StaticFlag.hasVote(flag, votes);
    }
}

