/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.mirana.data;

import java.beans.Transient;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pro.fessional.mirana.data.CodeEnum;
import pro.fessional.mirana.data.DataResult;
import pro.fessional.mirana.i18n.I18nAware;
import pro.fessional.mirana.i18n.I18nString;
import pro.fessional.mirana.pain.CodeException;

public class R<T>
implements DataResult<T>,
I18nAware {
    private static final long serialVersionUID = 19791023L;
    protected boolean success;
    protected String message;
    protected String code;
    protected Object data;
    protected Object cause = null;
    protected String i18nCode = null;
    protected Object[] i18nArgs = null;

    public R() {
        this.success = false;
        this.message = null;
        this.code = null;
        this.data = null;
    }

    public R(boolean success) {
        this.success = success;
        this.message = null;
        this.code = null;
        this.data = null;
    }

    protected R(boolean success, String message, String code, T data) {
        this.success = success;
        this.message = message;
        this.code = code;
        this.data = data;
    }

    protected R(boolean success, CodeEnum code, T data) {
        this.success = success;
        this.data = data;
        this.setCode(code);
    }

    @Override
    public boolean isSuccess() {
        return this.success;
    }

    @Contract(value="_->this")
    public R<T> setSuccess(boolean success) {
        this.success = success;
        return this;
    }

    @Override
    @Nullable
    public String getMessage() {
        return this.message;
    }

    @Contract(value="_->this")
    public R<T> setMessage(String message) {
        this.message = message;
        return this;
    }

    @Transient
    @Contract(value="_->this")
    public R<T> setMessageIfOk(String message) {
        return this.success ? this.setMessage(message) : this;
    }

    @Transient
    @Contract(value="_->this")
    public R<T> setMessageIfNg(String message) {
        return this.success ? this : this.setMessage(message);
    }

    @Transient
    @Contract(value="_->this")
    public R<T> setMessageIfOk(@NotNull Supplier<String> message) {
        return this.success ? this.setMessage(message.get()) : this;
    }

    @Transient
    @Contract(value="_->this")
    public R<T> setMessageIfNg(@NotNull Supplier<String> message) {
        return this.success ? this : this.setMessage(message.get());
    }

    @Transient
    @Contract(value="_,_->this")
    public R<T> setI18nMessage(CodeEnum ce, Object ... arg) {
        return this.setI18nMessage(null, ce, arg);
    }

    @Transient
    @Contract(value="_,_,_->this")
    public R<T> setI18nMessage(Boolean replace, CodeEnum ce, Object ... arg) {
        if (replace == null) {
            if (this.code == null) {
                this.code = ce.getCode();
            }
            if (this.message == null) {
                this.message = ce.getHint();
            }
        } else if (replace.booleanValue()) {
            this.code = ce.getCode();
            this.message = ce.getHint();
        }
        this.i18nCode = ce.getI18nCode();
        this.i18nArgs = arg;
        return this;
    }

    @Transient
    @Contract(value="_,_->this")
    public R<T> setI18nMessageIfOk(CodeEnum ce, Object ... arg) {
        return this.success ? this.setI18nMessage(null, ce, arg) : this;
    }

    @Transient
    @Contract(value="_,_->this")
    public R<T> setI18nMessageIfNg(CodeEnum ce, Object ... arg) {
        return this.success ? this : this.setI18nMessage(null, ce, arg);
    }

    @Contract(value="_,_,_->this")
    public R<T> setI18nMessageIfOk(Boolean replace, CodeEnum ce, Object ... arg) {
        return this.success ? this.setI18nMessage(replace, ce, arg) : this;
    }

    @Transient
    @Contract(value="_,_,_->this")
    public R<T> setI18nMessageIfNg(Boolean replace, CodeEnum ce, Object ... arg) {
        return this.success ? this : this.setI18nMessage(replace, ce, arg);
    }

    @Transient
    @Contract(value="_->this")
    public R<T> setI18nMessage(I18nAware message) {
        return this.setI18nMessage(null, message);
    }

    @Transient
    @Contract(value="_,_->this")
    public R<T> setI18nMessage(Boolean replace, I18nAware message) {
        if (message instanceof I18nString) {
            if (replace == null) {
                if (this.message == null) {
                    this.message = ((I18nString)message).getHint();
                }
            } else if (replace.booleanValue()) {
                this.message = ((I18nString)message).getHint();
            }
        }
        this.i18nCode = message.getI18nCode();
        this.i18nArgs = message.getI18nArgs();
        return this;
    }

    @Transient
    @Contract(value="_->this")
    public R<T> setI18nMessageIfOk(I18nAware message) {
        return this.success ? this.setI18nMessage(null, message) : this;
    }

    @Transient
    @Contract(value="_->this")
    public R<T> setI18nMessageIfNg(I18nAware message) {
        return this.success ? this : this.setI18nMessage(null, message);
    }

    @Transient
    @Contract(value="_->this")
    public R<T> setI18nMessageIfOk(Supplier<I18nAware> message) {
        return this.success ? this.setI18nMessage(null, message.get()) : this;
    }

    @Transient
    @Contract(value="_->this")
    public R<T> setI18nMessageIfNg(Supplier<I18nAware> message) {
        return this.success ? this : this.setI18nMessage(null, message.get());
    }

    @Transient
    @Contract(value="_,_->this")
    public R<T> setI18nMessageIfOk(Boolean replace, I18nAware message) {
        return this.success ? this.setI18nMessage(replace, message) : this;
    }

    @Transient
    @Contract(value="_,_->this")
    public R<T> setI18nMessageIfNg(Boolean replace, I18nAware message) {
        return this.success ? this : this.setI18nMessage(replace, message);
    }

    @Transient
    @Contract(value="_,_->this")
    public R<T> setI18nMessageIfOk(Boolean replace, Supplier<I18nAware> message) {
        return this.success ? this.setI18nMessage(replace, message.get()) : this;
    }

    @Transient
    @Contract(value="_,_->this")
    public R<T> setI18nMessageIfNg(Boolean replace, Supplier<I18nAware> message) {
        return this.success ? this : this.setI18nMessage(replace, message.get());
    }

    @Transient
    @Contract(value="_,_->this")
    public R<T> setI18nMessage(String i18nCode, Object ... args) {
        this.i18nCode = i18nCode;
        this.i18nArgs = args;
        return this;
    }

    @Transient
    @Contract(value="_,_->this")
    public R<T> setI18nMessageIfOk(String i18nCode, Object ... arg) {
        return this.success ? this.setI18nMessage(i18nCode, arg) : this;
    }

    @Transient
    @Contract(value="_,_->this")
    public R<T> setI18nMessageIfNg(String i18nCode, Object ... arg) {
        return this.success ? this : this.setI18nMessage(i18nCode, arg);
    }

    @Override
    @Nullable
    public T getData() {
        return (T)this.data;
    }

    @Contract(value="_->this")
    public R<T> setData(T data) {
        this.data = data;
        return this;
    }

    @Transient
    @Contract(value="_->this")
    public R<T> setDataIfOk(T data) {
        return this.success ? this.setData(data) : this;
    }

    @Transient
    @Contract(value="_->this")
    public R<T> setDataIfNg(T data) {
        return this.success ? this : this.setData(data);
    }

    @Transient
    @Contract(value="_->this")
    public R<T> setDataIfOk(@NotNull Supplier<T> data) {
        return this.success ? this.setData(data.get()) : this;
    }

    @Transient
    @Contract(value="_->this")
    public R<T> setDataIfNg(@NotNull Supplier<T> data) {
        return this.success ? this : this.setData(data.get());
    }

    @Override
    @Nullable
    public String getCode() {
        return this.code;
    }

    @Contract(value="_->this")
    public R<T> setCode(String code) {
        this.code = code;
        return this;
    }

    @Transient
    @Contract(value="_->this")
    public R<T> setCodeIfOk(String code) {
        return this.success ? this.setCode(code) : this;
    }

    @Transient
    @Contract(value="_->this")
    public R<T> setCodeIfNg(String code) {
        return this.success ? this : this.setCode(code);
    }

    @Contract(value="_->this")
    public R<T> setCode(CodeEnum code) {
        if (code != null) {
            this.code = code.getCode();
            this.message = code.getHint();
            this.i18nCode = code.getI18nCode();
        }
        return this;
    }

    @Transient
    @Contract(value="_->this")
    public R<T> setCodeIfOk(CodeEnum code) {
        return this.success ? this.setCode(code) : this;
    }

    @Transient
    @Contract(value="_->this")
    public R<T> setCodeIfNg(CodeEnum code) {
        return this.success ? this : this.setCode(code);
    }

    @Transient
    @Contract(value="_->this")
    public R<T> setCodeIfOk(@NotNull Supplier<CodeEnum> code) {
        return this.success ? this.setCode(code.get()) : this;
    }

    @Transient
    @Contract(value="_->this")
    public R<T> setCodeIfNg(@NotNull Supplier<CodeEnum> code) {
        return this.success ? this : this.setCode(code.get());
    }

    @Transient
    @Nullable
    public Object getCause() {
        return this.cause;
    }

    @Transient
    @Nullable
    public <E> E getCause(Class<E> type) {
        if (type != null && type.isInstance(this.cause)) {
            return (E)this.cause;
        }
        return null;
    }

    @Transient
    @Contract(value="_->this")
    public R<T> setCause(Object cause) {
        this.cause = cause;
        return this;
    }

    @Override
    @Transient
    @Nullable
    public String getI18nCode() {
        return this.i18nCode;
    }

    @Override
    @Transient
    @Nullable
    public Object[] getI18nArgs() {
        return this.i18nArgs;
    }

    @Override
    @Transient
    @Nullable
    public String getI18nHint() {
        return this.message;
    }

    @Contract(value="->this")
    public <S extends R<D>, D> S castType() {
        return (S)this;
    }

    @Contract(value="_->this")
    public <S extends R<D>, D> S castData(D data) {
        this.data = data;
        return (S)this;
    }

    @Contract(value="_->this")
    public <S extends R<D>, D> S castData(Function<T, D> fun) {
        this.data = fun.apply(this.data);
        return (S)this;
    }

    public String toString() {
        return "SimpleResult{success=" + this.success + (this.message == null ? "" : ", message='" + this.message + '\'') + (this.code == null ? "" : ", code='" + this.code + '\'') + (this.data == null ? "" : ", data=" + this.data) + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof R)) {
            return false;
        }
        R r = (R)o;
        return this.success == r.success && Objects.equals(this.message, r.message) && Objects.equals(this.code, r.code) && Objects.equals(this.data, r.data);
    }

    public int hashCode() {
        return Objects.hash(this.success, this.message, this.code, this.data);
    }

    public static <T> R<T> orMessage(boolean success, String okMessage, String ngMessage) {
        String message = success ? okMessage : ngMessage;
        return new R<Object>(success, message, null, null);
    }

    public static <T> R<T> orCode(boolean success, CodeEnum okCode, CodeEnum ngCode) {
        CodeEnum code = success ? okCode : ngCode;
        return new R<Object>(success, code, null);
    }

    public static <T> R<T> orCode(boolean success, String okCode, String ngCode) {
        String code = success ? okCode : ngCode;
        return new R<Object>(success, null, code, null);
    }

    public static <T> R<T> orData(boolean success, T okData, T ngData) {
        T data = success ? okData : ngData;
        return new R<T>(success, null, null, data);
    }

    public static <T> R<T> of(boolean success) {
        return new R<Object>(success, null, null, null);
    }

    public static <T> R<T> of(boolean success, String message) {
        return new R<Object>(success, message, null, null);
    }

    public static <T> R<T> of(boolean success, CodeEnum code) {
        return new R<Object>(success, code, null);
    }

    public static <T> R<T> of(boolean success, String message, String code) {
        return new R<Object>(success, message, code, null);
    }

    public static <T> R<T> of(boolean success, String message, String code, T data) {
        return new R<T>(success, message, code, data);
    }

    public static <T> R<T> of(boolean success, CodeEnum code, T data) {
        return new R<T>(success, code, data);
    }

    public static <T> R<T> of(boolean success, CodeEnum code, String message, T data) {
        return new R<T>(success, code, data).setMessage(message);
    }

    public static <T> R<T> OK() {
        return Immutable.OK;
    }

    public static <T> R<T> ok() {
        return new R<Object>(true, null, null, null);
    }

    public static <T> R<T> ok(String message) {
        return new R<Object>(true, message, null, null);
    }

    public static <T> R<T> ok(CodeEnum code) {
        return new R<Object>(true, code, null);
    }

    public static <T> R<T> ok(String message, T data) {
        return new R<T>(true, message, null, data);
    }

    public static <T> R<T> ok(String message, String code, T data) {
        return new R<T>(true, message, code, data);
    }

    public static <T> R<T> ok(CodeEnum code, T data) {
        return new R<T>(true, code, data);
    }

    public static <T> R<T> okCode(String code) {
        return new R<Object>(true, null, code, null);
    }

    public static <T> R<T> okCode(String code, String message) {
        return new R<Object>(true, message, code, null);
    }

    public static <T> R<T> okCode(CodeEnum code, String message) {
        return new R<Object>(true, code, null).setMessage(message);
    }

    public static <T> R<T> okData(T data) {
        return new R<T>(true, null, null, data);
    }

    public static <T> R<T> okData(T data, String code) {
        return new R<T>(true, null, code, data);
    }

    public static <T> R<T> NG() {
        return Immutable.NG;
    }

    public static <T> R<T> ng() {
        return new R<Object>(false, null, null, null);
    }

    public static <T> R<T> ng(String message) {
        return new R<Object>(false, message, null, null);
    }

    public static <T> R<T> ng(CodeEnum code) {
        return new R<Object>(false, code, null);
    }

    public static <T> R<T> ng(String message, String code) {
        return new R<Object>(false, message, code, null);
    }

    public static <T> R<T> ng(String message, String code, T data) {
        return new R<T>(false, message, code, data);
    }

    public static <T> R<T> ng(CodeEnum code, T data) {
        return new R<T>(false, code, data);
    }

    public static <T> R<T> ngCode(String code) {
        return new R<Object>(false, null, code, null);
    }

    public static <T> R<T> ngCode(String code, String message) {
        return new R<Object>(false, message, code, null);
    }

    public static <T> R<T> ngCode(CodeEnum code, String message) {
        return new R<Object>(false, code, null).setMessage(message);
    }

    public static <T> R<T> ngData(T data) {
        return new R<T>(false, null, null, data);
    }

    public static <T> R<T> ngData(T data, String code) {
        return new R<T>(false, null, code, data);
    }

    public static <T> R<T> ngData(T data, Throwable t) {
        Throwable r = R.ng(t);
        return ((R)((Object)r)).setData(data);
    }

    public static <T> R<T> ngData(T data, CodeEnum code) {
        return new R<T>(false, code, data);
    }

    public static <T> R<T> ng(Throwable t) {
        return R.ng(t, null, null);
    }

    public static <T> R<T> ng(Throwable t, String code) {
        return R.ng(t, code, null);
    }

    public static <T> R<T> ng(Throwable t, String code, String message) {
        if (message == null) {
            message = t.getMessage();
        }
        R<Object> tr = new R<Object>(false, message, code, null);
        tr.cause = t;
        if (t instanceof CodeException) {
            CodeException ce = (CodeException)t;
            if (code == null) {
                tr.code = ce.getCode();
            }
            tr.i18nCode = ce.getI18nCode();
            tr.i18nArgs = ce.getI18nArgs();
        }
        return tr;
    }

    public static <T> R<T> ng(Throwable t, CodeEnum code) {
        R<Object> tr = new R<Object>(false, code, null);
        tr.cause = t;
        return tr;
    }

    public static <T, S extends R<T>> S ng(S sr) {
        sr.setSuccess(false);
        return sr;
    }

    public static <T, S extends R<T>> S ng(S sr, String message) {
        sr.setSuccess(false);
        sr.setMessage(message);
        return sr;
    }

    public static <T, S extends R<T>> S ng(S sr, CodeEnum code) {
        sr.setSuccess(false);
        sr.setCode(code);
        return sr;
    }

    public static <T, S extends R<T>> S ng(S sr, String message, String code) {
        sr.setSuccess(false);
        sr.setMessage(message);
        sr.setCode(code);
        return sr;
    }

    public static <T, S extends R<T>> S ng(S sr, String message, String code, T data) {
        sr.setSuccess(false);
        sr.setMessage(message);
        sr.setCode(code);
        sr.setData(data);
        return sr;
    }

    public static <T, S extends R<T>> S ng(S sr, CodeEnum code, T data) {
        sr.setSuccess(false);
        sr.setCode(code);
        sr.setData(data);
        return sr;
    }

    public static <T, S extends R<T>> S ngCode(S sr, String code) {
        sr.setSuccess(false);
        sr.setCode(code);
        return sr;
    }

    public static <T, S extends R<T>> S ngCode(S sr, String code, String message) {
        sr.setSuccess(false);
        sr.setMessage(message);
        sr.setCode(code);
        return sr;
    }

    public static <T, S extends R<T>> S ngCode(S sr, CodeEnum code, String message) {
        sr.setSuccess(false);
        sr.setCode(code);
        sr.setMessage(message);
        return sr;
    }

    public static <T, S extends R<T>> S ngData(S sr, T data) {
        sr.setSuccess(false);
        sr.setData(data);
        return sr;
    }

    public static <T, S extends R<T>> S ngData(S sr, T data, String code) {
        sr.setSuccess(false);
        sr.setCode(code);
        sr.setData(data);
        return sr;
    }

    public static <T, S extends R<T>> S ngData(S sr, T data, Throwable t) {
        R.ng(sr, t, null, null);
        sr.setData(data);
        return sr;
    }

    public static <T, S extends R<T>> S ngData(S sr, T data, CodeEnum code) {
        sr.setSuccess(false);
        sr.setCode(code);
        sr.setData(data);
        return sr;
    }

    public static <T, S extends R<T>> S ng(S sr, Throwable t) {
        return R.ng(sr, t, null, null);
    }

    public static <T, S extends R<T>> S ng(S sr, Throwable t, String code) {
        return R.ng(sr, t, code, null);
    }

    public static <T, S extends R<T>> S ng(S sr, Throwable t, String code, String message) {
        if (message == null) {
            message = t.getMessage();
        }
        sr.setMessage(message);
        sr.setCode(code);
        sr.setCause(t);
        if (t instanceof CodeException) {
            CodeException ce = (CodeException)t;
            if (code == null) {
                sr.setCode(ce.getCode());
            }
            sr.setI18nMessage(ce.getI18nCode(), ce.getI18nArgs());
        }
        return sr;
    }

    public static <T, S extends R<T>> S ng(S sr, Throwable t, CodeEnum code) {
        sr.setSuccess(false);
        sr.setCause(t);
        sr.setCode(code);
        return sr;
    }

    public static class Immutable<T>
    extends R<T> {
        public static final R<Void> OK = new Immutable<Object>(true, null, null, null);
        public static final R<Void> NG = new Immutable<Object>(false, null, null, null);

        public Immutable(boolean success) {
            super(success);
        }

        public Immutable(boolean success, String message, String code, T data) {
            super(success, message, code, data);
        }

        public Immutable(boolean success, CodeEnum code, T data) {
            super(success, code, data);
        }

        public Immutable(boolean success, String message, String code, T data, Object cause, String i18nCode, Object ... i18nArgs) {
            super(success, message, code, data);
            this.cause = cause;
            this.i18nCode = i18nCode;
            this.i18nArgs = i18nArgs;
        }

        public Immutable(boolean success, CodeEnum code, T data, Object cause, Object ... i18nArgs) {
            super(success, code, data);
            this.cause = cause;
            this.i18nArgs = i18nArgs;
        }

        @Override
        public R<T> setSuccess(boolean success) {
            throw new UnsupportedOperationException("Immutable");
        }

        @Override
        public R<T> setMessage(String message) {
            throw new UnsupportedOperationException("Immutable");
        }

        @Override
        public R<T> setData(T data) {
            throw new UnsupportedOperationException("Immutable");
        }

        @Override
        public R<T> setCode(String code) {
            throw new UnsupportedOperationException("Immutable");
        }

        @Override
        public R<T> setCode(CodeEnum code) {
            throw new UnsupportedOperationException("Immutable");
        }

        @Override
        public R<T> setCause(Object cause) {
            throw new UnsupportedOperationException("Immutable");
        }

        @Override
        public R<T> setI18nMessage(Boolean replace, CodeEnum ce, Object ... arg) {
            throw new UnsupportedOperationException("Immutable");
        }

        @Override
        public R<T> setI18nMessage(Boolean replace, I18nAware message) {
            throw new UnsupportedOperationException("Immutable");
        }

        @Override
        public <S extends R<X>, X> S castData(X data) {
            throw new UnsupportedOperationException("Immutable");
        }

        @Override
        public <S extends R<D>, D> S castData(Function<T, D> fun) {
            throw new UnsupportedOperationException("Immutable");
        }
    }
}

