/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.mirana.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class Zipper {
    public static byte[] zip(List<File> files) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        Zipper.zip((OutputStream)bos, files);
        return bos.toByteArray();
    }

    public static void zip(String zip, List<File> files) throws IOException {
        File zipFile = new File(zip);
        File dir = zipFile.getParentFile();
        if (!dir.exists()) {
            dir.mkdirs();
        }
        Zipper.zip(Files.newOutputStream(zipFile.toPath(), new OpenOption[0]), files);
    }

    public static void zip(OutputStream out, List<File> files) throws IOException {
        HashMap<String, InputStream> map = new HashMap<String, InputStream>(files.size());
        for (File file : files) {
            map.put(file.getName(), Files.newInputStream(file.toPath(), new OpenOption[0]));
        }
        Zipper.zip(out, map);
    }

    public static byte[] zip(Map<String, InputStream> files) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        Zipper.zip((OutputStream)bos, files);
        return bos.toByteArray();
    }

    public static void zip(String zip, Map<String, InputStream> files) throws IOException {
        File zipFile = new File(zip);
        File dir = zipFile.getParentFile();
        if (!dir.exists()) {
            dir.mkdirs();
        }
        Zipper.zip(Files.newOutputStream(zipFile.toPath(), new OpenOption[0]), files);
    }

    public static void zip(OutputStream out, Map<String, InputStream> files) throws IOException {
        try (ZipOutputStream zout = new ZipOutputStream(out);){
            byte[] buffer = new byte[1024];
            for (Map.Entry<String, InputStream> file : files.entrySet()) {
                zout.putNextEntry(new ZipEntry(file.getKey()));
                try (InputStream in = file.getValue();){
                    int length;
                    while ((length = in.read(buffer)) > 0) {
                        zout.write(buffer, 0, length);
                    }
                }
                zout.flush();
                zout.closeEntry();
            }
            zout.flush();
        }
    }

    public static void unzip(String zip, String path) throws IOException {
        Zipper.unzip(Files.newInputStream(Paths.get(zip, new String[0]), new OpenOption[0]), path);
    }

    public static void unzip(InputStream zip, String path) throws IOException {
        File dir = new File(path);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        byte[] buffer = new byte[1024];
        try (ZipInputStream zis = new ZipInputStream(zip);){
            ZipEntry ze;
            while ((ze = zis.getNextEntry()) != null) {
                String fileName = ze.getName();
                File newFile = new File(dir, fileName);
                if (ze.isDirectory()) {
                    newFile.mkdirs();
                } else {
                    int len;
                    FileOutputStream fos = new FileOutputStream(newFile);
                    while ((len = zis.read(buffer)) > 0) {
                        fos.write(buffer, 0, len);
                    }
                    fos.close();
                }
                zis.closeEntry();
            }
            zip.close();
        }
    }

    public static Map<String, byte[]> unzip(InputStream zip) throws IOException {
        HashMap<String, byte[]> entries = new HashMap<String, byte[]>();
        byte[] buffer = new byte[1024];
        try (ZipInputStream zis = new ZipInputStream(zip);){
            ZipEntry ze;
            while ((ze = zis.getNextEntry()) != null) {
                int len;
                if (ze.isDirectory()) continue;
                String fileName = ze.getName();
                ByteArrayOutputStream fos = new ByteArrayOutputStream();
                while ((len = zis.read(buffer)) > 0) {
                    fos.write(buffer, 0, len);
                }
                fos.close();
                zis.closeEntry();
                entries.put(fileName, fos.toByteArray());
            }
            zis.closeEntry();
        }
        zip.close();
        return entries;
    }

    public static Map<String, byte[]> unzip(InputStream zip, String ... lowercaseExtName) throws IOException {
        Map<String, byte[]> unzip = Zipper.unzip(zip);
        HashMap<String, byte[]> result = new HashMap<String, byte[]>();
        Iterator<Map.Entry<String, byte[]>> iter = unzip.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<String, byte[]> entry = iter.next();
            String lcn = entry.getKey().toLowerCase();
            boolean deep = false;
            for (String s : lowercaseExtName) {
                if (!lcn.endsWith(s)) continue;
                deep = true;
                break;
            }
            if (deep) {
                iter.remove();
                Map<String, byte[]> sub = Zipper.unzip(new ByteArrayInputStream(entry.getValue()));
                result.putAll(sub);
                continue;
            }
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public static Z build() {
        return new Z();
    }

    public static class Z {
        final Map<String, InputStream> files = new HashMap<String, InputStream>();

        public Z add(String path) throws IOException {
            if (path == null) {
                return this;
            }
            return this.add(new File(path));
        }

        public Z add(File file) throws IOException {
            if (file == null) {
                return this;
            }
            return this.add(file.getName(), file);
        }

        public Z add(String name, String file) throws IOException {
            if (name == null || file == null) {
                return this;
            }
            return this.add(name, new File(file));
        }

        public Z add(String name, File file) throws IOException {
            if (name == null || file == null) {
                return this;
            }
            return this.add(file.getName(), Files.newInputStream(file.toPath(), new OpenOption[0]));
        }

        public Z add(String name, InputStream inputStream) {
            if (name == null || inputStream == null) {
                return this;
            }
            this.files.put(name, inputStream);
            return this;
        }

        public Map<String, InputStream> files() {
            return this.files;
        }

        public ByteArrayInputStream zip() throws IOException {
            return new ByteArrayInputStream(Zipper.zip(this.files));
        }

        public void zip(OutputStream out) throws IOException {
            Zipper.zip(out, this.files);
        }

        public void zip(String zip) throws IOException {
            Zipper.zip(zip, this.files);
        }
    }
}

