/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.mirana.lock;

import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jetbrains.annotations.NotNull;
import pro.fessional.mirana.lock.ArrayKey;
import pro.fessional.mirana.lock.GlobalLock;

public class JvmStaticGlobalLock
implements GlobalLock {
    private static final Map<Hd, WeakReference<Hd>> WeakLocks = new WeakHashMap<Hd, WeakReference<Hd>>();

    @Override
    @NotNull
    public Lock getLock(@NotNull String name) {
        return JvmStaticGlobalLock.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static Lock get(Object ... key) {
        Hd hd = key.length == 1 && key[0] instanceof ArrayKey ? new Hd((ArrayKey)key[0]) : new Hd(key);
        Map<Hd, WeakReference<Hd>> map = WeakLocks;
        synchronized (map) {
            WeakReference rf = WeakLocks.computeIfAbsent(hd, WeakReference::new);
            Hd lk = (Hd)rf.get();
            if (lk == null) {
                throw new IllegalStateException("should not gc if key exist, please report a bug to https://github.com/trydofor/pro.fessional.mirana/issues/new");
            }
            return lk;
        }
    }

    @NotNull
    public static GlobalLock.AutoLock autolock(Object ... key) {
        return new GlobalLock.AutoLock(JvmStaticGlobalLock.get(key));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int countLocks() {
        Map<Hd, WeakReference<Hd>> map = WeakLocks;
        synchronized (map) {
            return WeakLocks.size();
        }
    }

    public static class Hd
    extends ReentrantLock {
        private final ArrayKey arrayKey;

        public Hd(ArrayKey key) {
            this.arrayKey = key;
        }

        public Hd(Object ... keys) {
            this.arrayKey = new ArrayKey(keys);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Hd hd = (Hd)o;
            return this.arrayKey.equals(hd.arrayKey);
        }

        public int hashCode() {
            return this.arrayKey.hashCode();
        }
    }
}

