/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.mirana.math;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.DoubleSupplier;
import java.util.function.Function;
import java.util.function.IntSupplier;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pro.fessional.mirana.data.Null;

public class BigDecimalUtil {
    private static final MathContext MC = MathContext.DECIMAL32;

    @NotNull
    public static String string(BigDecimal num) {
        return BigDecimalUtil.string(num, "");
    }

    @NotNull
    public static String string(BigDecimal num, int scale) {
        BigDecimal dec = BigDecimalUtil.ceil(num, scale);
        return dec.toPlainString();
    }

    public static String string(BigDecimal num, String elze) {
        if (num == null) {
            return elze;
        }
        return num.toPlainString();
    }

    @NotNull
    public static String string(BigDecimal num, boolean strip) {
        return BigDecimalUtil.string(num, "", strip);
    }

    @NotNull
    public static String string(BigDecimal num, int scale, boolean strip) {
        BigDecimal dec = BigDecimalUtil.ceil(num, scale);
        return BigDecimalUtil.string(dec, "", strip);
    }

    public static String string(BigDecimal num, String elze, boolean strip) {
        if (num == null) {
            return elze;
        }
        return strip ? num.stripTrailingZeros().toPlainString() : num.toPlainString();
    }

    @NotNull
    public static BigDecimal object(int num) {
        return new BigDecimal(num);
    }

    @NotNull
    public static BigDecimal object(long num) {
        return new BigDecimal(num);
    }

    @NotNull
    public static BigDecimal object(double num) {
        return BigDecimal.valueOf(num);
    }

    @Contract(value="!null -> !null")
    public static BigDecimal object(Object num) {
        return BigDecimalUtil.object(num, (BigDecimal)null);
    }

    @Contract(value="_, !null -> !null")
    public static BigDecimal object(Object num, BigDecimal elze) {
        return BigDecimalUtil.object(num, elze, false);
    }

    @Contract(value="_, !null -> !null")
    public static BigDecimal object(Object num, Supplier<BigDecimal> elze) {
        return BigDecimalUtil.object(num, elze, false);
    }

    @Contract(value="_, !null, _ -> !null")
    public static BigDecimal object(Object num, BigDecimal elze, boolean fail) {
        BigDecimal rv = BigDecimalUtil.object(num, fail);
        return rv != null ? rv : elze;
    }

    @Contract(value="_, !null, _ -> !null")
    public static BigDecimal object(Object num, Supplier<BigDecimal> elze, boolean fail) {
        BigDecimal rv = BigDecimalUtil.object(num, fail);
        return rv != null ? rv : elze.get();
    }

    private static BigDecimal object(Object num, boolean fail) {
        try {
            if (num == null) {
                return null;
            }
            if (num instanceof Long) {
                return new BigDecimal((Long)num);
            }
            if (num instanceof BigDecimal) {
                return (BigDecimal)num;
            }
            if (num instanceof CharSequence) {
                return new BigDecimal(((CharSequence)num).toString());
            }
            if (num instanceof Supplier) {
                return BigDecimalUtil.object(((Supplier)num).get(), fail);
            }
            if (num instanceof Integer) {
                return new BigDecimal((Integer)num);
            }
            if (num instanceof Double) {
                return BigDecimal.valueOf((Double)num);
            }
            if (num instanceof Float) {
                return BigDecimal.valueOf(((Float)num).floatValue());
            }
            if (num instanceof BigInteger) {
                return new BigDecimal((BigInteger)num);
            }
            if (num instanceof IntSupplier) {
                return BigDecimalUtil.object((Object)((IntSupplier)num).getAsInt(), fail);
            }
            if (num instanceof LongSupplier) {
                return BigDecimalUtil.object((Object)((LongSupplier)num).getAsLong(), fail);
            }
            if (num instanceof DoubleSupplier) {
                return BigDecimalUtil.object((Object)((DoubleSupplier)num).getAsDouble(), fail);
            }
            String str = num.toString();
            return new BigDecimal(str);
        }
        catch (Exception e) {
            if (fail) {
                throw e;
            }
            return null;
        }
    }

    @NotNull
    public static BigDecimal[] objects(BigDecimal elze, Object ... nums) {
        if (nums == null || nums.length == 0) {
            return Null.BigDecimals;
        }
        BigDecimal[] arr = new BigDecimal[nums.length];
        for (int i = 0; i < nums.length; ++i) {
            arr[i] = BigDecimalUtil.object(nums[i], elze, false);
        }
        return arr;
    }

    @NotNull
    public static BigDecimal notNull(Object ... nums) {
        Object s;
        BigDecimal d = null;
        Object[] objectArray = nums;
        int n = objectArray.length;
        for (int i = 0; i < n && (d = BigDecimalUtil.object(s = objectArray[i])) == null; ++i) {
        }
        return Objects.requireNonNull(d);
    }

    @NotNull
    public static BigDecimal ifElse(boolean cond, Object a, Object b) {
        BigDecimal d = cond ? BigDecimalUtil.object(a) : BigDecimalUtil.object(b);
        return Objects.requireNonNull(d);
    }

    @NotNull
    public static BigDecimal ifElse(boolean cond, Supplier<?> a, Supplier<?> b) {
        BigDecimal d = cond ? BigDecimalUtil.object(a) : BigDecimalUtil.object(b);
        return Objects.requireNonNull(d);
    }

    @NotNull
    public static BigDecimal avg(Object ... nums) {
        BigDecimal total = BigDecimalUtil.avgNull(nums);
        return Objects.requireNonNull(total);
    }

    @NotNull
    public static BigDecimal avgMap(Iterable<?> nums) {
        BigDecimal total = BigDecimalUtil.avgMapNull(nums);
        return Objects.requireNonNull(total);
    }

    @NotNull
    public static <T> BigDecimal avgMap(Iterable<T> nums, Function<? super T, ?> mapper) {
        BigDecimal total = BigDecimalUtil.avgMapNull(nums, mapper);
        return Objects.requireNonNull(total);
    }

    @Nullable
    public static BigDecimal avgNull(Object ... nums) {
        if (nums == null) {
            return null;
        }
        return BigDecimalUtil.avgMapNull(Arrays.asList(nums));
    }

    @Nullable
    public static BigDecimal avgMapNull(Iterable<?> nums) {
        BigDecimal total = null;
        int count = 0;
        for (Object e : nums) {
            BigDecimal d = BigDecimalUtil.object(e);
            if (d == null) continue;
            total = total == null ? d : total.add(d, MC);
            ++count;
        }
        return total == null ? null : total.divide(new BigDecimal(count), MC);
    }

    @Nullable
    public static <T> BigDecimal avgMapNull(Iterable<T> nums, Function<? super T, ?> mapper) {
        BigDecimal total = null;
        int count = 0;
        for (T e : nums) {
            Object m = mapper.apply(e);
            BigDecimal d = BigDecimalUtil.object(m);
            if (d == null) continue;
            total = total == null ? d : total.add(d, MC);
            ++count;
        }
        return total == null ? null : total.divide(new BigDecimal(count), MC);
    }

    @NotNull
    public static BigDecimal max(Object ... nums) {
        BigDecimal max = BigDecimalUtil.maxNull(nums);
        return Objects.requireNonNull(max);
    }

    @NotNull
    public static BigDecimal maxMap(Iterable<?> cols) {
        BigDecimal max = BigDecimalUtil.maxMapNull(cols);
        return Objects.requireNonNull(max);
    }

    @NotNull
    public static <T> BigDecimal maxMap(Iterable<T> cols, Function<? super T, ?> mapper) {
        BigDecimal max = BigDecimalUtil.maxMapNull(cols, mapper);
        return Objects.requireNonNull(max);
    }

    @Nullable
    public static BigDecimal maxNull(Object ... nums) {
        if (nums == null) {
            return null;
        }
        return BigDecimalUtil.maxMapNull(Arrays.asList(nums));
    }

    @Nullable
    public static BigDecimal maxMapNull(Iterable<?> cols) {
        if (cols == null) {
            return null;
        }
        BigDecimal max = null;
        for (Object e : cols) {
            BigDecimal d = BigDecimalUtil.object(e);
            if (d == null) continue;
            max = max == null ? d : max.max(d);
        }
        return max;
    }

    @Nullable
    public static <T> BigDecimal maxMapNull(Iterable<T> cols, Function<? super T, ?> mapper) {
        if (cols == null) {
            return null;
        }
        BigDecimal max = null;
        for (T e : cols) {
            Object m = mapper.apply(e);
            BigDecimal d = BigDecimalUtil.object(m);
            if (d == null) continue;
            max = max == null ? d : max.max(d);
        }
        return max;
    }

    @NotNull
    public static BigDecimal min(Object ... nums) {
        BigDecimal min = BigDecimalUtil.minNull(nums);
        return Objects.requireNonNull(min);
    }

    @NotNull
    public static BigDecimal minMap(Iterable<?> cols) {
        BigDecimal min = BigDecimalUtil.minMapNull(cols);
        return Objects.requireNonNull(min);
    }

    @NotNull
    public static <T> BigDecimal minMap(Iterable<T> cols, Function<? super T, ?> mapper) {
        BigDecimal min = BigDecimalUtil.minMapNull(cols, mapper);
        return Objects.requireNonNull(min);
    }

    @Nullable
    public static BigDecimal minNull(Object ... nums) {
        if (nums == null) {
            return null;
        }
        return BigDecimalUtil.minMapNull(Arrays.asList(nums));
    }

    @Nullable
    public static BigDecimal minMapNull(Iterable<?> cols) {
        if (cols == null) {
            return null;
        }
        BigDecimal min = null;
        for (Object e : cols) {
            BigDecimal d = BigDecimalUtil.object(e);
            if (d == null) continue;
            min = min == null ? d : min.min(d);
        }
        return min;
    }

    @Nullable
    public static <T> BigDecimal minMapNull(Iterable<T> cols, Function<? super T, ?> mapper) {
        if (cols == null) {
            return null;
        }
        BigDecimal min = null;
        for (T e : cols) {
            Object m = mapper.apply(e);
            BigDecimal d = BigDecimalUtil.object(m);
            if (d == null) continue;
            min = min == null ? d : min.min(d);
        }
        return min;
    }

    @NotNull
    public static BigDecimal sum(Object a, Object b, Object ... nums) {
        return BigDecimalUtil.addElse(BigDecimal.ZERO, a, b, nums);
    }

    @NotNull
    public static BigDecimal sumMap(Iterable<?> nums) {
        return BigDecimalUtil.addMapElse(BigDecimal.ZERO, nums);
    }

    @NotNull
    public static <T> BigDecimal sumMap(Iterable<T> nums, Function<? super T, ?> mapper) {
        return BigDecimalUtil.addMapElse(BigDecimal.ZERO, nums, mapper);
    }

    @NotNull
    public static BigDecimal add(Object a, int b) {
        BigDecimal x = BigDecimalUtil.object(a);
        return x == null ? BigDecimalUtil.object(b) : x.add(BigDecimalUtil.object(b), MC);
    }

    @NotNull
    public static BigDecimal add(Object a, long b) {
        BigDecimal x = BigDecimalUtil.object(a);
        return x == null ? BigDecimalUtil.object(b) : x.add(BigDecimalUtil.object(b), MC);
    }

    @NotNull
    public static BigDecimal add(Object a, double b) {
        BigDecimal x = BigDecimalUtil.object(a);
        return x == null ? BigDecimalUtil.object(b) : x.add(BigDecimalUtil.object(b), MC);
    }

    @NotNull
    public static BigDecimal add(Object a, Object b) {
        BigDecimal t = BigDecimalUtil.addNull(a, b);
        return Objects.requireNonNull(t);
    }

    @NotNull
    public static BigDecimal add(Object a, Object b, Object ... nums) {
        BigDecimal t = BigDecimalUtil.addNull(a, b, nums);
        return Objects.requireNonNull(t);
    }

    @NotNull
    public static BigDecimal addMap(Iterable<?> nums) {
        BigDecimal t = BigDecimalUtil.addMapNull(nums);
        return Objects.requireNonNull(t);
    }

    @NotNull
    public static <T> BigDecimal addMap(Iterable<T> nums, Function<? super T, ?> mapper) {
        BigDecimal t = BigDecimalUtil.addMapNull(nums, mapper);
        return Objects.requireNonNull(t);
    }

    @Contract(value="!null,_,_ -> !null")
    public static BigDecimal addElse(BigDecimal elze, Object a, Object b) {
        BigDecimal t = BigDecimalUtil.addNull(a, b);
        return t == null ? elze : t;
    }

    @Contract(value="!null,_,_,_ -> !null")
    public static BigDecimal addElse(BigDecimal elze, Object a, Object b, Object ... nums) {
        BigDecimal t = BigDecimalUtil.addNull(a, b, nums);
        return t == null ? elze : t;
    }

    @Contract(value="!null,_ -> !null")
    public static BigDecimal addMapElse(BigDecimal elze, Iterable<?> nums) {
        BigDecimal t = BigDecimalUtil.addMapNull(nums);
        return t == null ? elze : t;
    }

    @Contract(value="!null,_,_ -> !null")
    public static <T> BigDecimal addMapElse(BigDecimal elze, Iterable<T> nums, Function<? super T, ?> mapper) {
        BigDecimal t = BigDecimalUtil.addMapNull(nums, mapper);
        return t == null ? elze : t;
    }

    @Nullable
    public static BigDecimal addNull(Object a, Object b) {
        BigDecimal x = BigDecimalUtil.object(a);
        BigDecimal y = BigDecimalUtil.object(b);
        if (x == null) {
            return y;
        }
        return y == null ? x : x.add(y, MC);
    }

    @Nullable
    public static BigDecimal addNull(Object a, Object b, Object ... nums) {
        BigDecimal t = BigDecimalUtil.addNull(a, b);
        if (nums == null) {
            return t;
        }
        for (Object num : nums) {
            BigDecimal n = BigDecimalUtil.object(num);
            if (n == null) continue;
            t = t == null ? n : t.add(n, MC);
        }
        return t;
    }

    @Nullable
    public static BigDecimal addMapNull(Iterable<?> nums) {
        if (nums == null) {
            return null;
        }
        BigDecimal t = null;
        for (Object e : nums) {
            BigDecimal d = BigDecimalUtil.object(e);
            if (d == null) continue;
            t = t == null ? d : t.add(d, MC);
        }
        return t;
    }

    @Nullable
    public static <T> BigDecimal addMapNull(Iterable<T> nums, Function<? super T, ?> mapper) {
        if (nums == null) {
            return null;
        }
        BigDecimal t = null;
        for (T e : nums) {
            Object m = mapper.apply(e);
            BigDecimal d = BigDecimalUtil.object(m);
            if (d == null) continue;
            t = t == null ? d : t.add(d, MC);
        }
        return t;
    }

    @NotNull
    public static BigDecimal sub(Object a, int b) {
        BigDecimal t = Objects.requireNonNull(BigDecimalUtil.object(a));
        return t.subtract(BigDecimalUtil.object(b), MC);
    }

    @NotNull
    public static BigDecimal sub(Object a, long b) {
        BigDecimal t = Objects.requireNonNull(BigDecimalUtil.object(a));
        return t.subtract(BigDecimalUtil.object(b), MC);
    }

    @NotNull
    public static BigDecimal sub(Object a, double b) {
        BigDecimal t = Objects.requireNonNull(BigDecimalUtil.object(a));
        return t.subtract(BigDecimalUtil.object(b), MC);
    }

    @NotNull
    public static BigDecimal sub(Object a, Object b) {
        BigDecimal t = Objects.requireNonNull(BigDecimalUtil.object(a));
        BigDecimal x = BigDecimalUtil.object(b);
        return x == null ? t : t.subtract(x, MC);
    }

    @NotNull
    public static BigDecimal sub(Object a, Object b, Object ... nums) {
        BigDecimal t = BigDecimalUtil.sub(a, b);
        if (nums == null) {
            return t;
        }
        return BigDecimalUtil.subMap(t, Arrays.asList(nums));
    }

    @NotNull
    public static BigDecimal subMap(Object a, Iterable<?> nums) {
        BigDecimal t = Objects.requireNonNull(BigDecimalUtil.object(a));
        if (nums == null) {
            return t;
        }
        for (Object e : nums) {
            BigDecimal d = BigDecimalUtil.object(e);
            if (d == null) continue;
            t = t.subtract(d, MC);
        }
        return t;
    }

    @NotNull
    public static <T> BigDecimal subMap(Object a, Iterable<T> nums, Function<? super T, ?> mapper) {
        BigDecimal t = Objects.requireNonNull(BigDecimalUtil.object(a));
        if (nums == null) {
            return t;
        }
        for (T e : nums) {
            Object m = mapper.apply(e);
            BigDecimal d = BigDecimalUtil.object(m);
            if (d == null) continue;
            t = t.subtract(d, MC);
        }
        return t;
    }

    @NotNull
    public static BigDecimal prd(Object a, Object b, Object ... nums) {
        return BigDecimalUtil.mulElse(BigDecimal.ZERO, a, b, nums);
    }

    @NotNull
    public static BigDecimal prdMap(Iterable<?> cols) {
        return BigDecimalUtil.mulMapElse(BigDecimal.ZERO, cols);
    }

    @NotNull
    public static <T> BigDecimal prdMap(Iterable<T> cols, Function<? super T, ?> mapper) {
        return BigDecimalUtil.mulMapElse(BigDecimal.ZERO, cols, mapper);
    }

    @NotNull
    public static BigDecimal mul(Object a, int b) {
        BigDecimal x = BigDecimalUtil.object(a);
        return x == null ? BigDecimalUtil.object(b) : x.multiply(BigDecimalUtil.object(b), MC);
    }

    @NotNull
    public static BigDecimal mul(Object a, long b) {
        BigDecimal x = BigDecimalUtil.object(a);
        return x == null ? BigDecimalUtil.object(b) : x.multiply(BigDecimalUtil.object(b), MC);
    }

    @NotNull
    public static BigDecimal mul(Object a, double b) {
        BigDecimal x = BigDecimalUtil.object(a);
        return x == null ? BigDecimalUtil.object(b) : x.multiply(BigDecimalUtil.object(b), MC);
    }

    @NotNull
    public static BigDecimal mul(Object a, Object b) {
        BigDecimal t = BigDecimalUtil.mulNull(a, b);
        return Objects.requireNonNull(t);
    }

    @NotNull
    public static BigDecimal mul(Object a, Object b, Object ... nums) {
        BigDecimal t = BigDecimalUtil.mulNull(a, b, nums);
        return Objects.requireNonNull(t);
    }

    @NotNull
    public static BigDecimal mulMap(Iterable<?> cols) {
        BigDecimal t = BigDecimalUtil.mulMapNull(cols);
        return Objects.requireNonNull(t);
    }

    @NotNull
    public static <T> BigDecimal mulMap(Iterable<T> cols, Function<? super T, ?> mapper) {
        BigDecimal t = BigDecimalUtil.mulMapNull(cols, mapper);
        return Objects.requireNonNull(t);
    }

    @Contract(value="!null,_,_ -> !null")
    public static BigDecimal mulElse(BigDecimal elze, Object a, Object b) {
        BigDecimal t = BigDecimalUtil.mulNull(a, b);
        return t == null ? elze : t;
    }

    @Contract(value="!null,_,_,_ -> !null")
    public static BigDecimal mulElse(BigDecimal elze, Object a, Object b, Object ... nums) {
        BigDecimal t = BigDecimalUtil.mulNull(a, b, nums);
        return t == null ? elze : t;
    }

    @Contract(value="!null,_ -> !null")
    public static <T> BigDecimal mulMapElse(BigDecimal elze, Iterable<T> cols) {
        BigDecimal t = BigDecimalUtil.mulMapNull(cols);
        return t == null ? elze : t;
    }

    @Contract(value="!null,_,_ -> !null")
    public static <T> BigDecimal mulMapElse(BigDecimal elze, Iterable<T> cols, Function<? super T, ?> mapper) {
        BigDecimal t = BigDecimalUtil.mulMapNull(cols, mapper);
        return t == null ? elze : t;
    }

    @Nullable
    public static BigDecimal mulNull(Object a, Object b) {
        BigDecimal x = BigDecimalUtil.object(a);
        BigDecimal y = BigDecimalUtil.object(b);
        if (x == null) {
            return y;
        }
        return y == null ? x : x.multiply(y, MC);
    }

    @Nullable
    public static BigDecimal mulNull(Object a, Object b, Object ... nums) {
        BigDecimal t = BigDecimalUtil.mulNull(a, b);
        if (nums == null) {
            return t;
        }
        for (Object num : nums) {
            BigDecimal d = BigDecimalUtil.object(num);
            if (d == null) continue;
            t = t == null ? d : t.multiply(d, MC);
        }
        return t;
    }

    @Nullable
    public static BigDecimal mulMapNull(Iterable<?> cols) {
        if (cols == null) {
            return null;
        }
        BigDecimal t = null;
        for (Object e : cols) {
            BigDecimal d = BigDecimalUtil.object(e);
            if (d == null) continue;
            t = t == null ? d : t.multiply(d, MC);
        }
        return t;
    }

    @Nullable
    public static <T> BigDecimal mulMapNull(Iterable<T> cols, Function<? super T, ?> mapper) {
        if (cols == null) {
            return null;
        }
        BigDecimal t = null;
        for (T e : cols) {
            Object m = mapper.apply(e);
            BigDecimal d = BigDecimalUtil.object(m);
            if (d == null) continue;
            t = t == null ? d : t.multiply(d, MC);
        }
        return t;
    }

    @NotNull
    public static BigDecimal div(Object a, int b) {
        BigDecimal t = Objects.requireNonNull(BigDecimalUtil.object(a));
        return t.divide(BigDecimalUtil.object(b), MC);
    }

    @NotNull
    public static BigDecimal div(Object a, long b) {
        BigDecimal t = Objects.requireNonNull(BigDecimalUtil.object(a));
        return t.divide(BigDecimalUtil.object(b), MC);
    }

    @NotNull
    public static BigDecimal div(Object a, double b) {
        BigDecimal t = Objects.requireNonNull(BigDecimalUtil.object(a));
        return t.divide(BigDecimalUtil.object(b), MC);
    }

    @NotNull
    public static BigDecimal div(Object a, Object b) {
        BigDecimal t = Objects.requireNonNull(BigDecimalUtil.object(a));
        BigDecimal x = BigDecimalUtil.object(b);
        return x == null ? t : t.divide(x, MC);
    }

    @NotNull
    public static BigDecimal div(Object a, Object b, Object ... nums) {
        BigDecimal t = BigDecimalUtil.div(a, b);
        if (nums == null) {
            return t;
        }
        return BigDecimalUtil.divMap(t, Arrays.asList(nums));
    }

    @NotNull
    public static BigDecimal divMap(Object a, Iterable<?> cols) {
        BigDecimal t = Objects.requireNonNull(BigDecimalUtil.object(a));
        if (cols == null) {
            return t;
        }
        for (Object e : cols) {
            BigDecimal d = BigDecimalUtil.object(e);
            if (d == null) continue;
            t = t.divide(d, MC);
        }
        return t;
    }

    @NotNull
    public static <T> BigDecimal divMap(Object a, Iterable<T> cols, Function<? super T, ?> mapper) {
        BigDecimal t = Objects.requireNonNull(BigDecimalUtil.object(a));
        if (cols == null) {
            return t;
        }
        for (T e : cols) {
            Object m = mapper.apply(e);
            BigDecimal d = BigDecimalUtil.object(m);
            if (d == null) continue;
            t = t.divide(d, MC);
        }
        return t;
    }

    @NotNull
    public static BigDecimal pow(Object num, int n) {
        BigDecimal d = BigDecimalUtil.powNull(num, n);
        return Objects.requireNonNull(d);
    }

    public static BigDecimal powNull(Object num, int n) {
        BigDecimal d = BigDecimalUtil.object(num);
        return d == null ? null : d.pow(n, MC);
    }

    @NotNull
    public static BigDecimal neg(Object num) {
        BigDecimal d = BigDecimalUtil.negNull(num);
        return Objects.requireNonNull(d);
    }

    @Nullable
    public static BigDecimal negNull(Object num) {
        BigDecimal d = BigDecimalUtil.object(num);
        return d == null ? null : d.negate(MC);
    }

    @NotNull
    public static BigDecimal ceil(Object num, int scale) {
        return BigDecimalUtil.scale(num, scale, RoundingMode.CEILING);
    }

    @NotNull
    public static BigDecimal floor(Object num, int scale) {
        return BigDecimalUtil.scale(num, scale, RoundingMode.FLOOR);
    }

    @NotNull
    public static BigDecimal round(Object num, int scale) {
        return BigDecimalUtil.scale(num, scale, RoundingMode.HALF_UP);
    }

    @NotNull
    public static BigDecimal scale(Object num, int scale, RoundingMode mode) {
        BigDecimal d = BigDecimalUtil.object(num);
        if (d == null) {
            return BigDecimal.ZERO.setScale(scale, mode);
        }
        if (d.scale() == scale) {
            return d;
        }
        return d.setScale(scale + 1, RoundingMode.FLOOR).setScale(scale, mode);
    }

    @NotNull
    public static BigDecimal unitUp(Object num, @NotNull BigDecimal unit, @NotNull BigDecimal accuracy) {
        BigDecimal d = BigDecimalUtil.object(num, BigDecimal.ZERO);
        BigDecimal[] dr = d.divideAndRemainder(unit);
        d = dr[0].multiply(unit);
        int unitScale = unit.scale();
        if (BigDecimalUtil.compareTo(dr[1], accuracy, unitScale, RoundingMode.FLOOR) > 0) {
            d = d.add(unit);
        }
        if (d.scale() != unitScale) {
            d = d.setScale(unitScale, RoundingMode.FLOOR);
        }
        return d;
    }

    @NotNull
    public static BigDecimal unitDown(Object num, @NotNull BigDecimal unit, @NotNull BigDecimal accuracy) {
        BigDecimal d = BigDecimalUtil.object(num, BigDecimal.ZERO);
        BigDecimal[] dr = d.divideAndRemainder(unit);
        d = dr[0].multiply(unit);
        int unitScale = unit.scale();
        if (BigDecimalUtil.compareTo(dr[1], unit.subtract(accuracy), unitScale, RoundingMode.FLOOR) > 0) {
            d = d.add(unit);
        }
        if (d.scale() != unitScale) {
            d = d.setScale(unitScale, RoundingMode.FLOOR);
        }
        return d;
    }

    public static int compareTo(Object a, Object b) {
        BigDecimal x = BigDecimalUtil.object(a);
        BigDecimal y = BigDecimalUtil.object(b);
        if (x == null && y == null) {
            return 0;
        }
        if (x == null) {
            return -1;
        }
        if (y == null) {
            return 1;
        }
        return x.compareTo(y);
    }

    public static int compareTo(Object a, Object b, int scale, RoundingMode mode) {
        BigDecimal x = BigDecimalUtil.object(a);
        BigDecimal y = BigDecimalUtil.object(b);
        if (x == null && y == null) {
            return 0;
        }
        if (x == null) {
            return -1;
        }
        if (y == null) {
            return 1;
        }
        if (x.scale() > scale) {
            x = BigDecimalUtil.scale(x, scale, mode);
        }
        if (y.scale() > scale) {
            y = BigDecimalUtil.scale(y, scale, mode);
        }
        return x.compareTo(y);
    }

    public static boolean equalsValue(Object a, Object b) {
        return BigDecimalUtil.compareTo(a, b) == 0;
    }

    public static boolean equalsValue(Object a, Object b, int scale, RoundingMode mode) {
        return BigDecimalUtil.compareTo(a, b, scale, mode) == 0;
    }

    @NotNull
    public static W w(Object v) {
        return new W(BigDecimalUtil.object(v));
    }

    @NotNull
    public static W w(BigDecimal v, int scale) {
        W w = BigDecimalUtil.w(v);
        return w.setScale(scale);
    }

    public static class W {
        private BigDecimal value;
        private int scale;

        public W(@NotNull BigDecimal d) {
            this.value = d;
            this.scale = d.scale();
        }

        @NotNull
        public BigDecimal result(RoundingMode mode) {
            return this.value.setScale(this.scale, mode);
        }

        @NotNull
        public BigDecimal resultRaw() {
            return this.value;
        }

        @NotNull
        public BigDecimal resultCeil() {
            return BigDecimalUtil.ceil(this.value, this.scale);
        }

        @NotNull
        public BigDecimal resultRound() {
            return BigDecimalUtil.round(this.value, this.scale);
        }

        @NotNull
        public BigDecimal resultFloor() {
            return BigDecimalUtil.floor(this.value, this.scale);
        }

        @NotNull
        public BigDecimal resultUnitUp(@NotNull BigDecimal unit, @NotNull BigDecimal accuracy) {
            return BigDecimalUtil.unitUp(this.value, unit, accuracy);
        }

        @NotNull
        public BigDecimal resultUnitDown(@NotNull BigDecimal unit, @NotNull BigDecimal accuracy) {
            return BigDecimalUtil.unitDown(this.value, unit, accuracy);
        }

        @NotNull
        public BigDecimal result(int scale, RoundingMode mode) {
            return this.value.setScale(scale, mode);
        }

        @NotNull
        public BigDecimal resultCeil(int scale) {
            return BigDecimalUtil.ceil(this.value, scale);
        }

        @NotNull
        public BigDecimal resultRound(int scale) {
            return BigDecimalUtil.round(this.value, scale);
        }

        @NotNull
        public BigDecimal resultFloor(int scale) {
            return BigDecimalUtil.floor(this.value, scale);
        }

        @Contract(value="_->this")
        public W setScale(int scale) {
            this.scale = scale;
            return this;
        }

        @Contract(value="_->this")
        public W setValue(Object ... value) {
            this.value = BigDecimalUtil.notNull(value);
            return this;
        }

        @Contract(value="_->this")
        public W add(int a) {
            this.value = BigDecimalUtil.add((Object)this.value, a);
            return this;
        }

        @Contract(value="_->this")
        public W add(long a) {
            this.value = BigDecimalUtil.add((Object)this.value, a);
            return this;
        }

        @Contract(value="_->this")
        public W add(double a) {
            this.value = BigDecimalUtil.add((Object)this.value, a);
            return this;
        }

        @Contract(value="_->this")
        public W add(Object a) {
            this.value = BigDecimalUtil.add((Object)this.value, a);
            return this;
        }

        @Contract(value="_,_->this")
        public W add(Object a, Object ... num) {
            this.value = BigDecimalUtil.add(this.value, a, num);
            return this;
        }

        @Contract(value="_,_,_->this")
        public W addIf(boolean c, Object a, Object b) {
            BigDecimal num = c ? BigDecimalUtil.object(a) : BigDecimalUtil.object(b);
            this.value = BigDecimalUtil.add((Object)this.value, num);
            return this;
        }

        @Contract(value="_,_,_->this")
        public W addIf(boolean c, Supplier<?> a, Supplier<?> b) {
            BigDecimal num = c ? BigDecimalUtil.object(a) : BigDecimalUtil.object(b);
            this.value = BigDecimalUtil.add((Object)this.value, num);
            return this;
        }

        @Contract(value="_->this")
        public W addMap(Iterable<?> cols) {
            BigDecimal x = BigDecimalUtil.addMapNull(cols);
            this.value = BigDecimalUtil.add((Object)this.value, x);
            return this;
        }

        @Contract(value="_,_->this")
        public <T> W addMap(Iterable<T> cols, Function<? super T, ?> mapper) {
            BigDecimal x = BigDecimalUtil.addMapNull(cols, mapper);
            this.value = BigDecimalUtil.add((Object)this.value, x);
            return this;
        }

        @Contract(value="_->this")
        public W sub(int a) {
            this.value = BigDecimalUtil.sub((Object)this.value, a);
            return this;
        }

        @Contract(value="_->this")
        public W sub(long a) {
            this.value = BigDecimalUtil.sub((Object)this.value, a);
            return this;
        }

        @Contract(value="_->this")
        public W sub(double a) {
            this.value = BigDecimalUtil.sub((Object)this.value, a);
            return this;
        }

        @Contract(value="_->this")
        public W sub(Object a) {
            this.value = BigDecimalUtil.sub((Object)this.value, a);
            return this;
        }

        @Contract(value="_,_->this")
        public W sub(Object a, Object ... num) {
            this.value = BigDecimalUtil.sub(this.value, a, num);
            return this;
        }

        @Contract(value="_,_,_->this")
        public W subIf(boolean c, Object a, Object b) {
            BigDecimal num = c ? BigDecimalUtil.object(a) : BigDecimalUtil.object(b);
            this.value = BigDecimalUtil.sub((Object)this.value, num);
            return this;
        }

        @Contract(value="_,_,_->this")
        public W subIf(boolean c, Supplier<?> a, Supplier<?> b) {
            BigDecimal num = c ? BigDecimalUtil.object(a) : BigDecimalUtil.object(b);
            this.value = BigDecimalUtil.sub((Object)this.value, num);
            return this;
        }

        @Contract(value="_->this")
        public W subMap(Iterable<?> cols) {
            this.value = BigDecimalUtil.subMap(this.value, cols);
            return this;
        }

        @Contract(value="_,_->this")
        public <T> W subMap(Iterable<T> cols, Function<? super T, ?> mapper) {
            this.value = BigDecimalUtil.subMap(this.value, cols, mapper);
            return this;
        }

        @Contract(value="_->this")
        public W mul(int a) {
            this.value = BigDecimalUtil.mul((Object)this.value, a);
            return this;
        }

        @Contract(value="_->this")
        public W mul(long a) {
            this.value = BigDecimalUtil.mul((Object)this.value, a);
            return this;
        }

        @Contract(value="_->this")
        public W mul(double a) {
            this.value = BigDecimalUtil.mul((Object)this.value, a);
            return this;
        }

        @Contract(value="_->this")
        public W mul(Object a) {
            this.value = BigDecimalUtil.mul((Object)this.value, a);
            return this;
        }

        @Contract(value="_,_->this")
        public W mul(Object a, Object ... num) {
            this.value = BigDecimalUtil.mul(this.value, a, num);
            return this;
        }

        @Contract(value="_,_,_->this")
        public W mulIf(boolean c, Object a, Object b) {
            BigDecimal num = c ? BigDecimalUtil.object(a) : BigDecimalUtil.object(b);
            this.value = BigDecimalUtil.mul((Object)this.value, num);
            return this;
        }

        @Contract(value="_,_,_->this")
        public W mulIf(boolean c, Supplier<?> a, Supplier<?> b) {
            BigDecimal num = c ? BigDecimalUtil.object(a) : BigDecimalUtil.object(b);
            this.value = BigDecimalUtil.mul((Object)this.value, num);
            return this;
        }

        @Contract(value="_->this")
        public W mulMap(Iterable<?> cols) {
            BigDecimal x = BigDecimalUtil.mulMapNull(cols);
            this.value = BigDecimalUtil.mul((Object)this.value, x);
            return this;
        }

        @Contract(value="_,_->this")
        public <T> W mulMap(Iterable<T> cols, Function<? super T, ?> mapper) {
            BigDecimal x = BigDecimalUtil.mulMapNull(cols, mapper);
            this.value = BigDecimalUtil.mul((Object)this.value, x);
            return this;
        }

        @Contract(value="_->this")
        public W div(int a) {
            this.value = BigDecimalUtil.div((Object)this.value, a);
            return this;
        }

        @Contract(value="_->this")
        public W div(long a) {
            this.value = BigDecimalUtil.div((Object)this.value, a);
            return this;
        }

        @Contract(value="_->this")
        public W div(double a) {
            this.value = BigDecimalUtil.div((Object)this.value, a);
            return this;
        }

        @Contract(value="_->this")
        public W div(Object a) {
            this.value = BigDecimalUtil.div((Object)this.value, a);
            return this;
        }

        @Contract(value="_,_->this")
        public W div(Object a, Object ... num) {
            this.value = BigDecimalUtil.div(this.value, a, num);
            return this;
        }

        @Contract(value="_,_,_->this")
        public W divIf(boolean c, Object a, Object b) {
            BigDecimal num = c ? BigDecimalUtil.object(a) : BigDecimalUtil.object(b);
            this.value = BigDecimalUtil.div((Object)this.value, num);
            return this;
        }

        @Contract(value="_,_,_->this")
        public W divIf(boolean c, Supplier<?> a, Supplier<?> b) {
            BigDecimal num = c ? BigDecimalUtil.object(a) : BigDecimalUtil.object(b);
            this.value = BigDecimalUtil.div((Object)this.value, num);
            return this;
        }

        @Contract(value="_->this")
        public W divMap(Iterable<?> cols) {
            this.value = BigDecimalUtil.divMap(this.value, cols);
            return this;
        }

        @Contract(value="_,_->this")
        public <T> W divMap(Iterable<T> cols, Function<? super T, ?> mapper) {
            this.value = BigDecimalUtil.divMap(this.value, cols, mapper);
            return this;
        }

        @Contract(value="->this")
        public W neg() {
            this.value = this.value.negate(MC);
            return this;
        }

        @Contract(value="_->this")
        public W pow(int n) {
            this.value = this.value.pow(n, MC);
            return this;
        }

        @Contract(value="_->this")
        public W ceil(int scale) {
            this.value = BigDecimalUtil.ceil(this.value, scale);
            return this;
        }

        @Contract(value="_->this")
        public W round(int scale) {
            this.value = BigDecimalUtil.round(this.value, scale);
            return this;
        }

        @Contract(value="_->this")
        public W floor(int scale) {
            this.value = BigDecimalUtil.floor(this.value, scale);
            return this;
        }
    }
}

