/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.mirana.pain;

import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pro.fessional.mirana.data.CodeEnum;
import pro.fessional.mirana.data.Null;
import pro.fessional.mirana.evil.TweakingContext;
import pro.fessional.mirana.i18n.I18nAware;
import pro.fessional.mirana.i18n.I18nString;

public class CodeException
extends RuntimeException
implements I18nAware {
    private static final long serialVersionUID = 19791023L;
    public static final boolean DefaultStack = false;
    public static final TweakingCodeException TweakStack = new TweakingCodeException(false);
    private final String code;
    private String i18nCode;
    private Object[] i18nArgs;

    public CodeException(String code) {
        this(TweakStack.current(code, null, null), code, null);
    }

    public CodeException(String code, String message) {
        this(TweakStack.current(code, null, null), code, message);
    }

    public CodeException(CodeEnum code) {
        this(TweakStack.current(code, null, null), code, Null.Objects);
    }

    public CodeException(CodeEnum code, Object ... args) {
        this(TweakStack.current(code, null, null), code, args);
    }

    public CodeException(boolean stack, String code) {
        this(stack, code, null);
    }

    public CodeException(boolean stack, String code, String message) {
        super(message == null ? Null.notNull(code) : message, null, true, stack);
        if (code == null) {
            this.code = "";
            this.i18nCode = null;
        } else {
            this.code = code;
            this.i18nCode = code;
        }
    }

    public CodeException(boolean stack, CodeEnum code) {
        this(stack, code, Null.Objects);
    }

    public CodeException(boolean stack, CodeEnum code, Object ... args) {
        this(stack, code == null ? "" : code.getCode(), code == null ? "" : code.getHint());
        if (code != null) {
            this.i18nCode = code.getI18nCode();
            this.i18nArgs = args;
        }
    }

    public CodeException(Throwable cause, String code) {
        this(cause, code, null);
    }

    public CodeException(Throwable cause, String code, String message) {
        super(Null.notNull(message), cause);
        if (code == null) {
            this.code = "";
            this.i18nCode = null;
        } else {
            this.code = code;
            this.i18nCode = code;
        }
    }

    public CodeException(Throwable cause, CodeEnum code) {
        this(cause, code, Null.Objects);
    }

    public CodeException(Throwable cause, CodeEnum code, Object ... args) {
        super(code == null ? "" : code.getHint(), cause);
        if (code == null) {
            this.code = "";
            this.i18nCode = null;
        } else {
            this.code = code.getCode();
            this.i18nCode = code.getI18nCode();
            this.i18nArgs = args;
        }
    }

    @NotNull
    public String getCode() {
        return this.code;
    }

    @Contract(value="_,_->this")
    public CodeException withI18n(String code, Object ... args) {
        if (code != null) {
            this.i18nCode = code;
        }
        if (args != null && args.length > 0) {
            this.i18nArgs = args;
        }
        return this;
    }

    @Override
    @NotNull
    public I18nString toI18nString(String hint) {
        if (hint == null || hint.isEmpty()) {
            return new I18nString(this.i18nCode, this.getMessage(), this.i18nArgs);
        }
        return new I18nString(this.i18nCode, hint, this.i18nArgs);
    }

    @Override
    public String getI18nCode() {
        return this.i18nCode;
    }

    @Override
    public Object[] getI18nArgs() {
        return this.i18nArgs;
    }

    public static class TweakingCodeException
    extends TweakingContext<Boolean> {
        public final ConcurrentHashMap<String, Boolean> tweakCode = new ConcurrentHashMap();
        public final ConcurrentHashMap<Class<? extends CodeException>, Boolean> tweakClass = new ConcurrentHashMap();

        public TweakingCodeException(boolean initDefault) {
            super(initDefault);
        }

        public boolean current(@Nullable String code, Class<? extends CodeException> claz, Boolean elze) {
            Boolean boolClaz;
            Boolean boolCode;
            Boolean bl = boolCode = code == null || code.isEmpty() ? null : this.tweakCode.get(code);
            if (boolCode != null) {
                return boolCode;
            }
            Boolean bl2 = boolClaz = claz == null ? null : this.tweakClass.get(claz);
            if (boolClaz != null) {
                return boolClaz;
            }
            return elze != null ? elze.booleanValue() : ((Boolean)TweakStack.current(true)).booleanValue();
        }

        public boolean current(@Nullable CodeEnum code, Class<? extends CodeException> claz, Boolean elze) {
            return this.current(code == null ? null : code.getCode(), claz, elze);
        }

        public void tweakCode(@NotNull String code, boolean stack) {
            this.tweakCode.put(code, stack);
        }

        public void tweakCode(@NotNull CodeEnum code, boolean stack) {
            this.tweakCode.put(code.getCode(), stack);
        }

        public void resetCode(@NotNull String code) {
            this.tweakCode.remove(code);
        }

        public void resetCode(@NotNull CodeEnum code) {
            this.tweakCode.remove(code.getCode());
        }

        public void tweakClass(@NotNull Class<? extends CodeException> claz, boolean stack) {
            this.tweakClass.put(claz, stack);
        }

        public void resetClass(@NotNull Class<? extends CodeException> claz) {
            this.tweakClass.remove(claz);
        }
    }
}

