/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.mirana.text;

import java.util.function.Function;
import java.util.stream.IntStream;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import pro.fessional.mirana.evil.ThreadLocalAttention;
import pro.fessional.mirana.text.BuilderHolder;

public class BuilderHelper {
    private static final BuilderHolder Holder;

    @Contract(value="_,_->param1")
    public static StringBuilder append(@NotNull StringBuilder sb, Object obj) {
        if (obj == null) {
            return sb;
        }
        if (obj instanceof char[]) {
            sb.append((char[])obj);
        } else {
            sb.append(obj);
        }
        return sb;
    }

    @Contract(value="_->param1")
    public static StringBuilder delete(@NotNull StringBuilder sb) {
        sb.setLength(0);
        return sb;
    }

    @Contract(value="_,_->param1")
    public static StringBuilder delete(@NotNull StringBuilder sb, int count) {
        if (count <= 0) {
            return sb;
        }
        int len = sb.length() - count;
        sb.setLength(Math.max(len, 0));
        return sb;
    }

    @Contract(value="_,_,_->param1")
    public static StringBuilder join(@NotNull StringBuilder sb, String joiner, Object ... arr) {
        return BuilderHelper.join(sb, false, joiner, arr);
    }

    @Contract(value="_,_,_,_->param1")
    public static StringBuilder join(@NotNull StringBuilder sb, boolean skipNull, String joiner, Object ... arr) {
        if (arr == null || arr.length == 0) {
            return sb;
        }
        if (arr[0] != null) {
            sb.append(arr[0]);
        }
        for (int i = 1; i < arr.length; ++i) {
            if (arr[i] != null || !skipNull) {
                sb.append(joiner);
            }
            if (arr[i] == null) continue;
            sb.append(arr[i]);
        }
        return sb;
    }

    @Contract(value="_,_,_->param1")
    public static StringBuilder join(@NotNull StringBuilder sb, String jn, Iterable<?> arr) {
        return BuilderHelper.join(sb, false, jn, arr);
    }

    @Contract(value="_,_,_,_->param1")
    public static StringBuilder join(@NotNull StringBuilder sb, boolean skipNull, String jn, Iterable<?> arr) {
        if (arr == null) {
            return sb;
        }
        int len = sb.length();
        for (Object o : arr) {
            if (o != null) {
                sb.append(o);
            }
            if (o == null && skipNull) continue;
            sb.append(jn);
        }
        if (sb.length() > len) {
            BuilderHelper.delete(sb, jn.length());
        }
        return sb;
    }

    @Contract(value="_,_,_,_->param1")
    public static <T, R> StringBuilder join(@NotNull StringBuilder sb, String jn, Iterable<T> arr, Function<T, R> fn) {
        return BuilderHelper.join(sb, false, jn, arr, fn);
    }

    @Contract(value="_,_,_,_,_->param1")
    public static <T, R> StringBuilder join(@NotNull StringBuilder sb, boolean skipNull, String jn, Iterable<T> arr, Function<T, R> fn) {
        if (arr == null) {
            return sb;
        }
        int len = sb.length();
        for (T t : arr) {
            R o = fn.apply(t);
            if (o != null) {
                sb.append(o);
            }
            if (o == null && skipNull) continue;
            sb.append(jn);
        }
        if (sb.length() > len) {
            BuilderHelper.delete(sb, jn.length());
        }
        return sb;
    }

    public static W w() {
        return new W((StringBuilder)Holder.use());
    }

    public static W w(StringBuilder sb) {
        return new W(sb);
    }

    static {
        try {
            Holder = new BuilderHolder();
        }
        catch (ThreadLocalAttention e) {
            throw new IllegalStateException(e);
        }
    }

    public static class W
    implements Appendable,
    CharSequence {
        public final StringBuilder builder;

        public W(StringBuilder builder) {
            this.builder = builder;
        }

        public StringBuilder result() {
            return this.builder;
        }

        @Contract(value="->this")
        public W delete() {
            BuilderHelper.delete(this.builder);
            return this;
        }

        @Contract(value="_->this")
        public W delete(int count) {
            BuilderHelper.delete(this.builder, count);
            return this;
        }

        @Contract(value="_,_->this")
        public W delete(int s, int e) {
            this.builder.delete(s, e);
            return this;
        }

        @Contract(value="_,_->this")
        public W join(String jn, Object ... arr) {
            BuilderHelper.join(this.builder, jn, arr);
            return this;
        }

        @Contract(value="_,_->this")
        public W join(String jn, Iterable<?> arr) {
            BuilderHelper.join(this.builder, jn, arr);
            return this;
        }

        @Contract(value="_,_,_->this")
        public <T, R> W join(String jn, Iterable<T> arr, Function<T, R> fun) {
            BuilderHelper.join(this.builder, jn, arr, fun);
            return this;
        }

        @Contract(value="_,_,_->this")
        public W join(boolean skipNull, String jn, Object ... arr) {
            BuilderHelper.join(this.builder, skipNull, jn, arr);
            return this;
        }

        @Contract(value="_,_,_->this")
        public W join(boolean skipNull, String jn, Iterable<?> arr) {
            BuilderHelper.join(this.builder, skipNull, jn, arr);
            return this;
        }

        @Contract(value="_,_,_,_->this")
        public <T, R> W join(boolean skipNull, String jn, Iterable<T> arr, Function<T, R> fun) {
            BuilderHelper.join(this.builder, skipNull, jn, arr, fun);
            return this;
        }

        @Contract(value="_->this")
        public W append(boolean v) {
            this.builder.append(v);
            return this;
        }

        @Contract(value="_->this")
        public W append(int v) {
            this.builder.append(v);
            return this;
        }

        @Contract(value="_->this")
        public W append(long v) {
            this.builder.append(v);
            return this;
        }

        @Contract(value="_->this")
        public W append(float v) {
            this.builder.append(v);
            return this;
        }

        @Contract(value="_->this")
        public W append(double v) {
            this.builder.append(v);
            return this;
        }

        @Contract(value="_->this")
        public W append(char[] v) {
            this.builder.append(v);
            return this;
        }

        @Contract(value="_->this")
        public W append(StringBuffer v) {
            this.builder.append(v);
            return this;
        }

        @Contract(value="_,_,_->this")
        public W append(char[] v, int s, int e) {
            this.builder.append(v, s, e);
            return this;
        }

        @Contract(value="_->this")
        public W append(Object v) {
            if (v != null) {
                this.builder.append(v);
            }
            return this;
        }

        @Override
        @Contract(value="_->this")
        public W append(CharSequence v) {
            if (v != null) {
                this.builder.append(v);
            }
            return this;
        }

        @Override
        @Contract(value="_,_,_->this")
        public W append(CharSequence csq, int start, int end) {
            if (csq != null) {
                this.builder.append(csq, start, end);
            }
            return this;
        }

        @Override
        @Contract(value="_->this")
        public W append(char c) {
            this.builder.append(c);
            return this;
        }

        @Override
        @NotNull
        public IntStream chars() {
            return this.builder.chars();
        }

        @Override
        @NotNull
        public IntStream codePoints() {
            return this.builder.codePoints();
        }

        @Override
        public int length() {
            return this.builder.length();
        }

        @Override
        public char charAt(int index) {
            return this.builder.charAt(index);
        }

        @Override
        @NotNull
        public CharSequence subSequence(int start, int end) {
            return this.builder.subSequence(start, end);
        }

        @Override
        @NotNull
        public String toString() {
            return this.builder.toString();
        }
    }
}

